<?php
/**
 * View: Default Template for Events
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe/events/v2/default-template.php
 *
 * See more documentation about our views templating system.
 *
 * @link http://evnt.is/1aiy
 *
 * @version 5.0.0
 */

use Tribe\Events\Views\V2\Template_Bootstrap;

get_header(); ?>
<div class="block-center max-width-1200">
    <?php
    the_ikosz_title('#f1b500',__('[:en]Events [:hu]Események'));

    ?>
<div class="event-category-wrapper has-side-padding">

    <h2> <?php _e('[:en]Categories [:hu]Kategóriák'); ?> </h2>
    <?php
    $terms = get_terms( array(
        'taxonomy' => 'tribe_events_cat',
        'hide_empty' => false,
    ) );
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
        echo '<div class="event-category-container">';
        echo '<a data-name=esemenyek href="/esemenyek">'.__('[:en]All [:hu]Minden').'</a>';
        foreach ( $terms as $term ) {
            echo '<a data-name='.$term->slug.' href="'.get_term_link($term).'">' . $term->name . '</a>';
        }
        echo '</div>';
    }

    ?>
</div>
<?php
echo tribe( Template_Bootstrap::class )->get_view_html(); ?>
</div>
    <script>
        const isSingle = document.getElementsByClassName('tribe-events-single').length;
        if(isSingle) {
            document.getElementsByClassName('event-category-wrapper')[0].style.display = 'none';
        }
        const url = (window.location.href).slice(0, -1)
        const slug = url.substring(url.lastIndexOf('/') + 1);
        const element = document.querySelectorAll(`[data-name="${slug}"]`);
        console.log(slug);
        element[0].classList.add("category-active");

    </script>
<?php get_footer();
