<?php
get_header();
?>
<?php if (have_posts()) : ?>
    <?php while (have_posts()) : the_post(); ?>
        <div class="block-center max-width-1400">
            <?php the_ikosz_title(); ?>
            <div class="member-wrapper">
                <div class="member-container">
                    <section class="member-content">
                        <p><?php the_content(); ?></p>
                    </section>
                    <aside class="member-aside">
                        <div class="member-logo-wrapper">
                            <?php
                            $logo = get_field('logo');
                            $image = wp_get_attachment_image($logo, 'full', "", array());
                            if ($image) echo $image;
                            ?>
                        </div>
                        <?php
                        $ceg_info = get_field('ceg_info');
                        $projektek = get_field('projektek');
                        ?>

                        <?php if ($ceg_info['szekhely'] || $ceg_info['szekhely_2']) : ?>
                            <div class="container-aside">
                                <p><strong><?php _e('[:en]Located at [:hu]Székhely') ?>:</strong></p>
                                <?php if ($ceg_info['szekhely']) : ?>
                                    <p><?= $ceg_info['szekhely']; ?></p> <?php endif; ?>
                                <?php if ($ceg_info['szekhely_2']) : ?>
                                    <p><?= $ceg_info['szekhely_2']; ?></p> <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($ceg_info['kepviselo'] || $ceg_info['kepviselo_2']) : ?>
                            <div class="container-aside">
                                <p><strong><?php _e('[:en]Representative [:hu]Képviselő') ?>:</strong></p>
                                <?php if ($ceg_info['kepviselo']) : ?>
                                    <p><?= $ceg_info['kepviselo']; ?></p> <?php endif; ?>
                                <?php if ($ceg_info['kepviselo_2']) : ?>
                                    <p><?= $ceg_info['kepviselo_2']; ?></p> <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($ceg_info['honlap'] || $ceg_info['honlap_2']) : ?>
                            <div class="container-aside">
                                <p><strong><?php _e('[:en]Website [:hu]Honlap') ?>:</strong></p>
                                <?php if ($ceg_info['honlap']) : ?> <p><a
                                            href="<?= $ceg_info['honlap']; ?>"><?= $ceg_info['honlap']; ?></a>
                                </p> <?php endif; ?>
                                <?php if ($ceg_info['honlap_2']) : ?> <p><a
                                            href="<?= $ceg_info['honlap_2']; ?>"><?= $ceg_info['honlap_2']; ?></a>
                                </p> <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($ceg_info['e-mail'] || $ceg_info['e-mail_2']) : ?>
                            <div class="container-aside">
                                <p><strong>E-mail:</strong></p>
                                <?php if ($ceg_info['e-mail']) : ?> <p><a
                                            href="mailto:<?= $ceg_info['e-mail']; ?>"><?= $ceg_info['e-mail']; ?></a>
                                </p> <?php endif; ?>
                                <?php if ($ceg_info['e-mail_2']) : ?> <p><a
                                            href="mailto:<?= $ceg_info['e-mail_2']; ?>"><?= $ceg_info['email_2']; ?></a>
                                </p> <?php endif; ?>
                            </div>
                        <?php endif; ?>

                        <?php if ($ceg_info['telefonszam'] || $ceg_info['telefonszam_2']) : ?>
                            <div class="container-aside">
                                <p><strong>Tel.:</strong></p>
                                <?php if ($ceg_info['telefonszam']) : ?>
                                    <p><?= $ceg_info['telefonszam']; ?></p> <?php endif; ?>
                                <?php if ($ceg_info['telefonszam_2']) : ?>
                                    <p><?= $ceg_info['telefonszam_2']; ?></p> <?php endif; ?>
                            </div>
                        <?php endif; ?>
                        <?php if (
                            /* xd... */
                            $projektek['projekt_1']['nev'] ||
                            $projektek['projekt_2']['nev'] ||
                            $projektek['projekt_3']['nev'] ||
                            $projektek['projekt_4']['nev'] ||
                            $projektek['projekt_5']['nev']
                        ) : ?>
                            <div class="container-aside">
                                <p><strong><?php _e('[:en]Projects [:hu]Projektek') ?>:</strong></p>
                                <?php if ($projektek['projekt_1']['nev']) : ?>
                                    <div class="member-aside-single-project-wrapper">
                                        <p><?= $projektek['projekt_1']['nev']; ?></p>
                                        <p><?= $projektek['projekt_1']['leiras']; ?></p>
                                        <a href="<?= $projektek['projekt_1']['link']; ?>"><?= $projektek['projekt_1']['link']; ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($projektek['projekt_2']['nev']) : ?>
                                    <div class="member-aside-single-project-wrapper">
                                        <p><?= $projektek['projekt_2']['nev']; ?></p>
                                        <p><?= $projektek['projekt_2']['leiras']; ?></p>
                                        <a href="<?= $projektek['projekt_2']['link']; ?>"><?= $projektek['projekt_2']['link']; ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($projektek['projekt_3']['nev']) : ?>
                                    <div class="member-aside-single-project-wrapper">
                                        <p><?= $projektek['projekt_3']['nev']; ?></p>
                                        <p><?= $projektek['projekt_3']['leiras']; ?></p>
                                        <a href="<?= $projektek['projekt_3']['link']; ?>"><?= $projektek['projekt_3']['link']; ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($projektek['projekt_4']['nev']) : ?>
                                    <div class="member-aside-single-project-wrapper">
                                        <p><?= $projektek['projekt_4']['nev']; ?></p>
                                        <p><?= $projektek['projekt_4']['leiras']; ?></p>
                                        <a href="<?= $projektek['projekt_4']['link']; ?>"><?= $projektek['projekt_4']['link']; ?></a>
                                    </div>
                                <?php endif; ?>
                                <?php if ($projektek['projekt_5']['nev']) : ?>
                                    <div class="member-aside-single-project-wrapper">
                                        <p><?= $projektek['projekt_5']['nev']; ?></p>
                                        <p><?= $projektek['projekt_5']['leiras']; ?></p>
                                        <a href="<?= $projektek['projekt_5']['link']; ?>"><?= $projektek['projekt_5']['link']; ?></a>
                                    </div>
                                <?php endif; ?>
                            </div>
                        <?php endif; ?>
                    </aside>
                </div>
            </div>
        </div><!-- #main -->
        <?php
        $author = get_the_author_meta('display_name', $post->post_author);
        if ($author != 'admin') : ?>
            <?php
            global $post;
            $events = tribe_get_events([
                'posts_per_page' => 3,
                'eventDisplay' => 'list',
                'ends_after' => 'now',
                'author' => $post->post_author
            ]);
            if ($events) { ?>
                <div class="block-wrapper">
                <?php the_ikosz_title('#F1B500', __('[:en]Member events [:hu]Tag eseményei'), 'ikosz'); ?>
                <div class="block-center max-width-1200 frontpage-block">
                <div class="front-page-event-container front-page-esemenyek">
                    <?php
                    foreach ($events as $post) {
                        setup_postdata($post); ?>


                        <div class="card-wrapper event-card">
                            <a class="card" href="<?= get_permalink(); ?>">
                                <?php
                                if (has_post_thumbnail($post)) {
                                    echo get_the_post_thumbnail();
                                } else {
                                    ?> <img src="<?= get_template_directory_uri() ?>/img/event.svg"
                                            alt=""> <?php
                                }
                                ?>
                                <h2><?php the_title(); ?></h2>
                                <p class="default-card-excerpt"><?= get_the_excerpt(); ?></p>
                                <div class="date-next-wrapper">
                                    <div class="event-card-date">
                                        <p><?php echo tribe_get_start_date($post); ?> </p>
                                        <p><?php echo tribe_get_end_date($post); ?> </p>
                                    </div>
                                    <p class="default-card-button">Tovább</p>
                                </div>
                            </a>
                        </div>
                    <?php } ?>
                </div>
                <?php
                wp_reset_postdata();
            }

            ?>
            </div>
            </div>
        <? endif; ?>
    <?php endwhile; ?>
<?php endif; ?>
<?php
get_footer();
?>
