<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ikosz
 */

?>
<!doctype html>
<!--
 ____  ____  ____  _____ ____    ____ ___  _
/   _\/  _ \/  _ \/  __//  _ \  /  _ \\  \//    /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\ /\
|  /  | / \|| | \||  \  | | \|  | | // \  /    / // // // // // // // // // // // // // // // // // // // /
|  \__| \_/|| |_/||  /_ | |_/|  | |_\\ / /    / // // // // // // // // // // // // // // // // // // // /
\____/\____/\____/\____\\____/  \____//_/     \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/ \/

 _____ _____ _____ _ ___  _      _      ____  ____  _  __ _____ _____  _  _      _____   _  __ _____ _____
/  __//    //    // \\  \//     / \__/|/  _ \/  __\/ |/ //  __//__ __\/ \/ \  /|/  __/  / |/ //    //__ __\
|  \  |  __\|  __\| | \  /_____ | |\/||| / \||  \/||   / |  \    / \  | || |\ ||| |  _  |   / |  __\  / \
|  /_ | |   | |   | | /  \\____\| |  ||| |-|||    /|   \ |  /_   | |  | || | \||| |_//  |   \ | |     | |__
\____\\_/   \_/   \_//__/\\     \_/  \|\_/ \|\_/\_\\_|\_\\____\  \_/  \_/\_/  \|\____\  \_|\_\\_/     \_/\/ 
-->
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site">
    <div class="ikosz-background-decoration"></div>
    <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e('Skip to content', 'ikosz'); ?></a>

    <header id="masthead" class="site-header">


        <nav class="nav">
            <div class="hamburger-menu">
                <div class="line line-1"></div>
                <div class="line line-2"></div>
                <div class="line line-3"></div>
            </div>
            <a class="logo-link" href="<?php echo home_url(); ?>">
                <img class="logo"
                     src="<?= get_stylesheet_directory_uri() ?>/img/ikosz_logo.svg">
            </a>
            <div class="search-menu-container">
                <div class="top-menu-search-and-language-container">
                    <?php dynamic_sidebar('header-flag'); ?>
                </div>
                <div class="inner-menu-container">
                    <?php
                    wp_nav_menu(
                        array(
                            'theme_location' => 'menu-1',
                            'menu_class' => 'top-menu-bar',
                            'container_class' => 'top-menu-container',
                        )
                    );
                    ?>
                </div>
            </div>
        </nav>
    </header><!-- #masthead -->
    <main id="primary">