<?php
/**
 * ikosz functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package ikosz
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'ikosz_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function ikosz_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on ikosz, use a find and replace
		 * to change 'ikosz' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'ikosz', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.

        register_nav_menus(
            array(
                'menu-1' => esc_html__( 'Primary', 'ikosz' ),
                'footer' => esc_html__( 'Footer', 'ikosz' ),
            )
        );

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'ikosz_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'ikosz_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function ikosz_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'ikosz_content_width', 640 );
}
add_action( 'after_setup_theme', 'ikosz_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function ikosz_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'ikosz' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'ikosz' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'ikosz_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function ikosz_scripts() {
	wp_enqueue_style( 'ikosz-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'ikosz-style', 'rtl', 'replace' );

    wp_enqueue_style('custom-css-2',get_template_directory_uri() . '/css/custom-styles-2.css');
    wp_enqueue_style('custom-css',get_template_directory_uri() . '/css/custom-styles.css');

    wp_enqueue_style('slick1',get_template_directory_uri() . '/css/slick-theme.min.css');
    wp_enqueue_style('slick2',get_template_directory_uri() . '/css/slick.min.css');

    wp_enqueue_script('hamburger',get_template_directory_uri() . '/js/hamburger.js',array('jquery'), _S_VERSION, true );

    wp_enqueue_script('slick',get_template_directory_uri() . '/js/slick.min.js',array(),'1.0.0',true);

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'ikosz_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

add_action('init', 'take_away_publish_permissions');
function take_away_publish_permissions() {
    /* from plugin
    $user = get_role('author');
    $user->add_cap('publish_posts', false);
    $user->add_cap('delete_posts', false);
    $user->add_cap('delete_published_members', false);
    $user->add_cap( 'publish_tribe_events', true );
    return;
    */
}



function hide_admin_bar(){ return false; }
add_filter( 'show_admin_bar', 'hide_admin_bar' );


function remove_menu_pages() {
    if (isAuthorUser()) {
        remove_menu_page('wpcf7'); // Contact Form 7 Menu
        remove_menu_page('edit-comments.php'); // remove comments
        remove_menu_page('index.php');
        remove_menu_page( 'tools.php' );
        remove_menu_page( 'profile.php' );
        remove_menu_page( 'edit.php?post_type=frontpage_blocks' );
        remove_menu_page( 'edit.php?post_type=projekt' );
        remove_menu_page( 'edit.php?post_type=partners' );
    }
}

add_action('admin_init', 'remove_menu_pages');


add_action( 'init', 'cp_change_post_object' );
// Change dashboard Posts to News
function cp_change_post_object() {
    $get_post_type = get_post_type_object('post');
    $labels = $get_post_type->labels;
    $labels->name = 'Hírek';
    $labels->singular_name = 'Hír';
    $labels->add_new = 'Új hír';
    $labels->add_new_item = 'Új hír';
    $labels->edit_item = 'Hír módosítása';
    $labels->new_item = 'Hír';
    $labels->view_item = 'Hír megtekintése';
    $labels->search_items = 'Hírek keresése';
    $labels->not_found = 'Nem található hír';
    $labels->not_found_in_trash = 'Nincs hír a szemetesben';
    $labels->all_items = 'Összes hír';
    $labels->menu_name = 'Hírek';
    $labels->name_admin_bar = 'Hírek';
}
add_action( 'init', 'change_members_object' );
// Change dashboard Posts to News
function change_members_object() {
    if(isAuthorUser()) {
        $get_post_type = get_post_type_object('members');
        $labels = $get_post_type->labels;
        $labels->menu_name = 'Tagság';
        $labels->name = 'Tagság';
    }
}




//Limiting individual authors' to their own posts and media
function posts_for_current_author($query) {
    global $pagenow;

    if ('edit.php' != $pagenow || !$query->is_admin)
        return $query;

    if (isAuthorUser()) {
        global $user_ID;
        $query->set('author', $user_ID);
    }
    return $query;
}

add_filter('pre_get_posts', 'posts_for_current_author');

//Limiting individual authors' to their own posts and media
add_filter('ajax_query_attachments_args', 'wpb_show_current_user_attachments');
function wpb_show_current_user_attachments($query) {
    $user_id = get_current_user_id();
    if ($user_id && isAuthorUser() && !current_user_can('edit_others_posts')) {
        $query['author'] = $user_id;
    }
    return $query;
}
//This code works great in the media library page (upload.php).
function my_files_only( $wp_query ) {
    if ( strpos( $_SERVER[ 'REQUEST_URI' ], '/wp-admin/upload.php' ) !== false ) {
        if ( isAuthorUser() ) {
            global $current_user;
            $wp_query->set( 'author', $current_user->ID );
        }
    }
}

add_filter('parse_query', 'my_files_only' );



function my_admin_theme_style_authors() {
    if(isAuthorUser()) wp_enqueue_style('my-admin-style', get_template_directory_uri() . '/css/custom-admin.css');
}
add_action('admin_enqueue_scripts', 'my_admin_theme_style_authors');

/*
function dashboard_redirect($url) {
    global $current_user;
    // is there a user ?
    if(is_array($user->roles)) {
        // check, whether user has the author role:
        if(in_array('author', $current_user->roles)) {
            $url = 'edit.php?post_type=cluster';
        }
        return $url;
    }
}
add_filter('login_redirect', 'dashboard_redirect');
*/

add_action('template_redirect', 'wpse_128636_redirect_post');

function wpse_128636_redirect_post() {
    if (is_singular('frontpage_blocks')) {
        wp_redirect(home_url(), 301);
        exit;
    }
}


function flag_widget_init() {
    register_sidebar( array(
        'name' => __( 'Header flag', 'headerflag' ),
        'id' => 'header-flag',
        'before_widget' => '<div class="language-selector-wrapper">',
        'after_widget' => '</div>'
    ) );
}
add_action( 'widgets_init', 'flag_widget_init' );


function dashboard_redirect2(){
    if(isAuthorUser()){
        wp_redirect(admin_url('edit.php?post_type=members'));
    }
}
function isAdminUser() {
    return current_user_can('activate_plugins');
}
function isAuthorUser() {
    $user = wp_get_current_user();
    if ( in_array( 'author', (array) $user->roles ) ) {
       return true;
    }
    return false;
}

add_action('load-index.php','dashboard_redirect2');

function cc_mime_types($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}

add_filter('upload_mimes', 'cc_mime_types');

add_action( 'admin_bar_menu', 'remove_wp_nodes', 999 );

function remove_wp_nodes()
{
    global $wp_admin_bar;
    $wp_admin_bar->remove_node('new-content');
    $wp_admin_bar->remove_node('comments');
}

function my_ajax_scripts() {
    /*
    if( is_page( array( 'tagok' ) ) ){
        wp_enqueue_script('ajax-filter-menu',get_template_directory_uri() . '/js/ajax-filter-menu.js', array('jquery'), null, true);
        wp_localize_script('ajax-filter-menu','wpAjax',array('ajaxUrl'=> admin_url('admin-ajax.php')));
    }
    */
}
add_action( 'wp_enqueue_scripts', 'my_ajax_scripts' );

/***************************************************/
// AJAX MEMBERS HANDLER
/***************************************************/

function filter_members_ajax(){
    $taxArray = array( 'relation' => 'AND' );

    foreach($_POST as $taxName => $terms){
        if(is_array($terms)) {
            array_push($taxArray,array(
                'taxonomy' => $taxName,   // taxonomy name
                'field' => 'term_id',
                'terms' => $terms,
                'operator' => 'IN'
            ));
        }
    }
    $args = array(
        'post_type'=>'members',
        'posts_per_page'=>-1,
        'orderby' => 'rand'
    );
    $args['tax_query'] = $taxArray;
    $query = new WP_Query($args); ?>

    <div class="filter-result">
        <div class="container frontpage-members-container">
            <?php
            if($query->have_posts()):
                while($query->have_posts()): $query->the_post();
                    get_template_part('template-parts/content-card','member');
                endwhile;
            else:
                ?> <h2><?php _e("Nem található a feltételeknek megfelelő Tag!","ikosz"); ?></h2> <?php
            endif;
            wp_reset_postdata();
            ?>
        </div>
    </div>
    <?php
    die();
}
add_action('wp_ajax_nopriv_filter-members','filter_members_ajax');
add_action('wp_ajax_filter-members','filter_members_ajax');

function displayTaxonomyAsMenu($name,$title) { ?>
    <div class="taxonomy-menu-item">
        <h3 class="filter-menu-tax-title"> <?= $title ?> <i class="fas fa-chevron-up"></i></h3>
        <ul class="toggle-menu">
            <?php $args = array(
                'suppress_filters' => false,
                'taxonomy'=>$name,
                'hide_empty'=>false,
                'parent' => false
            );
            $terms = get_terms($args); ?>
            <?php foreach($terms as $term): ?>
                <li> <label style="display: block; line-height: 1.5; cursor: pointer"> <input type="checkbox" name="<?= $name ?>[]" value="<?= $term->term_id ?>"><span><?= $term->name ?></span></label> </li>
            <?php endforeach; ?>
        </ul>
    </div>
<?php
}
function the_ikosz_title($color = '#29ABE2',$title = '') {
    if(!$color) $color='#29ABE2';
    ?>
    <div class="title-wrapper">
        <div style="position: absolute; background-color: <?= $color ?>; height: 100%; width: 100vw; left: 50%"></div>
        <div class="graphic-rects" style="background-color: <?= $color ?>">
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
            <div></div>
        </div>
        <h2 class="primary-title" style="background-color: <?= $color ?>">
            <?php
            if($title) {
                echo $title;
            } else {
                the_title();
            }
            ?></h2>
    </div>
<?php
}

function my_excerpt_length($length){
    return 20;
}
add_filter('excerpt_length', 'my_excerpt_length');

function my_sidebars(){
    register_sidebar(
        array(
            'name'=> 'Hírek Sidebar',
            'id'=>'hirek-sidebar'
        )
    );
}
add_action('widgets_init','my_sidebars');


add_action('user_register','register_member');

function register_member($user_id){
    $userData = get_userdata( $user_id );
    $user_roles = $userData->roles;
    if ( in_array( 'author', $user_roles, true ) ) {
        $tag_neve = get_field('tag_neve', 'user_'.$user_id);
        if($tag_neve) {
            $my_post = array(
                'post_title'    => get_field('tag_neve', 'user_'.$user_id),
                'post_content'  => '',
                'post_status'   => 'pending',
                'post_type'    => 'members',
                'post_author'   => $user_id
            );
            wp_insert_post( $my_post );
        }
    }
}
add_action( 'pre_get_posts', function ( $q )
{
    if (    !is_admin() // Only targets the front end
        && $q->is_main_query() // Only targets the main query
        && $q->is_archive( 'services' ) // Only targets the product-category tax pages
    ) {
        $q->set( 'orderby', 'rand' );
    }
});
function hide_update_noticee_to_all_but_admin_users()
{
    if (!is_super_admin()) {
        remove_all_actions( 'admin_notices' );
    }
}
add_action( 'admin_head', 'hide_update_noticee_to_all_but_admin_users', 1 );


function tribe_remove_organizers_from_events( $default_types ) {

    if (
        ! is_array( $default_types )
        || empty( $default_types )
        || empty( Tribe__Events__Main::ORGANIZER_POST_TYPE )
    ) {
        return $default_types;
    }

    if ( ( $key = array_search( Tribe__Events__Main::ORGANIZER_POST_TYPE, $default_types ) ) !== false ) {
        unset( $default_types[ $key ] );
    }

    return $default_types;
}


add_filter( 'tribe_events_register_default_linked_post_types', 'tribe_remove_organizers_from_events' );


/**
 * Hides the Organizer fields from The Events Calendar in the admin.
 *
 * @link http://theeventscalendar.com/?p=1051416
 */
add_action( 'admin_head', 'tribe_support_1051416' );
function tribe_support_1051416() {
    ?>
    <style>#event_organizer.eventtable { display: none !important;}</style>
    <?php
}
function isAuthor() {
    $author_id = get_the_author_meta('id');
    $user_meta = get_userdata($author_id);
    $user_roles = $user_meta->roles;

    return ($user_roles[0] === 'author');
}
function getmemberNameAndLink(){
    $title = '';
    $link = '';
    $args = array(
        'author' => get_the_author_meta('id'),
        'post_type' => 'members',
    );
    $author_posts = new WP_Query($args);
    if ($author_posts->have_posts()) {
        while ($author_posts->have_posts()) {
            $author_posts->the_post();
            $title = get_the_title();
            $link = get_permalink();
        }
        wp_reset_postdata();
    }
    return "<a href=".$link.">".$title."</a>";
}