/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-02-21 10:46:54 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `schedule` longtext COLLATE utf8mb4_unicode_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=685 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=298211 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=489954 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4154 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=827 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tec_events` (
  `event_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL,
  `start_date` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` varchar(19) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `timezone` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'UTC',
  `start_date_utc` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date_utc` varchar(19) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `duration` mediumint DEFAULT '7200',
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `hash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`event_id`),
  UNIQUE KEY `post_id` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tec_occurrences` (
  `occurrence_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `event_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `start_date` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `start_date_utc` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `end_date_utc` varchar(19) COLLATE utf8mb4_unicode_ci NOT NULL,
  `duration` mediumint DEFAULT '7200',
  `hash` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`occurrence_id`),
  UNIQUE KEY `hash` (`hash`),
  KEY `event_id` (`event_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  `term_order` int DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=57 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1203 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=3217 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=31828 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=5225 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11804 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=2037 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4966 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=85689 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_wpfm_backup` (
  `id` int NOT NULL AUTO_INCREMENT,
  `backup_name` text COLLATE utf8mb4_unicode_ci,
  `backup_date` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wpfront_ure_options` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `option_name` varchar(250) DEFAULT NULL,
  `option_value` longtext,
  UNIQUE KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

CREATE TABLE `wp_yoast_indexable` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext COLLATE utf8mb4_unicode_520_ci,
  `permalink_hash` varchar(40) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `object_id` bigint DEFAULT NULL,
  `object_type` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object_sub_type` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `author_id` bigint DEFAULT NULL,
  `post_parent` bigint DEFAULT NULL,
  `title` text COLLATE utf8mb4_unicode_520_ci,
  `description` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `breadcrumb_title` text COLLATE utf8mb4_unicode_520_ci,
  `post_status` varchar(20) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT '0',
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int unsigned DEFAULT NULL,
  `canonical` longtext COLLATE utf8mb4_unicode_520_ci,
  `primary_focus_keyword` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `primary_focus_keyword_score` int DEFAULT NULL,
  `readability_score` int DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT '0',
  `is_robots_noindex` tinyint(1) DEFAULT '0',
  `is_robots_nofollow` tinyint(1) DEFAULT '0',
  `is_robots_noarchive` tinyint(1) DEFAULT '0',
  `is_robots_noimageindex` tinyint(1) DEFAULT '0',
  `is_robots_nosnippet` tinyint(1) DEFAULT '0',
  `twitter_title` text COLLATE utf8mb4_unicode_520_ci,
  `twitter_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `twitter_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `twitter_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_title` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_description` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image` longtext COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_id` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `open_graph_image_source` text COLLATE utf8mb4_unicode_520_ci,
  `open_graph_image_meta` mediumtext COLLATE utf8mb4_unicode_520_ci,
  `link_count` int DEFAULT NULL,
  `incoming_link_count` int DEFAULT NULL,
  `prominent_words_version` int unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  `language` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `region` varchar(32) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_page_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schema_article_type` varchar(64) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT '0',
  `estimated_reading_time_minutes` int DEFAULT NULL,
  `version` int DEFAULT '1',
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=387 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int unsigned NOT NULL,
  `ancestor_id` int unsigned NOT NULL,
  `depth` int unsigned DEFAULT NULL,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint DEFAULT NULL,
  `term_id` bigint DEFAULT NULL,
  `taxonomy` varchar(32) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `blog_id` bigint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint unsigned DEFAULT NULL,
  `target_post_id` bigint unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int unsigned DEFAULT NULL,
  `target_indexable_id` int unsigned DEFAULT NULL,
  `height` int unsigned DEFAULT NULL,
  `width` int unsigned DEFAULT NULL,
  `size` int unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=176 DEFAULT CHARSET=utf8mb3;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "740", "instagram video downloader", "larue_consequatur@yahoo.com", "https://downloader.run/instagram-downloader/", "185.106.28.183", "2024-09-03 08:14:38", "2024-09-03 08:14:38", "Your blog is a treasure trove of valuable insights and thought-provoking commentary. Your dedication to your craft is evident in every word you write. Keep up the fantastic work!", "0", "spam", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "749", "instagram video downloader", "larue_consequatur@yahoo.com", "https://downloader.run/instagram-downloader/", "185.106.28.183", "2024-09-03 08:14:53", "2024-09-03 08:14:53", "Your blog is a treasure trove of valuable insights and thought-provoking commentary. Your dedication to your craft is evident in every word you write. Keep up the fantastic work!", "0", "spam", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "812", "pinterest video downloader mod apk latest version", "jamir_eum@gmail.com", "https://downloader.run/pinterest-downloader/", "172.236.1.128", "2024-11-01 21:04:20", "2024-11-01 21:04:20", "Your blog is a true hidden gem on the internet. Your thoughtful analysis and engaging writing style set you apart from the crowd. Keep up the excellent work!", "0", "spam", "", "comment", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("2", "20240305_ikosz", "2452a9ac53ba5d3d8349_20250221104640", "21", "2025-02-21 10:46:54", "introweb", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-21 10:46:40\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.41\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:2;s:4:\"Name\";s:14:\"20240305_ikosz\";s:4:\"Hash\";s:35:\"2452a9ac53ba5d3d8349_20250221104640\";s:8:\"NameHash\";s:50:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.2\";s:6:\"WPUser\";s:8:\"introweb\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:62:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/ikosz/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2376;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:13795;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-21 10:46:40\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.41\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20240305_ikosz\";s:4:\"Hash\";s:35:\"2452a9ac53ba5d3d8349_20250221104640\";s:8:\"NameHash\";s:50:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:68:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/ikosz/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:63:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:119:\"/home/ikosz/public_html/wp-content/backups-dup-lite/tmp/20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/ikosz/public_html/wp-admin\";i:1;s:35:\"/home/ikosz/public_html/wp-includes\";i:2;s:44:\"/home/ikosz/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/ikosz/public_html\";i:1;s:23:\"/home/ikosz/public_html\";i:2;s:34:\"/home/ikosz/public_html/wp-content\";i:3;s:42:\"/home/ikosz/public_html/wp-content/uploads\";i:4;s:42:\"/home/ikosz/public_html/wp-content/plugins\";i:5;s:45:\"/home/ikosz/public_html/wp-content/mu-plugins\";i:6;s:41:\"/home/ikosz/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/ikosz/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://ikosz.hu", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://ikosz.hu", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "ikosz", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "Innovatív Klaszterek Országos Szövetsége", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "web@effix.hu", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "1", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "0", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "Y.m.d.", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "H:i", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "Y.m.d. H:i", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:17:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:37:\"ajax-search-lite/ajax-search-lite.php\";i:2;s:47:\"better-search-replace/better-search-replace.php\";i:3;s:48:\"capability-manager-enhanced/capsman-enhanced.php\";i:4;s:33:\"classic-editor/classic-editor.php\";i:5;s:35:\"classic-widgets/classic-widgets.php\";i:6;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:7;s:25:\"duplicator/duplicator.php\";i:8;s:25:\"duplicator/duplicator.php\";i:9;s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";i:10;s:25:\"loginpress/loginpress.php\";i:11;s:35:\"qtranslate-xt-master/qtranslate.php\";i:12;s:31:\"search-filter/search-filter.php\";i:13;s:43:\"the-events-calendar/the-events-calendar.php\";i:14;s:23:\"wordfence/wordfence.php\";i:15;s:24:\"wordpress-seo/wp-seo.php\";i:16;s:39:\"wp-file-manager/file_folder_manager.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "0", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "", "no");
INSERT INTO `wp_options` VALUES("40", "template", "ikosz", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "ikosz", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "administrator", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:2;a:4:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:12:\"hierarchical\";i:0;s:8:\"dropdown\";i:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:4:{s:25:\"loginpress/loginpress.php\";a:2:{i:0;s:16:\"WPBRIGADE_Logger\";i:1;s:18:\"log_uninstallation\";}s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";s:15:\"hicpo_uninstall\";s:37:\"user-role-editor/user-role-editor.php\";a:2:{i:0;s:16:\"User_Role_Editor\";i:1;s:9:\"uninstall\";}s:23:\"wpsynchro/wpsynchro.php\";s:18:\"wpsynchroUninstall\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "33", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "6", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "569", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1755686763", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "initial_db_version", "49752", "yes");
INSERT INTO `wp_options` VALUES("99", "wp_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:164:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:15:\"manage_security\";b:1;s:21:\"hicpo_load_script_css\";b:1;s:23:\"hicpo_update_menu_order\";b:1;s:28:\"hicpo_update_menu_order_tags\";b:1;s:29:\"hicpo_update_menu_order_sites\";b:1;s:29:\"manage_capabilities_dashboard\";b:1;s:25:\"manage_capabilities_roles\";b:1;s:35:\"manage_capabilities_editor_features\";b:1;s:34:\"manage_capabilities_admin_features\";b:1;s:31:\"manage_capabilities_admin_menus\";b:1;s:36:\"manage_capabilities_profile_features\";b:1;s:29:\"manage_capabilities_nav_menus\";b:1;s:32:\"manage_capabilities_user_testing\";b:1;s:26:\"manage_capabilities_backup\";b:1;s:28:\"manage_capabilities_settings\";b:1;s:37:\"manage_capabilities_frontend_features\";b:1;s:27:\"hicpo_hicpo_load_script_css\";b:1;s:29:\"manage_capabilities_redirects\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:100:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;s:12:\"create_users\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:23:\"edit_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:21:\"hicpo_load_script_css\";b:1;s:23:\"hicpo_update_menu_order\";b:1;s:28:\"hicpo_update_menu_order_tags\";b:1;s:37:\"manage_capabilities_frontend_features\";b:1;s:27:\"hicpo_hicpo_load_script_css\";b:1;s:29:\"manage_capabilities_redirects\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:32:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:13:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:17:\"edit_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:17:\"edit_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:23:\"edit_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("100", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("101", "WPLANG", "hu_HU", "yes");
INSERT INTO `wp_options` VALUES("102", "widget_search", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("103", "widget_recent-posts", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("104", "widget_recent-comments", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:6:\"number\";i:5;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "widget_archives", "a:3:{i:2;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:0;s:8:\"dropdown\";i:0;}i:3;a:3:{s:5:\"title\";s:0:\"\";s:5:\"count\";i:1;s:8:\"dropdown\";i:1;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("106", "widget_meta", "a:2:{i:2;a:1:{s:5:\"title\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:5:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:6:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";i:3;s:10:\"archives-2\";i:4;s:12:\"categories-2\";i:5;s:6:\"meta-2\";}s:11:\"header-flag\";a:1:{i:0;s:12:\"qtranslate-2\";}s:13:\"hirek-sidebar\";a:1:{i:0;s:10:\"archives-3\";}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("108", "cron", "a:26:{i:1740134820;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1740134960;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740134965;a:1:{s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740135860;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1740137443;a:3:{s:24:\"tribe_common_log_cleanup\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:16:\"tribe_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"tribe_schedule_transient_purge\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740138550;a:1:{s:26:\"wordfence_daily_autoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740138565;a:1:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740142023;a:2:{s:13:\"wpseo-reindex\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"wpseo_permalink_structure_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740148395;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740151200;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"c1d89e2307476f7f61da984de05c2fbf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1740151200;}}}}i:1740152853;a:1:{s:41:\"WPSynchroPuc_cron_check_updates-wpsynchro\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740175460;a:2:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740206928;a:1:{s:24:\"wpb_data_sync_loginpress\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740218659;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740218677;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740218678;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1740276414;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1740405600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1740410400;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"da8bef777b6787e2c228abf4b52e3dcc\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1740410400;}}}}i:1740412800;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1740477859;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1740529726;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1740608593;a:1:{s:27:\"acf_update_site_health_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1740667931;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1740669600;a:1:{s:30:\"wordfence_start_scheduled_scan\";a:1:{s:32:\"a472c2be2eaa4cbe6184d4beb3f0d469\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:1740669600;}}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("109", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "theme_mods_twentytwentyone", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1620641171;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:8:\"search-2\";i:1;s:14:\"recent-posts-2\";i:2;s:17:\"recent-comments-2\";}s:9:\"sidebar-2\";a:3:{i:0;s:10:\"archives-2\";i:1;s:12:\"categories-2\";i:2;s:6:\"meta-2\";}}}}", "no");
INSERT INTO `wp_options` VALUES("120", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("121", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("151", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("154", "current_theme", "ikosz", "yes");
INSERT INTO `wp_options` VALUES("155", "theme_mods_ikosz", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:6:\"menu-1\";i:2;s:6:\"footer\";i:11;}s:18:\"custom_css_post_id\";i:-1;}", "yes");
INSERT INTO `wp_options` VALUES("156", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("161", "category_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("162", "nav_menu_options", "a:2:{i:0;b:0;s:8:\"auto_add\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("163", "recently_activated", "a:1:{s:23:\"wpsynchro/wpsynchro.php\";i:1709631528;}", "off");
INSERT INTO `wp_options` VALUES("170", "cptui_new_install", "false", "yes");
INSERT INTO `wp_options` VALUES("200", "loginpress_customization", "a:2:{s:18:\"gallery_background\";s:68:\"https://ikosz.hu/wp-content/plugins/loginpress/img/gallery/img-8.jpg\";s:20:\"setting_logo_display\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("201", "loginpress_setting", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("202", "loginpress_active_time", "1620724717", "no");
INSERT INTO `wp_options` VALUES("203", "loginpress_premium", "", "yes");
INSERT INTO `wp_options` VALUES("205", "_loginpress_optin", "yes", "yes");
INSERT INTO `wp_options` VALUES("224", "recovery_mode_email_last_sent", "1666899746", "yes");
INSERT INTO `wp_options` VALUES("277", "searchandfilter_version", "1.2.13", "yes");
INSERT INTO `wp_options` VALUES("278", "cptui_taxonomies", "a:1:{s:8:\"services\";a:25:{s:4:\"name\";s:8:\"services\";s:5:\"label\";s:16:\"Szolgáltatások\";s:14:\"singular_label\";s:14:\"Szolgáltatás\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:12:\"hierarchical\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:12:\"show_in_menu\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:1:\"1\";s:20:\"rewrite_hierarchical\";s:1:\"0\";s:17:\"show_admin_column\";s:5:\"false\";s:12:\"show_in_rest\";s:4:\"true\";s:18:\"show_in_quick_edit\";s:0:\"\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:6:\"labels\";a:19:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:11:\"update_item\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:13:\"new_item_name\";s:0:\"\";s:11:\"parent_item\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:13:\"popular_items\";s:0:\"\";s:26:\"separate_items_with_commas\";s:0:\"\";s:19:\"add_or_remove_items\";s:0:\"\";s:21:\"choose_from_most_used\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:8:\"no_terms\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:13:\"back_to_items\";s:0:\"\";}s:11:\"meta_box_cb\";s:0:\"\";s:12:\"default_term\";s:0:\"\";s:12:\"object_types\";a:2:{i:0;s:7:\"members\";i:1;s:8:\"partners\";}}}", "yes");
INSERT INTO `wp_options` VALUES("285", "activity_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("293", "acf_version", "6.3.12", "yes");
INSERT INTO `wp_options` VALUES("296", "qtranslate_admin_notices", "a:2:{s:17:\"gutenberg-support\";i:1620818532;s:15:\"initial-install\";i:1620818676;}", "yes");
INSERT INTO `wp_options` VALUES("297", "qtranslate_enabled_languages", "a:2:{i:0;s:2:\"hu\";i:1;s:2:\"en\";}", "yes");
INSERT INTO `wp_options` VALUES("298", "qtranslate_default_language", "hu", "yes");
INSERT INTO `wp_options` VALUES("299", "qtranslate_modules", "a:8:{s:3:\"acf\";i:1;s:19:\"all-in-one-seo-pack\";i:2;s:16:\"events-made-easy\";i:2;s:7:\"jetpack\";i:2;s:15:\"google-site-kit\";i:2;s:13:\"gravity-forms\";i:2;s:12:\"woo-commerce\";i:2;s:6:\"wp-seo\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("302", "qtranslate_admin_config", "a:7:{s:4:\"post\";a:3:{s:5:\"pages\";a:2:{s:8:\"post.php\";s:0:\"\";s:12:\"post-new.php\";s:0:\"\";}s:7:\"anchors\";a:1:{s:17:\"post-body-content\";a:1:{s:5:\"where\";s:10:\"first last\";}}s:5:\"forms\";a:2:{s:4:\"post\";a:1:{s:6:\"fields\";a:9:{s:5:\"title\";a:0:{}s:7:\"excerpt\";a:0:{}s:18:\"attachment_caption\";a:0:{}s:14:\"attachment_alt\";a:0:{}s:13:\"view-post-btn\";a:1:{s:6:\"encode\";s:7:\"display\";}s:14:\"wp-editor-area\";a:1:{s:6:\"jquery\";s:15:\".wp-editor-area\";}s:15:\"gallery-caption\";a:2:{s:6:\"jquery\";s:16:\".gallery-caption\";s:6:\"encode\";s:4:\"none\";}s:15:\"wp-caption-text\";a:2:{s:6:\"jquery\";s:16:\".wp-caption-text\";s:6:\"encode\";s:7:\"display\";}s:7:\"img-alt\";a:3:{s:6:\"jquery\";s:3:\"img\";s:5:\"attrs\";a:1:{i:0;s:3:\"alt\";}s:6:\"encode\";s:7:\"display\";}}}s:14:\"wpbody-content\";a:1:{s:6:\"fields\";a:2:{s:7:\"wrap-h1\";a:2:{s:6:\"jquery\";s:8:\".wrap h1\";s:6:\"encode\";s:7:\"display\";}s:7:\"wrap-h2\";a:2:{s:6:\"jquery\";s:8:\".wrap h2\";s:6:\"encode\";s:7:\"display\";}}}}}s:15:\"options-general\";a:3:{s:14:\"preg_delimiter\";s:1:\"#\";s:5:\"pages\";a:1:{s:19:\"options-general.php\";s:21:\"^(?!.*page=[^=&]+).*$\";}s:5:\"forms\";a:1:{s:7:\"options\";a:1:{s:6:\"fields\";a:3:{s:8:\"blogname\";a:0:{}s:15:\"blogdescription\";a:0:{}s:10:\"head-title\";a:2:{s:6:\"jquery\";s:10:\"head title\";s:6:\"encode\";s:7:\"display\";}}}}}s:7:\"widgets\";a:3:{s:5:\"pages\";a:1:{s:11:\"widgets.php\";s:0:\"\";}s:7:\"anchors\";a:1:{s:13:\"widgets-right\";a:1:{s:5:\"where\";s:12:\"before after\";}}s:5:\"forms\";a:1:{s:13:\"widgets-right\";a:1:{s:6:\"fields\";a:3:{s:12:\"widget-title\";a:1:{s:6:\"jquery\";s:34:\"input[id^=\'widget-\'][id$=\'-title\']\";}s:16:\"widget-text-text\";a:1:{s:6:\"jquery\";s:41:\"textarea[id^=\'widget-text-\'][id$=\'-text\']\";}s:15:\"in-widget-title\";a:2:{s:6:\"jquery\";s:20:\"span.in-widget-title\";s:6:\"encode\";s:7:\"display\";}}}}}s:9:\"edit-term\";a:2:{s:5:\"pages\";a:2:{s:8:\"term.php\";s:0:\"\";s:13:\"edit-tags.php\";s:11:\"action=edit\";}s:5:\"forms\";a:1:{s:7:\"edittag\";a:1:{s:6:\"fields\";a:3:{s:4:\"name\";a:0:{}s:11:\"description\";a:0:{}s:6:\"parent\";a:1:{s:6:\"encode\";s:7:\"display\";}}}}}s:9:\"edit-tags\";a:4:{s:14:\"preg_delimiter\";s:1:\"#\";s:5:\"pages\";a:1:{s:13:\"edit-tags.php\";s:21:\"^(?!.*action=edit).*$\";}s:7:\"anchors\";a:1:{s:12:\"posts-filter\";a:1:{s:5:\"where\";s:12:\"before after\";}}s:5:\"forms\";a:3:{s:6:\"addtag\";a:1:{s:6:\"fields\";a:3:{s:8:\"tag-name\";a:0:{}s:15:\"tag-description\";a:0:{}s:6:\"parent\";a:1:{s:6:\"encode\";s:7:\"display\";}}}s:8:\"col-left\";a:1:{s:6:\"fields\";a:1:{s:8:\"tagcloud\";a:2:{s:6:\"jquery\";s:13:\".tagcloud > a\";s:6:\"encode\";s:7:\"display\";}}}s:8:\"the-list\";a:1:{s:6:\"fields\";a:2:{s:9:\"row-title\";a:2:{s:6:\"jquery\";s:10:\".row-title\";s:6:\"encode\";s:7:\"display\";}s:11:\"description\";a:2:{s:6:\"jquery\";s:12:\".description\";s:6:\"encode\";s:7:\"display\";}}}}}s:9:\"nav-menus\";a:3:{s:5:\"pages\";a:1:{s:13:\"nav-menus.php\";s:23:\"action=edit|menu=\\d+|^$\";}s:7:\"anchors\";a:1:{s:12:\"menu-to-edit\";a:1:{s:5:\"where\";s:12:\"before after\";}}s:5:\"forms\";a:2:{s:15:\"update-nav-menu\";a:1:{s:6:\"fields\";a:5:{s:5:\"title\";a:1:{s:6:\"jquery\";s:27:\"[id^=edit-menu-item-title-]\";}s:10:\"attr-title\";a:1:{s:6:\"jquery\";s:32:\"[id^=edit-menu-item-attr-title-]\";}s:11:\"description\";a:1:{s:6:\"jquery\";s:33:\"[id^=edit-menu-item-description-]\";}s:10:\"span.title\";a:2:{s:6:\"jquery\";s:20:\"span.menu-item-title\";s:6:\"encode\";s:7:\"display\";}s:16:\"link-to-original\";a:2:{s:6:\"jquery\";s:20:\".link-to-original >a\";s:6:\"encode\";s:7:\"display\";}}}s:14:\"side-sortables\";a:1:{s:6:\"fields\";a:2:{s:11:\"label.title\";a:2:{s:6:\"jquery\";s:21:\"label.menu-item-title\";s:6:\"encode\";s:7:\"display\";}s:23:\"accordion-section-title\";a:2:{s:6:\"jquery\";s:26:\"h3.accordion-section-title\";s:6:\"encode\";s:7:\"display\";}}}}}s:9:\"all-pages\";a:1:{s:7:\"filters\";a:1:{s:4:\"text\";a:1:{s:11:\"admin_title\";s:2:\"20\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("303", "qtranslate_front_config", "a:1:{s:9:\"all-pages\";a:1:{s:7:\"filters\";a:3:{s:4:\"text\";a:11:{s:12:\"widget_title\";s:2:\"20\";s:11:\"widget_text\";s:2:\"20\";s:9:\"the_title\";s:2:\"20\";s:20:\"category_description\";s:2:\"20\";s:9:\"list_cats\";s:2:\"20\";s:16:\"wp_dropdown_cats\";s:2:\"20\";s:9:\"term_name\";s:2:\"20\";s:18:\"get_comment_author\";s:2:\"20\";s:10:\"the_author\";s:2:\"20\";s:9:\"tml_title\";s:2:\"20\";s:16:\"term_description\";s:2:\"20\";}s:4:\"term\";a:10:{s:7:\"cat_row\";s:1:\"0\";s:8:\"cat_rows\";s:1:\"0\";s:19:\"wp_get_object_terms\";s:1:\"0\";s:16:\"single_cat_title\";s:1:\"0\";s:16:\"single_tag_title\";s:1:\"0\";s:17:\"single_term_title\";s:1:\"0\";s:12:\"the_category\";s:1:\"0\";s:8:\"get_term\";s:1:\"0\";s:9:\"get_terms\";s:1:\"0\";s:12:\"get_category\";s:1:\"0\";}s:3:\"url\";a:16:{s:16:\"author_feed_link\";s:2:\"10\";s:11:\"author_link\";s:2:\"10\";s:27:\"get_comment_author_url_link\";s:2:\"10\";s:23:\"post_comments_feed_link\";s:2:\"10\";s:8:\"day_link\";s:2:\"10\";s:10:\"month_link\";s:2:\"10\";s:9:\"year_link\";s:2:\"10\";s:9:\"page_link\";s:2:\"10\";s:9:\"post_link\";s:2:\"10\";s:13:\"category_link\";s:2:\"10\";s:18:\"category_feed_link\";s:2:\"10\";s:8:\"tag_link\";s:2:\"10\";s:9:\"term_link\";s:2:\"10\";s:13:\"the_permalink\";s:2:\"10\";s:9:\"feed_link\";s:2:\"10\";s:13:\"tag_feed_link\";s:2:\"10\";}}}}", "yes");
INSERT INTO `wp_options` VALUES("304", "widget_qtranslate", "a:2:{i:2;a:6:{s:5:\"title\";s:0:\"\";s:4:\"type\";s:6:\"custom\";s:10:\"widget-css\";s:857:\".qtranxs_widget ul { margin: 0; }\r\n.qtranxs_widget ul li\r\n{\r\ndisplay: inline; /* horizontal list, use \"list-item\" or other appropriate value for vertical list */\r\nlist-style-type: none; /* use \"initial\" or other to enable bullets */\r\nmargin: 0 5px 0 0; /* adjust spacing between items */\r\nopacity: 0.5;\r\n-o-transition: 1s ease opacity;\r\n-moz-transition: 1s ease opacity;\r\n-webkit-transition: 1s ease opacity;\r\ntransition: 1s ease opacity;\r\n}\r\n/* .qtranxs_widget ul li span { margin: 0 5px 0 0; } */ /* other way to control spacing */\r\n.qtranxs_widget ul li.active { opacity: 0.8; }\r\n.qtranxs_widget ul li:hover { opacity: 1; }\r\n.qtranxs_widget img { box-shadow: none; vertical-align: middle; display: initial; }\r\n.qtranxs_flag { height:12px; width:18px; display:block; }\r\n.qtranxs_flag_and_text { padding-left:20px; }\r\n.qtranxs_flag span { display:none; }\r\n\";s:10:\"hide-title\";b:1;s:16:\"hide-title-colon\";b:1;s:6:\"format\";s:2:\"%c\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("305", "qtranslate_next_thanks", "1760845550", "yes");
INSERT INTO `wp_options` VALUES("306", "qtranslate_next_update_mo", "1740548037", "yes");
INSERT INTO `wp_options` VALUES("311", "rlrsssl_options", "a:16:{s:12:\"site_has_ssl\";b:1;s:4:\"hsts\";b:0;s:22:\"htaccess_warning_shown\";b:0;s:19:\"review_notice_shown\";b:1;s:25:\"ssl_success_message_shown\";b:0;s:26:\"autoreplace_insecure_links\";b:1;s:17:\"plugin_db_version\";s:5:\"5.3.5\";s:20:\"do_not_edit_htaccess\";b:0;s:17:\"htaccess_redirect\";b:0;s:11:\"ssl_enabled\";b:1;s:19:\"javascript_redirect\";b:0;s:11:\"wp_redirect\";b:1;s:31:\"switch_mixed_content_fixer_hook\";b:0;s:19:\"dismiss_all_notices\";b:0;s:13:\"high_contrast\";b:0;s:21:\"dismiss_review_notice\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("312", "rsssl_remaining_tasks", "1", "yes");
INSERT INTO `wp_options` VALUES("321", "rsssl_current_version", "5.3.5", "yes");
INSERT INTO `wp_options` VALUES("324", "https_migration_required", "", "yes");
INSERT INTO `wp_options` VALUES("325", "rsssl_activation_timestamp", "1620818469", "yes");
INSERT INTO `wp_options` VALUES("349", "asl_options", "a:192:{s:5:\"theme\";s:10:\"simple-red\";s:20:\"override_search_form\";i:0;s:24:\"override_woo_search_form\";i:0;s:13:\"keyword_logic\";s:3:\"and\";s:28:\"mob_auto_focus_menu_selector\";s:12:\"#menu-toggle\";s:23:\"trigger_on_facet_change\";i:1;s:12:\"click_action\";s:12:\"results_page\";s:13:\"return_action\";s:12:\"results_page\";s:21:\"click_action_location\";s:4:\"same\";s:22:\"return_action_location\";s:4:\"same\";s:19:\"custom_redirect_url\";s:11:\"?s={phrase}\";s:16:\"results_per_page\";s:4:\"auto\";s:13:\"triggerontype\";i:1;s:19:\"trigger_update_href\";i:0;s:11:\"customtypes\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:13:\"searchintitle\";i:1;s:15:\"searchincontent\";i:1;s:15:\"searchinexcerpt\";i:1;s:20:\"search_in_permalinks\";i:0;s:23:\"post_password_protected\";i:1;s:13:\"search_in_ids\";i:0;s:13:\"search_all_cf\";i:0;s:12:\"customfields\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:24:\"override_default_results\";i:0;s:15:\"override_method\";s:3:\"get\";s:15:\"res_live_search\";i:0;s:17:\"res_live_selector\";s:5:\"#main\";s:21:\"res_live_trigger_type\";i:1;s:22:\"res_live_trigger_facet\";i:1;s:22:\"res_live_trigger_click\";i:0;s:23:\"res_live_trigger_return\";i:0;s:9:\"exactonly\";i:0;s:20:\"exact_match_location\";s:8:\"anywhere\";s:13:\"searchinterms\";i:0;s:9:\"charcount\";i:0;s:10:\"maxresults\";i:10;s:10:\"itemscount\";i:4;s:16:\"resultitemheight\";s:4:\"70px\";s:15:\"orderby_primary\";s:14:\"relevance DESC\";s:17:\"orderby_secondary\";s:9:\"date DESC\";s:18:\"orderby_primary_cf\";s:0:\"\";s:20:\"orderby_secondary_cf\";s:0:\"\";s:23:\"orderby_primary_cf_type\";s:7:\"numeric\";s:25:\"orderby_secondary_cf_type\";s:7:\"numeric\";s:11:\"show_images\";i:1;s:11:\"image_width\";i:70;s:12:\"image_height\";i:70;s:25:\"image_parser_image_number\";i:1;s:30:\"image_parser_exclude_filenames\";s:0:\"\";s:18:\"image_display_mode\";s:5:\"cover\";s:26:\"image_apply_content_filter\";i:0;s:13:\"image_sources\";a:7:{i:0;a:2:{s:6:\"option\";s:14:\"Featured image\";s:5:\"value\";s:8:\"featured\";}i:1;a:2:{s:6:\"option\";s:12:\"Post Content\";s:5:\"value\";s:7:\"content\";}i:2;a:2:{s:6:\"option\";s:12:\"Post Excerpt\";s:5:\"value\";s:7:\"excerpt\";}i:3;a:2:{s:6:\"option\";s:12:\"Custom field\";s:5:\"value\";s:6:\"custom\";}i:4;a:2:{s:6:\"option\";s:15:\"Page Screenshot\";s:5:\"value\";s:10:\"screenshot\";}i:5;a:2:{s:6:\"option\";s:13:\"Default image\";s:5:\"value\";s:7:\"default\";}i:6;a:2:{s:6:\"option\";s:8:\"Disabled\";s:5:\"value\";s:8:\"disabled\";}}s:13:\"image_source1\";s:8:\"featured\";s:13:\"image_source2\";s:7:\"content\";s:13:\"image_source3\";s:7:\"excerpt\";s:13:\"image_source4\";s:6:\"custom\";s:13:\"image_source5\";s:7:\"default\";s:13:\"image_default\";s:68:\"https://ikosz.hu/wp-content/plugins/ajax-search-lite/img/default.jpg\";s:21:\"image_source_featured\";s:8:\"original\";s:18:\"image_custom_field\";s:0:\"\";s:12:\"use_timthumb\";i:1;s:29:\"show_frontend_search_settings\";i:0;s:16:\"showexactmatches\";i:1;s:17:\"showsearchintitle\";i:1;s:19:\"showsearchincontent\";i:1;s:15:\"showcustomtypes\";s:0:\"\";s:20:\"showsearchincomments\";i:1;s:19:\"showsearchinexcerpt\";i:1;s:19:\"showsearchinbpusers\";i:0;s:20:\"showsearchinbpgroups\";i:0;s:20:\"showsearchinbpforums\";i:0;s:16:\"exactmatchestext\";s:18:\"Exact matches only\";s:17:\"searchintitletext\";s:15:\"Search in title\";s:19:\"searchincontenttext\";s:17:\"Search in content\";s:20:\"searchincommentstext\";s:18:\"Search in comments\";s:19:\"searchinexcerpttext\";s:17:\"Search in excerpt\";s:19:\"searchinbpuserstext\";s:15:\"Search in users\";s:20:\"searchinbpgroupstext\";s:16:\"Search in groups\";s:20:\"searchinbpforumstext\";s:16:\"Search in forums\";s:22:\"showsearchincategories\";i:0;s:17:\"showuncategorised\";i:0;s:20:\"exsearchincategories\";s:0:\"\";s:26:\"exsearchincategoriesheight\";i:200;s:22:\"showsearchintaxonomies\";i:1;s:9:\"showterms\";s:0:\"\";s:23:\"showseparatefilterboxes\";i:1;s:24:\"exsearchintaxonomiestext\";s:9:\"Filter by\";s:24:\"exsearchincategoriestext\";s:20:\"Filter by Categories\";s:13:\"auto_populate\";s:8:\"disabled\";s:20:\"auto_populate_phrase\";s:0:\"\";s:19:\"auto_populate_count\";s:1:\"1\";s:15:\"results_snap_to\";s:4:\"left\";s:9:\"box_width\";s:4:\"100%\";s:16:\"box_width_tablet\";s:4:\"100%\";s:15:\"box_width_phone\";s:4:\"100%\";s:10:\"box_margin\";s:22:\"||0px||0px||0px||0px||\";s:8:\"box_font\";s:9:\"Open Sans\";s:11:\"override_bg\";i:0;s:17:\"override_bg_color\";s:7:\"#FFFFFF\";s:13:\"override_icon\";i:0;s:22:\"override_icon_bg_color\";s:7:\"#FFFFFF\";s:19:\"override_icon_color\";s:7:\"#000000\";s:15:\"override_border\";i:0;s:21:\"override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:19:\"results_bg_override\";i:0;s:25:\"results_bg_override_color\";s:7:\"#FFFFFF\";s:24:\"results_item_bg_override\";i:0;s:30:\"results_item_bg_override_color\";s:7:\"#FFFFFF\";s:23:\"results_override_border\";i:0;s:29:\"results_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:20:\"settings_bg_override\";i:0;s:26:\"settings_bg_override_color\";s:7:\"#FFFFFF\";s:24:\"settings_override_border\";i:0;s:30:\"settings_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:15:\"resultstype_def\";a:4:{i:0;a:2:{s:6:\"option\";s:16:\"Vertical Results\";s:5:\"value\";s:8:\"vertical\";}i:1;a:2:{s:6:\"option\";s:18:\"Horizontal Results\";s:5:\"value\";s:10:\"horizontal\";}i:2;a:2:{s:6:\"option\";s:16:\"Isotopic Results\";s:5:\"value\";s:8:\"isotopic\";}i:3;a:2:{s:6:\"option\";s:22:\"Polaroid style Results\";s:5:\"value\";s:8:\"polaroid\";}}s:11:\"resultstype\";s:8:\"vertical\";s:19:\"resultsposition_def\";a:2:{i:0;a:2:{s:6:\"option\";s:20:\"Hover - over content\";s:5:\"value\";s:5:\"hover\";}i:1;a:2:{s:6:\"option\";s:22:\"Block - pushes content\";s:5:\"value\";s:5:\"block\";}}s:15:\"resultsposition\";s:5:\"hover\";s:16:\"resultsmargintop\";s:4:\"12px\";s:13:\"results_width\";s:4:\"auto\";s:19:\"results_width_phone\";s:4:\"auto\";s:20:\"results_width_tablet\";s:4:\"auto\";s:16:\"v_res_max_height\";s:4:\"none\";s:18:\"v_res_column_count\";i:1;s:22:\"v_res_column_min_width\";s:5:\"200px\";s:29:\"v_res_column_min_width_tablet\";s:5:\"200px\";s:28:\"v_res_column_min_width_phone\";s:5:\"200px\";s:17:\"defaultsearchtext\";s:13:\"Search here..\";s:15:\"showmoreresults\";i:0;s:19:\"showmoreresultstext\";s:15:\"More results...\";s:19:\"results_click_blank\";i:0;s:17:\"scroll_to_results\";i:0;s:19:\"resultareaclickable\";i:1;s:23:\"close_on_document_click\";i:1;s:15:\"show_close_icon\";i:1;s:10:\"showauthor\";i:0;s:8:\"showdate\";i:0;s:11:\"custom_date\";i:0;s:18:\"custom_date_format\";s:11:\"Y-m-d H:i:s\";s:15:\"showdescription\";i:1;s:17:\"descriptionlength\";i:100;s:19:\"description_context\";i:0;s:25:\"description_context_depth\";i:10000;s:13:\"noresultstext\";s:11:\"No results!\";s:14:\"didyoumeantext\";s:13:\"Did you mean:\";s:12:\"kw_highlight\";i:0;s:24:\"kw_highlight_whole_words\";i:1;s:15:\"highlight_color\";s:7:\"#d9312b\";s:18:\"highlight_bg_color\";s:4:\"#eee\";s:16:\"single_highlight\";i:0;s:26:\"single_highlightwholewords\";i:1;s:21:\"single_highlightcolor\";s:7:\"#d9312b\";s:23:\"single_highlightbgcolor\";s:4:\"#eee\";s:23:\"single_highlight_scroll\";i:0;s:23:\"single_highlight_offset\";i:0;s:25:\"single_highlight_selector\";s:8:\"#content\";s:10:\"custom_css\";s:0:\"\";s:12:\"autocomplete\";i:1;s:14:\"kw_suggestions\";i:1;s:9:\"kw_length\";i:60;s:8:\"kw_count\";i:10;s:14:\"kw_google_lang\";s:2:\"en\";s:12:\"shortcode_op\";s:6:\"remove\";s:16:\"striptagsexclude\";s:0:\"\";s:12:\"runshortcode\";i:1;s:14:\"stripshortcode\";i:0;s:19:\"pageswithcategories\";i:0;s:18:\"primary_titlefield\";i:0;s:21:\"primary_titlefield_cf\";s:0:\"\";s:24:\"primary_descriptionfield\";i:0;s:27:\"primary_descriptionfield_cf\";s:0:\"\";s:20:\"secondary_titlefield\";i:-1;s:23:\"secondary_titlefield_cf\";s:0:\"\";s:26:\"secondary_descriptionfield\";i:-1;s:29:\"secondary_descriptionfield_cf\";s:0:\"\";s:13:\"advtitlefield\";s:12:\"{titlefield}\";s:19:\"advdescriptionfield\";s:18:\"{descriptionfield}\";s:22:\"woo_exclude_outofstock\";i:0;s:18:\"exclude_woo_hidden\";i:1;s:19:\"exclude_woo_catalog\";i:0;s:17:\"excludecategories\";s:0:\"\";s:12:\"excludeposts\";s:0:\"\";s:18:\"wpml_compatibility\";i:1;s:22:\"polylang_compatibility\";i:1;s:13:\"kw_exceptions\";s:0:\"\";s:15:\"kw_exceptions_e\";s:0:\"\";s:22:\"aria_search_form_label\";s:11:\"Search form\";s:24:\"aria_settings_form_label\";s:20:\"Search settings form\";s:23:\"aria_search_input_label\";s:12:\"Search input\";s:30:\"aria_search_autocomplete_label\";s:25:\"Search autocomplete input\";s:20:\"aria_magnifier_label\";s:23:\"Search magnifier button\";}", "yes");
INSERT INTO `wp_options` VALUES("350", "asl_version", "4768", "yes");
INSERT INTO `wp_options` VALUES("351", "widget_ajaxsearchlitewidget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("352", "asl_debug_data", "a:1:{s:11:\"asl_options\";a:192:{s:5:\"theme\";s:10:\"simple-red\";s:20:\"override_search_form\";i:0;s:24:\"override_woo_search_form\";i:0;s:13:\"keyword_logic\";s:3:\"and\";s:28:\"mob_auto_focus_menu_selector\";s:12:\"#menu-toggle\";s:23:\"trigger_on_facet_change\";i:1;s:12:\"click_action\";s:12:\"results_page\";s:13:\"return_action\";s:12:\"results_page\";s:21:\"click_action_location\";s:4:\"same\";s:22:\"return_action_location\";s:4:\"same\";s:19:\"custom_redirect_url\";s:11:\"?s={phrase}\";s:16:\"results_per_page\";s:4:\"auto\";s:13:\"triggerontype\";i:1;s:19:\"trigger_update_href\";i:0;s:11:\"customtypes\";a:2:{i:0;s:4:\"post\";i:1;s:4:\"page\";}s:13:\"searchintitle\";i:1;s:15:\"searchincontent\";i:1;s:15:\"searchinexcerpt\";i:1;s:20:\"search_in_permalinks\";i:0;s:23:\"post_password_protected\";i:1;s:13:\"search_in_ids\";i:0;s:13:\"search_all_cf\";i:0;s:12:\"customfields\";s:0:\"\";s:11:\"post_status\";s:7:\"publish\";s:24:\"override_default_results\";i:0;s:15:\"override_method\";s:3:\"get\";s:15:\"res_live_search\";i:0;s:17:\"res_live_selector\";s:5:\"#main\";s:21:\"res_live_trigger_type\";i:1;s:22:\"res_live_trigger_facet\";i:1;s:22:\"res_live_trigger_click\";i:0;s:23:\"res_live_trigger_return\";i:0;s:9:\"exactonly\";i:0;s:20:\"exact_match_location\";s:8:\"anywhere\";s:13:\"searchinterms\";i:0;s:9:\"charcount\";i:0;s:10:\"maxresults\";i:10;s:10:\"itemscount\";i:4;s:16:\"resultitemheight\";s:4:\"70px\";s:15:\"orderby_primary\";s:14:\"relevance DESC\";s:17:\"orderby_secondary\";s:9:\"date DESC\";s:18:\"orderby_primary_cf\";s:0:\"\";s:20:\"orderby_secondary_cf\";s:0:\"\";s:23:\"orderby_primary_cf_type\";s:7:\"numeric\";s:25:\"orderby_secondary_cf_type\";s:7:\"numeric\";s:11:\"show_images\";i:1;s:11:\"image_width\";i:70;s:12:\"image_height\";i:70;s:25:\"image_parser_image_number\";i:1;s:30:\"image_parser_exclude_filenames\";s:0:\"\";s:18:\"image_display_mode\";s:5:\"cover\";s:26:\"image_apply_content_filter\";i:0;s:13:\"image_sources\";a:7:{i:0;a:2:{s:6:\"option\";s:14:\"Featured image\";s:5:\"value\";s:8:\"featured\";}i:1;a:2:{s:6:\"option\";s:12:\"Post Content\";s:5:\"value\";s:7:\"content\";}i:2;a:2:{s:6:\"option\";s:12:\"Post Excerpt\";s:5:\"value\";s:7:\"excerpt\";}i:3;a:2:{s:6:\"option\";s:12:\"Custom field\";s:5:\"value\";s:6:\"custom\";}i:4;a:2:{s:6:\"option\";s:15:\"Page Screenshot\";s:5:\"value\";s:10:\"screenshot\";}i:5;a:2:{s:6:\"option\";s:13:\"Default image\";s:5:\"value\";s:7:\"default\";}i:6;a:2:{s:6:\"option\";s:8:\"Disabled\";s:5:\"value\";s:8:\"disabled\";}}s:13:\"image_source1\";s:8:\"featured\";s:13:\"image_source2\";s:7:\"content\";s:13:\"image_source3\";s:7:\"excerpt\";s:13:\"image_source4\";s:6:\"custom\";s:13:\"image_source5\";s:7:\"default\";s:13:\"image_default\";s:68:\"https://ikosz.hu/wp-content/plugins/ajax-search-lite/img/default.jpg\";s:21:\"image_source_featured\";s:8:\"original\";s:18:\"image_custom_field\";s:0:\"\";s:12:\"use_timthumb\";i:1;s:29:\"show_frontend_search_settings\";i:0;s:16:\"showexactmatches\";i:1;s:17:\"showsearchintitle\";i:1;s:19:\"showsearchincontent\";i:1;s:15:\"showcustomtypes\";s:0:\"\";s:20:\"showsearchincomments\";i:1;s:19:\"showsearchinexcerpt\";i:1;s:19:\"showsearchinbpusers\";i:0;s:20:\"showsearchinbpgroups\";i:0;s:20:\"showsearchinbpforums\";i:0;s:16:\"exactmatchestext\";s:18:\"Exact matches only\";s:17:\"searchintitletext\";s:15:\"Search in title\";s:19:\"searchincontenttext\";s:17:\"Search in content\";s:20:\"searchincommentstext\";s:18:\"Search in comments\";s:19:\"searchinexcerpttext\";s:17:\"Search in excerpt\";s:19:\"searchinbpuserstext\";s:15:\"Search in users\";s:20:\"searchinbpgroupstext\";s:16:\"Search in groups\";s:20:\"searchinbpforumstext\";s:16:\"Search in forums\";s:22:\"showsearchincategories\";i:0;s:17:\"showuncategorised\";i:0;s:20:\"exsearchincategories\";s:0:\"\";s:26:\"exsearchincategoriesheight\";i:200;s:22:\"showsearchintaxonomies\";i:1;s:9:\"showterms\";s:0:\"\";s:23:\"showseparatefilterboxes\";i:1;s:24:\"exsearchintaxonomiestext\";s:9:\"Filter by\";s:24:\"exsearchincategoriestext\";s:20:\"Filter by Categories\";s:13:\"auto_populate\";s:8:\"disabled\";s:20:\"auto_populate_phrase\";s:0:\"\";s:19:\"auto_populate_count\";s:1:\"1\";s:15:\"results_snap_to\";s:4:\"left\";s:9:\"box_width\";s:4:\"100%\";s:16:\"box_width_tablet\";s:4:\"100%\";s:15:\"box_width_phone\";s:4:\"100%\";s:10:\"box_margin\";s:22:\"||0px||0px||0px||0px||\";s:8:\"box_font\";s:9:\"Open Sans\";s:11:\"override_bg\";i:0;s:17:\"override_bg_color\";s:7:\"#FFFFFF\";s:13:\"override_icon\";i:0;s:22:\"override_icon_bg_color\";s:7:\"#FFFFFF\";s:19:\"override_icon_color\";s:7:\"#000000\";s:15:\"override_border\";i:0;s:21:\"override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:19:\"results_bg_override\";i:0;s:25:\"results_bg_override_color\";s:7:\"#FFFFFF\";s:24:\"results_item_bg_override\";i:0;s:30:\"results_item_bg_override_color\";s:7:\"#FFFFFF\";s:23:\"results_override_border\";i:0;s:29:\"results_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:20:\"settings_bg_override\";i:0;s:26:\"settings_bg_override_color\";s:7:\"#FFFFFF\";s:24:\"settings_override_border\";i:0;s:30:\"settings_override_border_style\";s:59:\"border:1px none rgb(0, 0, 0);border-radius:0px 0px 0px 0px;\";s:15:\"resultstype_def\";a:4:{i:0;a:2:{s:6:\"option\";s:16:\"Vertical Results\";s:5:\"value\";s:8:\"vertical\";}i:1;a:2:{s:6:\"option\";s:18:\"Horizontal Results\";s:5:\"value\";s:10:\"horizontal\";}i:2;a:2:{s:6:\"option\";s:16:\"Isotopic Results\";s:5:\"value\";s:8:\"isotopic\";}i:3;a:2:{s:6:\"option\";s:22:\"Polaroid style Results\";s:5:\"value\";s:8:\"polaroid\";}}s:11:\"resultstype\";s:8:\"vertical\";s:19:\"resultsposition_def\";a:2:{i:0;a:2:{s:6:\"option\";s:20:\"Hover - over content\";s:5:\"value\";s:5:\"hover\";}i:1;a:2:{s:6:\"option\";s:22:\"Block - pushes content\";s:5:\"value\";s:5:\"block\";}}s:15:\"resultsposition\";s:5:\"hover\";s:16:\"resultsmargintop\";s:4:\"12px\";s:13:\"results_width\";s:4:\"auto\";s:19:\"results_width_phone\";s:4:\"auto\";s:20:\"results_width_tablet\";s:4:\"auto\";s:16:\"v_res_max_height\";s:4:\"none\";s:18:\"v_res_column_count\";i:1;s:22:\"v_res_column_min_width\";s:5:\"200px\";s:29:\"v_res_column_min_width_tablet\";s:5:\"200px\";s:28:\"v_res_column_min_width_phone\";s:5:\"200px\";s:17:\"defaultsearchtext\";s:13:\"Search here..\";s:15:\"showmoreresults\";i:0;s:19:\"showmoreresultstext\";s:15:\"More results...\";s:19:\"results_click_blank\";i:0;s:17:\"scroll_to_results\";i:0;s:19:\"resultareaclickable\";i:1;s:23:\"close_on_document_click\";i:1;s:15:\"show_close_icon\";i:1;s:10:\"showauthor\";i:0;s:8:\"showdate\";i:0;s:11:\"custom_date\";i:0;s:18:\"custom_date_format\";s:11:\"Y-m-d H:i:s\";s:15:\"showdescription\";i:1;s:17:\"descriptionlength\";i:100;s:19:\"description_context\";i:0;s:25:\"description_context_depth\";i:10000;s:13:\"noresultstext\";s:11:\"No results!\";s:14:\"didyoumeantext\";s:13:\"Did you mean:\";s:12:\"kw_highlight\";i:0;s:24:\"kw_highlight_whole_words\";i:1;s:15:\"highlight_color\";s:7:\"#d9312b\";s:18:\"highlight_bg_color\";s:4:\"#eee\";s:16:\"single_highlight\";i:0;s:26:\"single_highlightwholewords\";i:1;s:21:\"single_highlightcolor\";s:7:\"#d9312b\";s:23:\"single_highlightbgcolor\";s:4:\"#eee\";s:23:\"single_highlight_scroll\";i:0;s:23:\"single_highlight_offset\";i:0;s:25:\"single_highlight_selector\";s:8:\"#content\";s:10:\"custom_css\";s:0:\"\";s:12:\"autocomplete\";i:1;s:14:\"kw_suggestions\";i:1;s:9:\"kw_length\";i:60;s:8:\"kw_count\";i:10;s:14:\"kw_google_lang\";s:2:\"en\";s:12:\"shortcode_op\";s:6:\"remove\";s:16:\"striptagsexclude\";s:0:\"\";s:12:\"runshortcode\";i:1;s:14:\"stripshortcode\";i:0;s:19:\"pageswithcategories\";i:0;s:18:\"primary_titlefield\";i:0;s:21:\"primary_titlefield_cf\";s:0:\"\";s:24:\"primary_descriptionfield\";i:0;s:27:\"primary_descriptionfield_cf\";s:0:\"\";s:20:\"secondary_titlefield\";i:-1;s:23:\"secondary_titlefield_cf\";s:0:\"\";s:26:\"secondary_descriptionfield\";i:-1;s:29:\"secondary_descriptionfield_cf\";s:0:\"\";s:13:\"advtitlefield\";s:12:\"{titlefield}\";s:19:\"advdescriptionfield\";s:18:\"{descriptionfield}\";s:22:\"woo_exclude_outofstock\";i:0;s:18:\"exclude_woo_hidden\";i:1;s:19:\"exclude_woo_catalog\";i:0;s:17:\"excludecategories\";s:0:\"\";s:12:\"excludeposts\";s:0:\"\";s:18:\"wpml_compatibility\";i:1;s:22:\"polylang_compatibility\";i:1;s:13:\"kw_exceptions\";s:0:\"\";s:15:\"kw_exceptions_e\";s:0:\"\";s:22:\"aria_search_form_label\";s:11:\"Search form\";s:24:\"aria_settings_form_label\";s:20:\"Search settings form\";s:23:\"aria_search_input_label\";s:12:\"Search input\";s:30:\"aria_search_autocomplete_label\";s:25:\"Search autocomplete input\";s:20:\"aria_magnifier_label\";s:23:\"Search magnifier button\";}}", "yes");
INSERT INTO `wp_options` VALUES("396", "activities_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("403", "auto_core_update_notified", "a:4:{s:4:\"type\";s:7:\"success\";s:5:\"email\";s:12:\"web@effix.hu\";s:7:\"version\";s:5:\"6.7.2\";s:9:\"timestamp\";i:1739312032;}", "off");
INSERT INTO `wp_options` VALUES("440", "area_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("450", "areas_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("538", "tribe_events_calendar_options", "a:48:{s:8:\"did_init\";b:1;s:19:\"tribeEventsTemplate\";s:0:\"\";s:16:\"tribeEnableViews\";a:3:{i:0;s:4:\"list\";i:1;s:5:\"month\";i:2;s:3:\"day\";}s:10:\"viewOption\";s:5:\"month\";s:14:\"schema-version\";s:8:\"6.10.1.1\";s:27:\"recurring_events_are_hidden\";s:6:\"hidden\";s:21:\"previous_ecp_versions\";a:100:{i:0;s:1:\"0\";i:1;s:5:\"5.6.0\";i:2;s:5:\"5.8.1\";i:3;s:5:\"5.8.2\";i:4;s:6:\"5.12.0\";i:5;s:6:\"5.12.1\";i:6;s:6:\"5.12.2\";i:7;s:6:\"5.12.3\";i:8;s:6:\"5.12.4\";i:9;s:6:\"5.13.0\";i:10;s:6:\"5.14.0\";i:11;s:8:\"5.14.0.1\";i:12;s:8:\"5.14.0.2\";i:13;s:8:\"5.14.0.3\";i:14;s:8:\"5.14.0.4\";i:15;s:6:\"5.14.1\";i:16;s:8:\"5.14.2.1\";i:17;s:6:\"5.15.0\";i:18;s:8:\"5.15.0.1\";i:19;s:6:\"5.16.0\";i:20;s:6:\"5.16.1\";i:21;s:8:\"5.16.1.1\";i:22;s:6:\"5.16.2\";i:23;s:8:\"5.16.2.1\";i:24;s:6:\"5.16.3\";i:25;s:8:\"5.16.3.1\";i:26;s:6:\"5.16.4\";i:27;s:5:\"6.0.0\";i:28;s:7:\"6.0.0.1\";i:29;s:5:\"6.0.1\";i:30;s:7:\"6.0.1.1\";i:31;s:5:\"6.0.2\";i:32;s:5:\"6.0.3\";i:33;s:7:\"6.0.3.1\";i:34;s:5:\"6.0.4\";i:35;s:5:\"6.0.5\";i:36;s:7:\"6.0.6.1\";i:37;s:7:\"6.0.6.2\";i:38;s:5:\"6.0.7\";i:39;s:7:\"6.0.7.1\";i:40;s:5:\"6.0.8\";i:41;s:5:\"6.0.9\";i:42;s:6:\"6.0.10\";i:43;s:6:\"6.0.11\";i:44;s:6:\"6.0.12\";i:45;s:6:\"6.0.13\";i:46;s:8:\"6.0.13.1\";i:47;s:5:\"6.1.0\";i:48;s:7:\"6.1.0.2\";i:49;s:5:\"6.1.1\";i:50;s:5:\"6.1.2\";i:51;s:7:\"6.1.2.1\";i:52;s:7:\"6.1.2.2\";i:53;s:5:\"6.1.3\";i:54;s:5:\"6.1.4\";i:55;s:5:\"6.2.0\";i:56;s:7:\"6.2.0.1\";i:57;s:5:\"6.2.1\";i:58;s:5:\"6.2.2\";i:59;s:5:\"6.2.9\";i:60;s:5:\"6.3.0\";i:61;s:5:\"6.3.1\";i:62;s:5:\"6.3.2\";i:63;s:5:\"6.3.3\";i:64;s:7:\"6.3.3.1\";i:65;s:5:\"6.3.4\";i:66;s:5:\"6.3.5\";i:67;s:5:\"6.3.6\";i:68;s:5:\"6.3.7\";i:69;s:5:\"6.4.0\";i:70;s:7:\"6.4.0.1\";i:71;s:5:\"6.5.0\";i:72;s:7:\"6.5.0.1\";i:73;s:5:\"6.5.1\";i:74;s:7:\"6.5.1.1\";i:75;s:7:\"6.5.1.3\";i:76;s:7:\"6.5.1.4\";i:77;s:7:\"6.5.1.5\";i:78;s:7:\"6.5.1.6\";i:79;s:5:\"6.5.2\";i:80;s:5:\"6.6.0\";i:81;s:7:\"6.6.0.1\";i:82;s:7:\"6.6.0.2\";i:83;s:5:\"6.6.1\";i:84;s:5:\"6.6.2\";i:85;s:5:\"6.6.3\";i:86;s:5:\"6.6.4\";i:87;s:7:\"6.6.4.1\";i:88;s:7:\"6.6.4.2\";i:89;s:5:\"6.7.0\";i:90;s:5:\"6.7.1\";i:91;s:5:\"6.8.0\";i:92;s:5:\"6.8.1\";i:93;s:5:\"6.8.2\";i:94;s:7:\"6.8.2.1\";i:95;s:5:\"6.8.3\";i:96;s:5:\"6.9.0\";i:97;s:5:\"6.9.1\";i:98;s:6:\"6.10.0\";i:99;s:6:\"6.10.1\";}s:18:\"latest_ecp_version\";s:8:\"6.10.1.1\";s:16:\"views_v2_enabled\";b:1;s:12:\"postsPerPage\";s:2:\"12\";s:16:\"monthEventAmount\";s:1:\"3\";s:39:\"last-update-message-the-events-calendar\";s:5:\"5.6.0\";s:22:\"google_maps_js_api_key\";s:39:\"AIzaSyDNsicAsP6-VuGtAb1O9riI3oc_NOb7IOU\";s:13:\"earliest_date\";s:19:\"2021-08-23 08:00:00\";s:21:\"earliest_date_markers\";a:2:{i:0;s:3:\"481\";i:1;s:3:\"484\";}s:11:\"latest_date\";s:19:\"2021-08-25 17:00:00\";s:19:\"latest_date_markers\";a:1:{i:0;s:3:\"484\";}s:11:\"donate-link\";b:0;s:20:\"toggle_blocks_editor\";b:0;s:33:\"toggle_blocks_editor_hidden_field\";b:0;s:12:\"showComments\";b:0;s:29:\"disable_metabox_custom_fields\";b:1;s:20:\"showEventsInMainLoop\";b:0;s:10:\"eventsSlug\";s:9:\"esemenyek\";s:15:\"singleEventSlug\";s:7:\"esemeny\";s:14:\"multiDayCutoff\";s:5:\"00:00\";s:21:\"defaultCurrencySymbol\";s:2:\"Ft\";s:23:\"reverseCurrencyPosition\";b:0;s:17:\"trash-past-events\";s:0:\"\";s:18:\"delete-past-events\";s:0:\"\";s:15:\"embedGoogleMaps\";b:0;s:19:\"embedGoogleMapsZoom\";s:2:\"10\";s:11:\"debugEvents\";b:0;s:26:\"tribe_events_timezone_mode\";s:5:\"event\";s:32:\"tribe_events_timezones_show_zone\";b:0;s:15:\"stylesheet_mode\";s:5:\"tribe\";s:20:\"tribeDisableTribeBar\";b:1;s:23:\"enable_month_view_cache\";b:1;s:18:\"dateWithYearFormat\";s:6:\"Y.m.d.\";s:21:\"dateWithoutYearFormat\";s:3:\"F j\";s:18:\"monthAndYearFormat\";s:3:\"F Y\";s:17:\"dateTimeSeparator\";s:3:\" @ \";s:18:\"timeRangeSeparator\";s:3:\" - \";s:16:\"datepickerFormat\";s:1:\"1\";s:21:\"tribeEventsBeforeHTML\";s:0:\"\";s:20:\"tribeEventsAfterHTML\";s:0:\"\";s:24:\"front_page_event_archive\";b:0;s:18:\"tec-schema-version\";s:7:\"6.5.1.1\";}", "yes");
INSERT INTO `wp_options` VALUES("541", "tribe_last_updated_option", "1740133368.7462", "yes");
INSERT INTO `wp_options` VALUES("542", "tribe_last_save_post", "1740133368.7509", "yes");
INSERT INTO `wp_options` VALUES("543", "widget_tribe-events-list-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("544", "fs_active_plugins", "O:8:\"stdClass\":2:{s:7:\"plugins\";a:0:{}s:7:\"abspath\";s:24:\"/home/ikosz/public_html/\";}", "yes");
INSERT INTO `wp_options` VALUES("545", "fs_debug_mode", "", "yes");
INSERT INTO `wp_options` VALUES("546", "fs_accounts", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:3069;a:3:{s:4:\"slug\";s:19:\"the-events-calendar\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:11:\"plugin_data\";a:1:{s:19:\"the-events-calendar\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1629378117;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:5:\"2.4.3\";s:11:\"sdk_version\";s:5:\"2.4.4\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"6.0.13\";s:14:\"plugin_version\";s:8:\"6.0.13.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:8:\"ikosz.hu\";s:9:\"server_ip\";s:14:\"213.222.136.14\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1629378117;s:7:\"version\";s:5:\"5.8.2\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:1:{s:43:\"the-events-calendar/the-events-calendar.php\";s:19:\"the-events-calendar\";}s:7:\"plugins\";a:1:{s:19:\"the-events-calendar\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:12:\"premium_slug\";s:27:\"the-events-calendar-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:43:\"the-events-calendar/the-events-calendar.php\";s:7:\"version\";s:8:\"6.0.13.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e32061abc28cfedf231f3e5c4e626\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3069\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"326034a18d56aa4c60c7895901637b07\";s:13:\"admin_notices\";a:1:{s:19:\"the-events-calendar\";a:1:{s:15:\"connect_account\";a:8:{s:7:\"message\";s:177:\"We made a few tweaks to the plugin, <b><a href=\"https://ikosz.hu/wp-admin/edit.php?post_type=tribe_events&page=tribe-common\">Opt in to make \"The Events Calendar\" better!</a></b>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:10:\"update-nag\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"connect_account\";s:10:\"manager_id\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:19:\"The Events Calendar\";s:10:\"wp_user_id\";N;}}}}", "yes");
INSERT INTO `wp_options` VALUES("547", "fs_gdpr", "a:1:{s:2:\"u1\";a:1:{s:8:\"required\";b:0;}}", "yes");
INSERT INTO `wp_options` VALUES("548", "tribe_last_generate_rewrite_rules", "1739930717.7646", "yes");
INSERT INTO `wp_options` VALUES("551", "widget_tribe-widget-events-list", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("776", "hicpo_ver", "3.1.5.1", "yes");
INSERT INTO `wp_options` VALUES("777", "hicpo_options", "a:2:{s:7:\"objects\";a:1:{i:0;s:16:\"frontpage_blocks\";}s:4:\"tags\";a:1:{i:0;s:8:\"services\";}}", "yes");
INSERT INTO `wp_options` VALUES("1327", "loginpress_review_dismiss", "yes", "no");
INSERT INTO `wp_options` VALUES("1347", "acf_qtranslate", "a:2:{s:30:\"translate_standard_field_types\";s:1:\"1\";s:13:\"show_on_pages\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2422", "yoast_migrations_free", "a:1:{s:7:\"version\";s:4:\"24.5\";}", "yes");
INSERT INTO `wp_options` VALUES("2423", "wpseo", "a:106:{s:8:\"tracking\";b:0;s:16:\"toggled_tracking\";b:0;s:22:\"license_server_version\";i:2;s:15:\"ms_defaults_set\";b:0;s:40:\"ignore_search_engines_discouraged_notice\";b:0;s:19:\"indexing_first_time\";b:1;s:16:\"indexing_started\";b:0;s:15:\"indexing_reason\";s:23:\"home_url_option_changed\";s:29:\"indexables_indexing_completed\";b:1;s:13:\"index_now_key\";s:0:\"\";s:7:\"version\";s:4:\"24.5\";s:16:\"previous_version\";s:4:\"24.4\";s:20:\"disableadvanced_meta\";b:1;s:30:\"enable_headless_rest_endpoints\";b:1;s:17:\"ryte_indexability\";b:0;s:11:\"baiduverify\";s:0:\"\";s:12:\"googleverify\";s:0:\"\";s:8:\"msverify\";s:0:\"\";s:12:\"yandexverify\";s:0:\"\";s:9:\"site_type\";s:0:\"\";s:20:\"has_multiple_authors\";s:0:\"\";s:16:\"environment_type\";s:0:\"\";s:23:\"content_analysis_active\";b:1;s:23:\"keyword_analysis_active\";b:1;s:34:\"inclusive_language_analysis_active\";b:0;s:21:\"enable_admin_bar_menu\";b:1;s:26:\"enable_cornerstone_content\";b:1;s:18:\"enable_xml_sitemap\";b:1;s:24:\"enable_text_link_counter\";b:1;s:16:\"enable_index_now\";b:1;s:19:\"enable_ai_generator\";b:0;s:22:\"ai_enabled_pre_default\";b:0;s:22:\"show_onboarding_notice\";b:0;s:18:\"first_activated_on\";i:1628168487;s:13:\"myyoast-oauth\";b:0;s:26:\"semrush_integration_active\";b:1;s:14:\"semrush_tokens\";a:0:{}s:20:\"semrush_country_code\";s:2:\"us\";s:19:\"permalink_structure\";s:36:\"/%year%/%monthnum%/%day%/%postname%/\";s:8:\"home_url\";s:16:\"https://ikosz.hu\";s:18:\"dynamic_permalinks\";b:0;s:17:\"category_base_url\";s:0:\"\";s:12:\"tag_base_url\";s:0:\"\";s:21:\"custom_taxonomy_slugs\";a:2:{s:8:\"services\";s:8:\"services\";s:16:\"tribe_events_cat\";s:18:\"esemenyek/category\";}s:29:\"enable_enhanced_slack_sharing\";b:1;s:23:\"enable_metabox_insights\";b:1;s:23:\"enable_link_suggestions\";b:1;s:26:\"algolia_integration_active\";b:0;s:14:\"import_cursors\";a:0:{}s:13:\"workouts_data\";a:1:{s:13:\"configuration\";a:1:{s:13:\"finishedSteps\";a:0:{}}}s:28:\"configuration_finished_steps\";a:0:{}s:36:\"dismiss_configuration_workout_notice\";b:0;s:34:\"dismiss_premium_deactivated_notice\";b:0;s:19:\"importing_completed\";a:0:{}s:26:\"wincher_integration_active\";b:1;s:14:\"wincher_tokens\";a:0:{}s:36:\"wincher_automatically_add_keyphrases\";b:0;s:18:\"wincher_website_id\";s:0:\"\";s:18:\"first_time_install\";b:0;s:34:\"should_redirect_after_install_free\";b:0;s:34:\"activation_redirect_timestamp_free\";i:1652258756;s:18:\"remove_feed_global\";b:0;s:27:\"remove_feed_global_comments\";b:0;s:25:\"remove_feed_post_comments\";b:0;s:19:\"remove_feed_authors\";b:0;s:22:\"remove_feed_categories\";b:0;s:16:\"remove_feed_tags\";b:0;s:29:\"remove_feed_custom_taxonomies\";b:0;s:22:\"remove_feed_post_types\";b:0;s:18:\"remove_feed_search\";b:0;s:21:\"remove_atom_rdf_feeds\";b:0;s:17:\"remove_shortlinks\";b:0;s:21:\"remove_rest_api_links\";b:0;s:20:\"remove_rsd_wlw_links\";b:0;s:19:\"remove_oembed_links\";b:0;s:16:\"remove_generator\";b:0;s:20:\"remove_emoji_scripts\";b:0;s:24:\"remove_powered_by_header\";b:0;s:22:\"remove_pingback_header\";b:0;s:28:\"clean_campaign_tracking_urls\";b:0;s:16:\"clean_permalinks\";b:0;s:32:\"clean_permalinks_extra_variables\";s:0:\"\";s:14:\"search_cleanup\";b:0;s:20:\"search_cleanup_emoji\";b:0;s:23:\"search_cleanup_patterns\";b:0;s:22:\"search_character_limit\";i:50;s:20:\"deny_search_crawling\";b:0;s:21:\"deny_wp_json_crawling\";b:0;s:20:\"deny_adsbot_crawling\";b:0;s:19:\"deny_ccbot_crawling\";b:0;s:29:\"deny_google_extended_crawling\";b:0;s:20:\"deny_gptbot_crawling\";b:0;s:27:\"redirect_search_pretty_urls\";b:0;s:29:\"least_readability_ignore_list\";a:0:{}s:27:\"least_seo_score_ignore_list\";a:0:{}s:23:\"most_linked_ignore_list\";a:0:{}s:24:\"least_linked_ignore_list\";a:0:{}s:28:\"indexables_page_reading_list\";a:5:{i:0;b:0;i:1;b:0;i:2;b:0;i:3;b:0;i:4;b:0;}s:25:\"indexables_overview_state\";s:21:\"dashboard-not-visited\";s:28:\"last_known_public_post_types\";a:7:{i:0;s:4:\"post\";i:1;s:4:\"page\";i:2;s:7:\"members\";i:3;s:16:\"frontpage_blocks\";i:4;s:7:\"projekt\";i:5;s:8:\"partners\";i:6;s:12:\"tribe_events\";}s:28:\"last_known_public_taxonomies\";a:5:{i:0;s:8:\"category\";i:1;s:8:\"post_tag\";i:2;s:11:\"post_format\";i:3;s:8:\"services\";i:4;s:16:\"tribe_events_cat\";}s:23:\"last_known_no_unindexed\";a:4:{s:40:\"wpseo_total_unindexed_post_type_archives\";i:1740133368;s:35:\"wpseo_total_unindexed_general_items\";i:1740133368;s:31:\"wpseo_unindexed_term_link_count\";i:1740133368;s:31:\"wpseo_unindexed_post_link_count\";i:1740133368;}s:14:\"new_post_types\";a:0:{}s:14:\"new_taxonomies\";a:0:{}s:34:\"show_new_content_type_notification\";b:0;s:44:\"site_kit_configuration_permanently_dismissed\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("2424", "wpseo_titles", "a:223:{s:17:\"forcerewritetitle\";b:0;s:9:\"separator\";s:7:\"sc-dash\";s:16:\"title-home-wpseo\";s:42:\"%%sitename%% %%page%% %%sep%% %%sitedesc%%\";s:18:\"title-author-wpseo\";s:41:\"%%name%%, Szerző | %%sitename%% %%page%%\";s:19:\"title-archive-wpseo\";s:38:\"%%date%% %%page%% %%sep%% %%sitename%%\";s:18:\"title-search-wpseo\";s:56:\"Keresés: %%searchphrase%% %%page%% %%sep%% %%sitename%%\";s:15:\"title-404-wpseo\";s:45:\"Az oldal nem található %%sep%% %%sitename%%\";s:25:\"social-title-author-wpseo\";s:0:\"\";s:26:\"social-title-archive-wpseo\";s:0:\"\";s:31:\"social-description-author-wpseo\";s:0:\"\";s:32:\"social-description-archive-wpseo\";s:0:\"\";s:29:\"social-image-url-author-wpseo\";s:0:\"\";s:30:\"social-image-url-archive-wpseo\";s:0:\"\";s:28:\"social-image-id-author-wpseo\";i:0;s:29:\"social-image-id-archive-wpseo\";i:0;s:19:\"metadesc-home-wpseo\";s:0:\"\";s:21:\"metadesc-author-wpseo\";s:0:\"\";s:22:\"metadesc-archive-wpseo\";s:0:\"\";s:9:\"rssbefore\";s:0:\"\";s:8:\"rssafter\";s:0:\"\";s:20:\"noindex-author-wpseo\";b:0;s:28:\"noindex-author-noposts-wpseo\";b:1;s:21:\"noindex-archive-wpseo\";b:1;s:14:\"disable-author\";b:0;s:12:\"disable-date\";b:0;s:19:\"disable-post_format\";b:0;s:18:\"disable-attachment\";b:1;s:23:\"is-media-purge-relevant\";b:0;s:20:\"breadcrumbs-404crumb\";s:0:\"\";s:29:\"breadcrumbs-display-blog-page\";b:1;s:20:\"breadcrumbs-boldlast\";b:0;s:25:\"breadcrumbs-archiveprefix\";s:0:\"\";s:18:\"breadcrumbs-enable\";b:1;s:16:\"breadcrumbs-home\";s:0:\"\";s:18:\"breadcrumbs-prefix\";s:0:\"\";s:24:\"breadcrumbs-searchprefix\";s:0:\"\";s:15:\"breadcrumbs-sep\";s:0:\"\";s:12:\"website_name\";s:0:\"\";s:11:\"person_name\";s:0:\"\";s:11:\"person_logo\";s:0:\"\";s:22:\"alternate_website_name\";s:0:\"\";s:12:\"company_logo\";s:0:\"\";s:12:\"company_name\";s:0:\"\";s:17:\"company_or_person\";s:7:\"company\";s:25:\"company_or_person_user_id\";b:0;s:17:\"stripcategorybase\";b:0;s:26:\"open_graph_frontpage_title\";s:0:\"\";s:25:\"open_graph_frontpage_desc\";s:0:\"\";s:26:\"open_graph_frontpage_image\";s:0:\"\";s:10:\"title-post\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-post\";s:0:\"\";s:12:\"noindex-post\";b:0;s:23:\"display-metabox-pt-post\";b:1;s:23:\"post_types-post-maintax\";i:0;s:21:\"schema-page-type-post\";s:7:\"WebPage\";s:24:\"schema-article-type-post\";s:7:\"Article\";s:17:\"social-title-post\";s:0:\"\";s:23:\"social-description-post\";s:0:\"\";s:21:\"social-image-url-post\";s:0:\"\";s:20:\"social-image-id-post\";i:0;s:10:\"title-page\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:13:\"metadesc-page\";s:0:\"\";s:12:\"noindex-page\";b:0;s:23:\"display-metabox-pt-page\";b:1;s:23:\"post_types-page-maintax\";i:0;s:21:\"schema-page-type-page\";s:7:\"WebPage\";s:24:\"schema-article-type-page\";s:4:\"None\";s:17:\"social-title-page\";s:0:\"\";s:23:\"social-description-page\";s:0:\"\";s:21:\"social-image-url-page\";s:0:\"\";s:20:\"social-image-id-page\";i:0;s:16:\"title-attachment\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:19:\"metadesc-attachment\";s:0:\"\";s:18:\"noindex-attachment\";b:0;s:29:\"display-metabox-pt-attachment\";b:1;s:29:\"post_types-attachment-maintax\";i:0;s:27:\"schema-page-type-attachment\";s:7:\"WebPage\";s:30:\"schema-article-type-attachment\";s:4:\"None\";s:13:\"title-members\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-members\";s:0:\"\";s:15:\"noindex-members\";b:0;s:26:\"display-metabox-pt-members\";b:0;s:26:\"post_types-members-maintax\";i:0;s:24:\"schema-page-type-members\";s:7:\"WebPage\";s:27:\"schema-article-type-members\";s:4:\"None\";s:20:\"social-title-members\";s:0:\"\";s:26:\"social-description-members\";s:0:\"\";s:24:\"social-image-url-members\";s:0:\"\";s:23:\"social-image-id-members\";i:0;s:22:\"title-frontpage_blocks\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:25:\"metadesc-frontpage_blocks\";s:0:\"\";s:24:\"noindex-frontpage_blocks\";b:0;s:35:\"display-metabox-pt-frontpage_blocks\";b:1;s:35:\"post_types-frontpage_blocks-maintax\";i:0;s:33:\"schema-page-type-frontpage_blocks\";s:7:\"WebPage\";s:36:\"schema-article-type-frontpage_blocks\";s:4:\"None\";s:29:\"social-title-frontpage_blocks\";s:0:\"\";s:35:\"social-description-frontpage_blocks\";s:0:\"\";s:33:\"social-image-url-frontpage_blocks\";s:0:\"\";s:32:\"social-image-id-frontpage_blocks\";i:0;s:32:\"title-ptarchive-frontpage_blocks\";s:55:\"%%pt_plural%% Archívált %%page%% %%sep%% %%sitename%%\";s:35:\"metadesc-ptarchive-frontpage_blocks\";s:0:\"\";s:34:\"bctitle-ptarchive-frontpage_blocks\";s:0:\"\";s:34:\"noindex-ptarchive-frontpage_blocks\";b:0;s:39:\"social-title-ptarchive-frontpage_blocks\";s:0:\"\";s:45:\"social-description-ptarchive-frontpage_blocks\";s:0:\"\";s:43:\"social-image-url-ptarchive-frontpage_blocks\";s:0:\"\";s:42:\"social-image-id-ptarchive-frontpage_blocks\";i:0;s:13:\"title-projekt\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:16:\"metadesc-projekt\";s:0:\"\";s:15:\"noindex-projekt\";b:0;s:26:\"display-metabox-pt-projekt\";b:1;s:26:\"post_types-projekt-maintax\";i:0;s:24:\"schema-page-type-projekt\";s:7:\"WebPage\";s:27:\"schema-article-type-projekt\";s:4:\"None\";s:20:\"social-title-projekt\";s:0:\"\";s:26:\"social-description-projekt\";s:0:\"\";s:24:\"social-image-url-projekt\";s:0:\"\";s:23:\"social-image-id-projekt\";i:0;s:14:\"title-partners\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:17:\"metadesc-partners\";s:0:\"\";s:16:\"noindex-partners\";b:0;s:27:\"display-metabox-pt-partners\";b:1;s:27:\"post_types-partners-maintax\";i:0;s:25:\"schema-page-type-partners\";s:7:\"WebPage\";s:28:\"schema-article-type-partners\";s:4:\"None\";s:21:\"social-title-partners\";s:0:\"\";s:27:\"social-description-partners\";s:0:\"\";s:25:\"social-image-url-partners\";s:0:\"\";s:24:\"social-image-id-partners\";i:0;s:18:\"title-tribe_events\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tribe_events\";s:0:\"\";s:20:\"noindex-tribe_events\";b:0;s:31:\"display-metabox-pt-tribe_events\";b:0;s:31:\"post_types-tribe_events-maintax\";i:0;s:29:\"schema-page-type-tribe_events\";s:7:\"WebPage\";s:32:\"schema-article-type-tribe_events\";s:4:\"None\";s:25:\"social-title-tribe_events\";s:0:\"\";s:31:\"social-description-tribe_events\";s:0:\"\";s:29:\"social-image-url-tribe_events\";s:0:\"\";s:28:\"social-image-id-tribe_events\";i:0;s:28:\"title-ptarchive-tribe_events\";s:55:\"%%pt_plural%% Archívált %%page%% %%sep%% %%sitename%%\";s:31:\"metadesc-ptarchive-tribe_events\";s:0:\"\";s:30:\"bctitle-ptarchive-tribe_events\";s:0:\"\";s:30:\"noindex-ptarchive-tribe_events\";b:0;s:35:\"social-title-ptarchive-tribe_events\";s:0:\"\";s:41:\"social-description-ptarchive-tribe_events\";s:0:\"\";s:39:\"social-image-url-ptarchive-tribe_events\";s:0:\"\";s:38:\"social-image-id-ptarchive-tribe_events\";i:0;s:18:\"title-tax-category\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-category\";s:0:\"\";s:28:\"display-metabox-tax-category\";b:1;s:20:\"noindex-tax-category\";b:0;s:25:\"social-title-tax-category\";s:0:\"\";s:31:\"social-description-tax-category\";s:0:\"\";s:29:\"social-image-url-tax-category\";s:0:\"\";s:28:\"social-image-id-tax-category\";i:0;s:18:\"title-tax-post_tag\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-post_tag\";s:0:\"\";s:28:\"display-metabox-tax-post_tag\";b:1;s:20:\"noindex-tax-post_tag\";b:0;s:25:\"social-title-tax-post_tag\";s:0:\"\";s:31:\"social-description-tax-post_tag\";s:0:\"\";s:29:\"social-image-url-tax-post_tag\";s:0:\"\";s:28:\"social-image-id-tax-post_tag\";i:0;s:21:\"title-tax-post_format\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:24:\"metadesc-tax-post_format\";s:0:\"\";s:31:\"display-metabox-tax-post_format\";b:0;s:23:\"noindex-tax-post_format\";b:1;s:28:\"social-title-tax-post_format\";s:0:\"\";s:34:\"social-description-tax-post_format\";s:0:\"\";s:32:\"social-image-url-tax-post_format\";s:0:\"\";s:31:\"social-image-id-tax-post_format\";i:0;s:18:\"title-tax-services\";s:39:\"%%title%% %%page%% %%sep%% %%sitename%%\";s:21:\"metadesc-tax-services\";s:0:\"\";s:28:\"display-metabox-tax-services\";b:1;s:20:\"noindex-tax-services\";b:0;s:25:\"social-title-tax-services\";s:0:\"\";s:31:\"social-description-tax-services\";s:0:\"\";s:29:\"social-image-url-tax-services\";s:0:\"\";s:28:\"social-image-id-tax-services\";i:0;s:26:\"taxonomy-services-ptparent\";i:0;s:26:\"title-tax-tribe_events_cat\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:29:\"metadesc-tax-tribe_events_cat\";s:0:\"\";s:36:\"display-metabox-tax-tribe_events_cat\";b:1;s:28:\"noindex-tax-tribe_events_cat\";b:0;s:33:\"social-title-tax-tribe_events_cat\";s:0:\"\";s:39:\"social-description-tax-tribe_events_cat\";s:0:\"\";s:37:\"social-image-url-tax-tribe_events_cat\";s:0:\"\";s:36:\"social-image-id-tax-tribe_events_cat\";i:0;s:34:\"taxonomy-tribe_events_cat-ptparent\";i:0;s:14:\"person_logo_id\";i:0;s:15:\"company_logo_id\";i:0;s:17:\"company_logo_meta\";b:0;s:16:\"person_logo_meta\";b:0;s:29:\"open_graph_frontpage_image_id\";i:0;s:27:\"display-metabox-pt-services\";b:0;s:27:\"post_types-services-maintax\";b:0;s:25:\"schema-page-type-services\";b:0;s:28:\"schema-article-type-services\";b:0;s:21:\"social-title-services\";b:0;s:27:\"social-description-services\";b:0;s:25:\"social-image-url-services\";b:0;s:24:\"social-image-id-services\";b:0;s:20:\"title-tax-activities\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:23:\"metadesc-tax-activities\";s:0:\"\";s:22:\"noindex-tax-activities\";b:0;s:27:\"social-title-tax-activities\";b:0;s:33:\"social-description-tax-activities\";b:0;s:31:\"social-image-url-tax-activities\";b:0;s:30:\"social-image-id-tax-activities\";b:0;s:28:\"taxonomy-activities-ptparent\";b:0;s:15:\"title-tax-areas\";s:54:\"%%term_title%% Archívum %%page%% %%sep%% %%sitename%%\";s:18:\"metadesc-tax-areas\";s:0:\"\";s:17:\"noindex-tax-areas\";b:0;s:22:\"social-title-tax-areas\";b:0;s:28:\"social-description-tax-areas\";b:0;s:26:\"social-image-url-tax-areas\";b:0;s:25:\"social-image-id-tax-areas\";b:0;s:23:\"taxonomy-areas-ptparent\";b:0;s:26:\"taxonomy-category-ptparent\";b:0;s:26:\"taxonomy-post_tag-ptparent\";b:0;s:29:\"taxonomy-post_format-ptparent\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("2425", "wpseo_social", "a:18:{s:13:\"facebook_site\";s:0:\"\";s:13:\"instagram_url\";s:0:\"\";s:12:\"linkedin_url\";s:0:\"\";s:11:\"myspace_url\";s:0:\"\";s:16:\"og_default_image\";s:0:\"\";s:19:\"og_default_image_id\";s:0:\"\";s:18:\"og_frontpage_title\";s:0:\"\";s:17:\"og_frontpage_desc\";s:0:\"\";s:18:\"og_frontpage_image\";s:0:\"\";s:21:\"og_frontpage_image_id\";s:0:\"\";s:9:\"opengraph\";b:1;s:13:\"pinterest_url\";s:0:\"\";s:15:\"pinterestverify\";s:0:\"\";s:7:\"twitter\";b:1;s:12:\"twitter_site\";s:0:\"\";s:17:\"twitter_card_type\";s:19:\"summary_large_image\";s:11:\"youtube_url\";s:0:\"\";s:13:\"wikipedia_url\";s:0:\"\";}", "yes");
INSERT INTO `wp_options` VALUES("2441", "wpseo_ryte", "a:2:{s:6:\"status\";i:0;s:10:\"last_fetch\";i:1629207485;}", "yes");
INSERT INTO `wp_options` VALUES("2696", "ure_tasks_queue", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("3038", "duplicate_page_options", "a:4:{s:21:\"duplicate_post_status\";s:5:\"draft\";s:23:\"duplicate_post_redirect\";s:7:\"to_list\";s:21:\"duplicate_post_suffix\";s:0:\"\";s:21:\"duplicate_post_editor\";s:7:\"classic\";}", "yes");
INSERT INTO `wp_options` VALUES("3432", "widget_block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("3542", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("3568", "wpseo_taxonomy_meta", "a:2:{s:8:\"services\";a:11:{i:15;a:3:{s:13:\"wpseo_focuskw\";s:11:\"innováció\";s:13:\"wpseo_linkdex\";s:2:\"39\";s:19:\"wpseo_content_score\";s:2:\"90\";}i:22;a:3:{s:13:\"wpseo_focuskw\";s:17:\"Érdekképviselet\";s:13:\"wpseo_linkdex\";s:2:\"24\";s:19:\"wpseo_content_score\";s:2:\"30\";}i:21;a:3:{s:13:\"wpseo_focuskw\";s:14:\"kommunikáció\";s:13:\"wpseo_linkdex\";s:2:\"31\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:20;a:3:{s:13:\"wpseo_focuskw\";s:12:\"piacszerzés\";s:13:\"wpseo_linkdex\";s:2:\"31\";s:19:\"wpseo_content_score\";s:2:\"90\";}i:19;a:3:{s:13:\"wpseo_focuskw\";s:28:\"információ szolgáltatása\";s:13:\"wpseo_linkdex\";s:2:\"36\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:18;a:3:{s:13:\"wpseo_focuskw\";s:19:\"kapacitástervezés\";s:13:\"wpseo_linkdex\";s:2:\"24\";s:19:\"wpseo_content_score\";s:2:\"90\";}i:17;a:3:{s:13:\"wpseo_focuskw\";s:10:\"képzések\";s:13:\"wpseo_linkdex\";s:2:\"28\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:16;a:3:{s:13:\"wpseo_focuskw\";s:22:\"marketing tanácsadás\";s:13:\"wpseo_linkdex\";s:2:\"31\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:12;a:3:{s:13:\"wpseo_focuskw\";s:18:\"projektgenerálás\";s:13:\"wpseo_linkdex\";s:2:\"24\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:13;a:3:{s:13:\"wpseo_focuskw\";s:21:\"rendezvényszervezés\";s:13:\"wpseo_linkdex\";s:2:\"24\";s:19:\"wpseo_content_score\";s:2:\"60\";}i:14;a:3:{s:13:\"wpseo_focuskw\";s:12:\"pályázatok\";s:13:\"wpseo_linkdex\";s:2:\"21\";s:19:\"wpseo_content_score\";s:2:\"90\";}}s:16:\"tribe_events_cat\";a:2:{i:9;a:3:{s:13:\"wpseo_focuskw\";s:8:\"ingyenes\";s:13:\"wpseo_linkdex\";s:2:\"28\";s:19:\"wpseo_content_score\";s:1:\"0\";}i:10;a:3:{s:13:\"wpseo_focuskw\";s:9:\"kültéri\";s:13:\"wpseo_linkdex\";s:2:\"28\";s:19:\"wpseo_content_score\";s:1:\"0\";}}}", "yes");
INSERT INTO `wp_options` VALUES("3679", "qtranslate_term_name", "a:13:{s:8:\"ingyenes\";a:2:{s:2:\"hu\";s:8:\"ingyenes\";s:2:\"en\";s:4:\"free\";}s:9:\"kültéri\";a:2:{s:2:\"hu\";s:9:\"kültéri\";s:2:\"en\";s:7:\"outside\";}s:14:\"kommunikáció\";a:2:{s:2:\"hu\";s:14:\"kommunikáció\";s:2:\"en\";s:13:\"Communication\";}s:17:\"Érdekképviselet\";a:2:{s:2:\"hu\";s:17:\"Érdekképviselet\";s:2:\"en\";s:8:\"Advocacy\";}s:12:\"piacszerzés\";a:2:{s:2:\"hu\";s:12:\"piacszerzés\";s:2:\"en\";s:15:\"Promoting sales\";}s:28:\"információ szolgáltatása\";a:2:{s:2:\"hu\";s:28:\"információ szolgáltatása\";s:2:\"en\";s:19:\"Information service\";}s:19:\"kapacitástervezés\";a:2:{s:2:\"hu\";s:19:\"kapacitástervezés\";s:2:\"en\";s:17:\"Capacity planning\";}s:10:\"képzések\";a:2:{s:2:\"hu\";s:10:\"képzések\";s:2:\"en\";s:8:\"training\";}s:22:\"marketing tanácsadás\";a:2:{s:2:\"hu\";s:22:\"marketing tanácsadás\";s:2:\"en\";s:21:\"Marketing consultancy\";}s:18:\"projektgenerálás\";a:2:{s:2:\"hu\";s:18:\"projektgenerálás\";s:2:\"en\";s:18:\"Project generation\";}s:21:\"rendezvényszervezés\";a:2:{s:2:\"hu\";s:21:\"rendezvényszervezés\";s:2:\"en\";s:16:\"Event management\";}s:12:\"pályázatok\";a:2:{s:2:\"hu\";s:12:\"pályázatok\";s:2:\"en\";s:7:\"Tenders\";}s:11:\"innováció\";a:2:{s:2:\"hu\";s:11:\"innováció\";s:2:\"en\";s:10:\"innovation\";}}", "yes");
INSERT INTO `wp_options` VALUES("4060", "auto_update_plugins", "a:21:{i:0;s:30:\"advanced-custom-fields/acf.php\";i:1;s:37:\"ajax-search-lite/ajax-search-lite.php\";i:2;s:19:\"akismet/akismet.php\";i:3;s:32:\"duplicate-page/duplicatepage.php\";i:4;s:43:\"custom-post-type-ui/custom-post-type-ui.php\";i:5;s:9:\"hello.php\";i:6;s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";i:7;s:25:\"loginpress/loginpress.php\";i:8;s:33:\"classic-editor/classic-editor.php\";i:9;s:48:\"capability-manager-enhanced/capsman-enhanced.php\";i:10;s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";i:11;s:43:\"the-events-calendar/the-events-calendar.php\";i:12;s:31:\"search-filter/search-filter.php\";i:13;s:37:\"user-role-editor/user-role-editor.php\";i:14;s:24:\"wordpress-seo/wp-seo.php\";i:15;s:40:\"wordpress-seo-premium/wp-seo-premium.php\";i:16;s:25:\"wpseo-video/video-seo.php\";i:17;s:25:\"wpseo-local/local-seo.php\";i:18;s:39:\"wpseo-woocommerce/wpseo-woocommerce.php\";i:19;s:25:\"wpseo-news/wpseo-news.php\";i:20;s:57:\"acf-content-analysis-for-yoast-seo/yoast-acf-analysis.php\";}", "no");
INSERT INTO `wp_options` VALUES("4087", "tribe_events_cat_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4202", "rsssl_mixed_content_scan_dismissed", "1", "yes");
INSERT INTO `wp_options` VALUES("4203", "rsssl_google_analytics_dismissed", "1", "yes");
INSERT INTO `wp_options` VALUES("4365", "qtranslate_ignore_file_types", "gif,jpg,jpeg,png,svg,pdf,swf,tif,rar,zip,7z,mpg,divx,mpeg,avi,css,js,mp3,mp4,apk", "yes");
INSERT INTO `wp_options` VALUES("4382", "services_children", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("4964", "user_role_editor", "a:1:{s:11:\"ure_version\";s:6:\"4.60.1\";}", "yes");
INSERT INTO `wp_options` VALUES("4965", "wp_backup_user_roles", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:109:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("4970", "ure_role_additional_options_values", "a:1:{s:6:\"author\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("5001", "members_addons_migrated", "1", "yes");
INSERT INTO `wp_options` VALUES("5002", "widget_members-widget-login", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5003", "widget_members-widget-users", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("5007", "cptui_post_types", "a:4:{s:7:\"members\";a:30:{s:4:\"name\";s:7:\"members\";s:5:\"label\";s:5:\"Tagok\";s:14:\"singular_label\";s:3:\"Tag\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:4:\"true\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:6:\"author\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:16:\"frontpage_blocks\";a:30:{s:4:\"name\";s:16:\"frontpage_blocks\";s:5:\"label\";s:16:\"frontpage_blocks\";s:14:\"singular_label\";s:15:\"frontpage_block\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:4:\"true\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:4:\"true\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:4:\"true\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:4:\"true\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:13:\"custom-fields\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:11:\"Keződoldal\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:7:\"projekt\";a:30:{s:4:\"name\";s:7:\"projekt\";s:5:\"label\";s:9:\"Projektek\";s:14:\"singular_label\";s:7:\"projekt\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:4:\"true\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:3:{i:0;s:5:\"title\";i:1;s:6:\"editor\";i:2;s:9:\"thumbnail\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}s:8:\"partners\";a:30:{s:4:\"name\";s:8:\"partners\";s:5:\"label\";s:9:\"Partnerek\";s:14:\"singular_label\";s:7:\"Partner\";s:11:\"description\";s:0:\"\";s:6:\"public\";s:4:\"true\";s:18:\"publicly_queryable\";s:4:\"true\";s:7:\"show_ui\";s:4:\"true\";s:17:\"show_in_nav_menus\";s:4:\"true\";s:16:\"delete_with_user\";s:5:\"false\";s:12:\"show_in_rest\";s:4:\"true\";s:9:\"rest_base\";s:0:\"\";s:21:\"rest_controller_class\";s:0:\"\";s:11:\"has_archive\";s:5:\"false\";s:18:\"has_archive_string\";s:0:\"\";s:19:\"exclude_from_search\";s:5:\"false\";s:15:\"capability_type\";s:4:\"post\";s:12:\"hierarchical\";s:5:\"false\";s:7:\"rewrite\";s:4:\"true\";s:12:\"rewrite_slug\";s:0:\"\";s:17:\"rewrite_withfront\";s:4:\"true\";s:9:\"query_var\";s:4:\"true\";s:14:\"query_var_slug\";s:0:\"\";s:13:\"menu_position\";s:0:\"\";s:12:\"show_in_menu\";s:4:\"true\";s:19:\"show_in_menu_string\";s:0:\"\";s:9:\"menu_icon\";s:0:\"\";s:8:\"supports\";a:2:{i:0;s:5:\"title\";i:1;s:6:\"editor\";}s:10:\"taxonomies\";a:0:{}s:6:\"labels\";a:29:{s:9:\"menu_name\";s:0:\"\";s:9:\"all_items\";s:0:\"\";s:7:\"add_new\";s:0:\"\";s:12:\"add_new_item\";s:0:\"\";s:9:\"edit_item\";s:0:\"\";s:8:\"new_item\";s:0:\"\";s:9:\"view_item\";s:0:\"\";s:10:\"view_items\";s:0:\"\";s:12:\"search_items\";s:0:\"\";s:9:\"not_found\";s:0:\"\";s:18:\"not_found_in_trash\";s:0:\"\";s:17:\"parent_item_colon\";s:0:\"\";s:14:\"featured_image\";s:0:\"\";s:18:\"set_featured_image\";s:0:\"\";s:21:\"remove_featured_image\";s:0:\"\";s:18:\"use_featured_image\";s:0:\"\";s:8:\"archives\";s:0:\"\";s:16:\"insert_into_item\";s:0:\"\";s:21:\"uploaded_to_this_item\";s:0:\"\";s:17:\"filter_items_list\";s:0:\"\";s:21:\"items_list_navigation\";s:0:\"\";s:10:\"items_list\";s:0:\"\";s:10:\"attributes\";s:0:\"\";s:14:\"name_admin_bar\";s:0:\"\";s:14:\"item_published\";s:0:\"\";s:24:\"item_published_privately\";s:0:\"\";s:22:\"item_reverted_to_draft\";s:0:\"\";s:14:\"item_scheduled\";s:0:\"\";s:12:\"item_updated\";s:0:\"\";}s:15:\"custom_supports\";s:0:\"\";}}", "yes");
INSERT INTO `wp_options` VALUES("5014", "wpfront-user-role-editor-db-version", "2.14.4", "yes");
INSERT INTO `wp_options` VALUES("5017", "capsman_version", "2.16.0", "yes");
INSERT INTO `wp_options` VALUES("5018", "capsman_backup", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:142:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5019", "capsman_backup_datestamp", "1629801778", "no");
INSERT INTO `wp_options` VALUES("5020", "cme_backup_auto_2021-08-24_10-42-58_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:142:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5021", "presspermit_enabled_post_types", "a:4:{s:4:\"post\";b:1;s:4:\"page\";b:1;s:12:\"tribe_events\";b:1;s:7:\"members\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("5022", "cme_enabled_post_types", "a:4:{s:4:\"post\";b:1;s:4:\"page\";b:1;s:12:\"tribe_events\";b:1;s:7:\"members\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("5023", "presspermit_enabled_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5024", "cme_detailed_taxonomies", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("5025", "cme_backup_auto_2021-08-24_10-46-56_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:18:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5026", "cme_backup_auto_2021-08-24_10-47-47_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:20:\"edit_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5027", "cme_backup_auto_2021-08-24_10-49-38_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:13:\"publish_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5028", "cme_backup_auto_2021-08-24_10-50-28_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5031", "cme_backup_auto_2021-08-24_10-54-13_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:39:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5032", "cme_backup_auto_2021-08-24_11-01-16_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:79:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:25:\"read_private_tribe_events\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5105", "cme_backup_auto_2021-08-25_6-46-52_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:83:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5106", "cme_backup_auto_2021-08-25_6-49-08_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:84:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;s:12:\"create_users\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:19:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5285", "cme_backup_auto_2021-08-27_8-05-42_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:84:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;s:12:\"create_users\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:23:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5296", "cme_backup_auto_2021-08-27_8-50-42_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:84:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;s:12:\"create_users\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("5321", "cme_backup_auto_2021-08-27_10-26-14_am", "a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:143:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:19:\"delete_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:21:\"edit_tribe_organizers\";b:1;s:31:\"edit_published_tribe_organizers\";b:1;s:28:\"edit_others_tribe_organizers\";b:1;s:29:\"edit_private_tribe_organizers\";b:1;s:24:\"publish_tribe_organizers\";b:1;s:29:\"read_private_tribe_organizers\";b:1;s:23:\"delete_tribe_organizers\";b:1;s:31:\"delete_private_tribe_organizers\";b:1;s:33:\"delete_published_tribe_organizers\";b:1;s:30:\"delete_others_tribe_organizers\";b:1;s:17:\"edit_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:25:\"read_private_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:23:\"edit_aggregator-records\";b:1;s:33:\"edit_published_aggregator-records\";b:1;s:30:\"edit_others_aggregator-records\";b:1;s:31:\"edit_private_aggregator-records\";b:1;s:26:\"publish_aggregator-records\";b:1;s:31:\"read_private_aggregator-records\";b:1;s:25:\"delete_aggregator-records\";b:1;s:33:\"delete_private_aggregator-records\";b:1;s:35:\"delete_published_aggregator-records\";b:1;s:32:\"delete_others_aggregator-records\";b:1;s:12:\"create_posts\";b:1;s:17:\"install_languages\";b:1;s:14:\"resume_plugins\";b:1;s:13:\"resume_themes\";b:1;s:23:\"view_site_health_checks\";b:1;s:15:\"wpseo_bulk_edit\";b:1;s:28:\"wpseo_edit_advanced_metadata\";b:1;s:20:\"wpseo_manage_options\";b:1;s:14:\"ure_edit_roles\";b:1;s:16:\"ure_create_roles\";b:1;s:16:\"ure_delete_roles\";b:1;s:23:\"ure_create_capabilities\";b:1;s:23:\"ure_delete_capabilities\";b:1;s:18:\"ure_manage_options\";b:1;s:15:\"ure_reset_roles\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"restrict_content\";b:1;s:10:\"list_roles\";b:1;s:12:\"create_roles\";b:1;s:12:\"delete_roles\";b:1;s:10:\"edit_roles\";b:1;s:15:\"edit_role_menus\";b:1;s:27:\"edit_posts_role_permissions\";b:1;s:27:\"edit_pages_role_permissions\";b:1;s:25:\"edit_nav_menu_permissions\";b:1;s:23:\"edit_content_shortcodes\";b:1;s:25:\"delete_content_shortcodes\";b:1;s:20:\"edit_login_redirects\";b:1;s:22:\"delete_login_redirects\";b:1;s:15:\"bulk_edit_roles\";b:1;s:23:\"edit_widget_permissions\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:23:\"edit_users_higher_level\";b:1;s:25:\"delete_users_higher_level\";b:1;s:26:\"promote_users_higher_level\";b:1;s:29:\"promote_users_to_higher_level\";b:1;s:19:\"manage_capabilities\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:74:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:23:\"read_others_attachments\";b:1;s:23:\"edit_others_attachments\";b:1;s:25:\"delete_others_attachments\";b:1;s:12:\"edit_members\";b:1;s:19:\"edit_others_members\";b:1;s:15:\"publish_members\";b:1;s:22:\"edit_published_members\";b:1;s:20:\"edit_private_members\";b:1;s:17:\"edit_tribe_venues\";b:1;s:24:\"edit_others_tribe_venues\";b:1;s:20:\"publish_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;s:25:\"edit_private_tribe_venues\";b:1;s:17:\"edit_tribe_events\";b:1;s:24:\"edit_others_tribe_events\";b:1;s:20:\"publish_tribe_events\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:25:\"edit_private_tribe_events\";b:1;s:14:\"delete_members\";b:1;s:21:\"delete_others_members\";b:1;s:24:\"delete_published_members\";b:1;s:22:\"delete_private_members\";b:1;s:19:\"delete_tribe_venues\";b:1;s:26:\"delete_others_tribe_venues\";b:1;s:29:\"delete_published_tribe_venues\";b:1;s:27:\"delete_private_tribe_venues\";b:1;s:19:\"delete_tribe_events\";b:1;s:26:\"delete_others_tribe_events\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:27:\"delete_private_tribe_events\";b:1;s:20:\"read_private_members\";b:1;s:25:\"read_private_tribe_venues\";b:1;s:25:\"read_private_tribe_events\";b:1;s:12:\"delete_users\";b:1;s:10:\"edit_users\";b:1;s:10:\"list_users\";b:1;s:13:\"promote_users\";b:1;s:12:\"create_users\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:20:{s:12:\"delete_posts\";b:1;s:29:\"delete_published_tribe_events\";b:1;s:19:\"delete_tribe_events\";b:1;s:10:\"edit_posts\";b:1;s:27:\"edit_published_tribe_events\";b:1;s:17:\"edit_tribe_events\";b:1;s:7:\"level_0\";b:1;s:7:\"level_1\";b:1;s:7:\"level_2\";b:1;s:20:\"publish_tribe_events\";b:1;s:20:\"publish_tribe_venues\";b:1;s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:22:\"edit_published_members\";b:1;s:16:\"edit_attachments\";b:1;s:18:\"delete_attachments\";b:1;s:12:\"edit_members\";b:1;s:22:\"delete_published_posts\";b:1;s:17:\"edit_tribe_venues\";b:1;s:27:\"edit_published_tribe_venues\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}", "no");
INSERT INTO `wp_options` VALUES("9217", "wordfence_ls_version", "1.1.15", "yes");
INSERT INTO `wp_options` VALUES("9218", "wfls_last_role_change", "1737028150", "off");
INSERT INTO `wp_options` VALUES("9219", "wordfence_version", "8.0.3", "yes");
INSERT INTO `wp_options` VALUES("9220", "wordfence_case", "1", "yes");
INSERT INTO `wp_options` VALUES("9221", "wordfence_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("9222", "wordfenceActivated", "1", "yes");
INSERT INTO `wp_options` VALUES("9223", "wf_plugin_act_error", "", "yes");
INSERT INTO `wp_options` VALUES("9252", "wordfence_syncAttackDataAttempts", "0", "off");
INSERT INTO `wp_options` VALUES("9253", "wordfence_syncingAttackData", "0", "off");
INSERT INTO `wp_options` VALUES("9254", "wordfence_lastSyncAttackData", "1740123352", "off");
INSERT INTO `wp_options` VALUES("11950", "db_upgraded", "", "on");
INSERT INTO `wp_options` VALUES("16733", "new_admin_email", "web@effix.hu", "yes");
INSERT INTO `wp_options` VALUES("16749", "fm_key", "5uR14Ao2KC3GP9es6EkwQnlTx", "yes");
INSERT INTO `wp_options` VALUES("16763", "filemanager_email_verified_40", "yes", "yes");
INSERT INTO `wp_options` VALUES("26685", "wp_calendar_block_has_published_posts", "1", "yes");
INSERT INTO `wp_options` VALUES("38188", "rewrite_rules", "a:330:{s:28:\"tribe/events/kitchen-sink/?$\";s:69:\"index.php?post_type=tribe_events&tribe_events_views_kitchen_sink=page\";s:93:\"tribe/events/kitchen-sink/(page|grid|typographical|elements|events-bar|navigation|manager)/?$\";s:76:\"index.php?post_type=tribe_events&tribe_events_views_kitchen_sink=$matches[1]\";s:28:\"event-aggregator/(insert)/?$\";s:53:\"index.php?tribe-aggregator=1&tribe-action=$matches[1]\";s:27:\"(?:esemeny)/([^/]+)/ical/?$\";s:56:\"index.php?ical=1&name=$matches[1]&post_type=tribe_events\";s:31:\"(?:esemenyek)/(?:page)/(\\d+)/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=default&paged=$matches[1]\";s:44:\"(?:esemenyek)/(?:featured)/(?:page)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&paged=$matches[1]\";s:41:\"(?:esemenyek)/(feed|rdf|rss|rss2|atom)/?$\";s:67:\"index.php?post_type=tribe_events&eventDisplay=list&feed=$matches[1]\";s:54:\"(?:esemenyek)/(?:featured)/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&featured=1&eventDisplay=list&feed=$matches[1]\";s:26:\"(?:esemenyek)/(?:month)/?$\";s:51:\"index.php?post_type=tribe_events&eventDisplay=month\";s:39:\"(?:esemenyek)/(?:month)/(?:featured)/?$\";s:62:\"index.php?post_type=tribe_events&eventDisplay=month&featured=1\";s:40:\"(?:esemenyek)/(?:month)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:40:\"(?:esemenyek)/(?:list)/(?:page)/(\\d+)/?$\";s:68:\"index.php?post_type=tribe_events&eventDisplay=list&paged=$matches[1]\";s:53:\"(?:esemenyek)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:79:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1&paged=$matches[1]\";s:25:\"(?:esemenyek)/(?:list)/?$\";s:50:\"index.php?post_type=tribe_events&eventDisplay=list\";s:38:\"(?:esemenyek)/(?:list)/(?:featured)/?$\";s:61:\"index.php?post_type=tribe_events&eventDisplay=list&featured=1\";s:26:\"(?:esemenyek)/(?:today)/?$\";s:49:\"index.php?post_type=tribe_events&eventDisplay=day\";s:39:\"(?:esemenyek)/(?:today)/(?:featured)/?$\";s:60:\"index.php?post_type=tribe_events&eventDisplay=day&featured=1\";s:30:\"(?:esemenyek)/(\\d{4}-\\d{2})/?$\";s:73:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]\";s:43:\"(?:esemenyek)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:84:\"index.php?post_type=tribe_events&eventDisplay=month&eventDate=$matches[1]&featured=1\";s:36:\"(?:esemenyek)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:71:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]\";s:49:\"(?:esemenyek)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:82:\"index.php?post_type=tribe_events&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:29:\"(?:esemenyek)/(?:featured)/?$\";s:43:\"index.php?post_type=tribe_events&featured=1\";s:16:\"(?:esemenyek)/?$\";s:53:\"index.php?post_type=tribe_events&eventDisplay=default\";s:21:\"(?:esemenyek)/ical/?$\";s:39:\"index.php?post_type=tribe_events&ical=1\";s:34:\"(?:esemenyek)/(?:featured)/ical/?$\";s:50:\"index.php?post_type=tribe_events&ical=1&featured=1\";s:41:\"(?:esemenyek)/(\\d{4}-\\d{2}-\\d{2})/ical/?$\";s:78:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]\";s:54:\"(?:esemenyek)/(\\d{4}-\\d{2}-\\d{2})/ical/(?:featured)/?$\";s:89:\"index.php?post_type=tribe_events&ical=1&eventDisplay=day&eventDate=$matches[1]&featured=1\";s:63:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:76:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/(?:page)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:58:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:month)/?$\";s:80:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month\";s:71:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:month)/(?:featured)/?$\";s:91:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&featured=1\";s:72:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:page)/(\\d+)/?$\";s:97:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:85:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:108:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:57:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list\";s:70:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:list)/(?:featured)/?$\";s:90:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&featured=1\";s:58:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:today)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day\";s:71:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:today)/(?:featured)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&featured=1\";s:76:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:89:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:62:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/?$\";s:102:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:75:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:113:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:68:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:81:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:111:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:53:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/feed/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=list&feed=rss2\";s:66:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/feed/?$\";s:100:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=list&feed=rss2\";s:53:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/ical/?$\";s:68:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&ical=1\";s:66:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/ical/?$\";s:79:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&ical=1\";s:78:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:78:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&feed=$matches[2]\";s:91:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:89:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&feed=$matches[2]\";s:61:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/(?:featured)/?$\";s:93:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&featured=1&eventDisplay=default\";s:48:\"(?:esemenyek)/(?:category)/(?:[^/]+/)*([^/]+)/?$\";s:82:\"index.php?post_type=tribe_events&tribe_events_cat=$matches[1]&eventDisplay=default\";s:47:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:60:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:featured)/(?:page)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&eventDisplay=list&paged=$matches[2]\";s:42:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:month)/?$\";s:67:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month\";s:55:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:month)/(?:featured)/?$\";s:78:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&featured=1\";s:56:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:list)/(?:page)/(\\d+)/?$\";s:84:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&paged=$matches[2]\";s:69:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:list)/(?:featured)/(?:page)/(\\d+)/?$\";s:95:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1&paged=$matches[2]\";s:41:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:list)/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list\";s:54:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:list)/(?:featured)/?$\";s:77:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&featured=1\";s:42:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:today)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day\";s:55:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:today)/(?:featured)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&featured=1\";s:60:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:73:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:day)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:46:\"(?:esemenyek)/(?:tag)/([^/]+)/(\\d{4}-\\d{2})/?$\";s:89:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]\";s:59:\"(?:esemenyek)/(?:tag)/([^/]+)/(\\d{4}-\\d{2})/(?:featured)/?$\";s:100:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=month&eventDate=$matches[2]&featured=1\";s:52:\"(?:esemenyek)/(?:tag)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]\";s:65:\"(?:esemenyek)/(?:tag)/([^/]+)/(\\d{4}-\\d{2}-\\d{2})/(?:featured)/?$\";s:98:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=day&eventDate=$matches[2]&featured=1\";s:37:\"(?:esemenyek)/(?:tag)/([^/]+)/feed/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2\";s:50:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:featured)/feed/?$\";s:87:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=list&feed=rss2&featured=1\";s:37:\"(?:esemenyek)/(?:tag)/([^/]+)/ical/?$\";s:55:\"index.php?post_type=tribe_events&tag=$matches[1]&ical=1\";s:50:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:featured)/ical/?$\";s:66:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&ical=1\";s:62:\"(?:esemenyek)/(?:tag)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:65:\"index.php?post_type=tribe_events&tag=$matches[1]&feed=$matches[2]\";s:75:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:featured)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:76:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1&feed=$matches[2]\";s:45:\"(?:esemenyek)/(?:tag)/([^/]+)/(?:featured)/?$\";s:59:\"index.php?post_type=tribe_events&tag=$matches[1]&featured=1\";s:32:\"(?:esemenyek)/(?:tag)/([^/]+)/?$\";s:69:\"index.php?post_type=tribe_events&tag=$matches[1]&eventDisplay=default\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:19:\"frontpage_blocks/?$\";s:36:\"index.php?post_type=frontpage_blocks\";s:49:\"frontpage_blocks/feed/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=frontpage_blocks&feed=$matches[1]\";s:44:\"frontpage_blocks/(feed|rdf|rss|rss2|atom)/?$\";s:53:\"index.php?post_type=frontpage_blocks&feed=$matches[1]\";s:36:\"frontpage_blocks/page/([0-9]{1,})/?$\";s:54:\"index.php?post_type=frontpage_blocks&paged=$matches[1]\";s:22:\"tribe-promoter-auth/?$\";s:37:\"index.php?tribe-promoter-auth-check=1\";s:10:\"esemeny/?$\";s:32:\"index.php?post_type=tribe_events\";s:40:\"esemeny/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:35:\"esemeny/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=tribe_events&feed=$matches[1]\";s:27:\"esemeny/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=tribe_events&paged=$matches[1]\";s:14:\"^hu/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:17:\"^hu/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:24:\"^hu/index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:27:\"^hu/index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:49:\"services/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:44:\"services/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?services=$matches[1]&feed=$matches[2]\";s:25:\"services/([^/]+)/embed/?$\";s:41:\"index.php?services=$matches[1]&embed=true\";s:37:\"services/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?services=$matches[1]&paged=$matches[2]\";s:19:\"services/([^/]+)/?$\";s:30:\"index.php?services=$matches[1]\";s:35:\"members/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"members/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"members/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"members/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"members/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"members/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"members/([^/]+)/embed/?$\";s:40:\"index.php?members=$matches[1]&embed=true\";s:28:\"members/([^/]+)/trackback/?$\";s:34:\"index.php?members=$matches[1]&tb=1\";s:36:\"members/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?members=$matches[1]&paged=$matches[2]\";s:43:\"members/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?members=$matches[1]&cpage=$matches[2]\";s:32:\"members/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?members=$matches[1]&page=$matches[2]\";s:24:\"members/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"members/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"members/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"members/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"members/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"members/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:42:\"frontpage_blocks/.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"frontpage_blocks/.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"frontpage_blocks/.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"frontpage_blocks/.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"frontpage_blocks/.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"frontpage_blocks/.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"frontpage_blocks/(.+?)/embed/?$\";s:49:\"index.php?frontpage_blocks=$matches[1]&embed=true\";s:35:\"frontpage_blocks/(.+?)/trackback/?$\";s:43:\"index.php?frontpage_blocks=$matches[1]&tb=1\";s:55:\"frontpage_blocks/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?frontpage_blocks=$matches[1]&feed=$matches[2]\";s:50:\"frontpage_blocks/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?frontpage_blocks=$matches[1]&feed=$matches[2]\";s:43:\"frontpage_blocks/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?frontpage_blocks=$matches[1]&paged=$matches[2]\";s:50:\"frontpage_blocks/(.+?)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?frontpage_blocks=$matches[1]&cpage=$matches[2]\";s:39:\"frontpage_blocks/(.+?)(?:/([0-9]+))?/?$\";s:55:\"index.php?frontpage_blocks=$matches[1]&page=$matches[2]\";s:35:\"projekt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"projekt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"projekt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"projekt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"projekt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"projekt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"projekt/([^/]+)/embed/?$\";s:40:\"index.php?projekt=$matches[1]&embed=true\";s:28:\"projekt/([^/]+)/trackback/?$\";s:34:\"index.php?projekt=$matches[1]&tb=1\";s:36:\"projekt/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?projekt=$matches[1]&paged=$matches[2]\";s:43:\"projekt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?projekt=$matches[1]&cpage=$matches[2]\";s:32:\"projekt/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?projekt=$matches[1]&page=$matches[2]\";s:24:\"projekt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"projekt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"projekt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"projekt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"projekt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"projekt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"partners/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"partners/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"partners/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"partners/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"partners/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"partners/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"partners/([^/]+)/embed/?$\";s:41:\"index.php?partners=$matches[1]&embed=true\";s:29:\"partners/([^/]+)/trackback/?$\";s:35:\"index.php?partners=$matches[1]&tb=1\";s:37:\"partners/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?partners=$matches[1]&paged=$matches[2]\";s:44:\"partners/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?partners=$matches[1]&cpage=$matches[2]\";s:33:\"partners/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?partners=$matches[1]&page=$matches[2]\";s:25:\"partners/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"partners/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"partners/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"partners/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"partners/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"partners/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"venue/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"venue/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"venue/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"venue/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"venue/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"venue/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:22:\"venue/([^/]+)/embed/?$\";s:44:\"index.php?tribe_venue=$matches[1]&embed=true\";s:26:\"venue/([^/]+)/trackback/?$\";s:38:\"index.php?tribe_venue=$matches[1]&tb=1\";s:34:\"venue/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&paged=$matches[2]\";s:41:\"venue/([^/]+)/comment-page-([0-9]{1,})/?$\";s:51:\"index.php?tribe_venue=$matches[1]&cpage=$matches[2]\";s:30:\"venue/([^/]+)(?:/([0-9]+))?/?$\";s:50:\"index.php?tribe_venue=$matches[1]&page=$matches[2]\";s:22:\"venue/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:32:\"venue/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:52:\"venue/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"venue/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:47:\"venue/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:28:\"venue/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"organizer/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"organizer/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"organizer/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"organizer/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"organizer/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"organizer/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"organizer/([^/]+)/embed/?$\";s:48:\"index.php?tribe_organizer=$matches[1]&embed=true\";s:30:\"organizer/([^/]+)/trackback/?$\";s:42:\"index.php?tribe_organizer=$matches[1]&tb=1\";s:38:\"organizer/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&paged=$matches[2]\";s:45:\"organizer/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?tribe_organizer=$matches[1]&cpage=$matches[2]\";s:34:\"organizer/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?tribe_organizer=$matches[1]&page=$matches[2]\";s:26:\"organizer/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"organizer/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"organizer/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"organizer/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"organizer/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"organizer/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"esemeny/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"esemeny/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"esemeny/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"esemeny/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"esemeny/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"esemeny/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"esemeny/([^/]+)/embed/?$\";s:45:\"index.php?tribe_events=$matches[1]&embed=true\";s:28:\"esemeny/([^/]+)/trackback/?$\";s:39:\"index.php?tribe_events=$matches[1]&tb=1\";s:48:\"esemeny/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:43:\"esemeny/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?tribe_events=$matches[1]&feed=$matches[2]\";s:36:\"esemeny/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&paged=$matches[2]\";s:43:\"esemeny/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?tribe_events=$matches[1]&cpage=$matches[2]\";s:32:\"esemeny/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?tribe_events=$matches[1]&page=$matches[2]\";s:24:\"esemeny/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"esemeny/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"esemeny/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"esemeny/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"esemeny/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"esemeny/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"esemenyek/category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:52:\"esemenyek/category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?tribe_events_cat=$matches[1]&feed=$matches[2]\";s:33:\"esemenyek/category/(.+?)/embed/?$\";s:49:\"index.php?tribe_events_cat=$matches[1]&embed=true\";s:45:\"esemenyek/category/(.+?)/page/?([0-9]{1,})/?$\";s:56:\"index.php?tribe_events_cat=$matches[1]&paged=$matches[2]\";s:27:\"esemenyek/category/(.+?)/?$\";s:38:\"index.php?tribe_events_cat=$matches[1]\";s:41:\"deleted_event/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:51:\"deleted_event/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:71:\"deleted_event/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:66:\"deleted_event/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:47:\"deleted_event/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:30:\"deleted_event/([^/]+)/embed/?$\";s:46:\"index.php?deleted_event=$matches[1]&embed=true\";s:34:\"deleted_event/([^/]+)/trackback/?$\";s:40:\"index.php?deleted_event=$matches[1]&tb=1\";s:42:\"deleted_event/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&paged=$matches[2]\";s:49:\"deleted_event/([^/]+)/comment-page-([0-9]{1,})/?$\";s:53:\"index.php?deleted_event=$matches[1]&cpage=$matches[2]\";s:38:\"deleted_event/([^/]+)(?:/([0-9]+))?/?$\";s:52:\"index.php?deleted_event=$matches[1]&page=$matches[2]\";s:30:\"deleted_event/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:40:\"deleted_event/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:60:\"deleted_event/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:55:\"deleted_event/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:36:\"deleted_event/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:12:\"robots\\.txt$\";s:18:\"index.php?robots=1\";s:13:\"favicon\\.ico$\";s:19:\"index.php?favicon=1\";s:12:\"sitemap\\.xml\";s:24:\"index.php??sitemap=index\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=6&cpage=$matches[1]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "yes");
INSERT INTO `wp_options` VALUES("59553", "user_count", "25", "no");
INSERT INTO `wp_options` VALUES("76600", "action_scheduler_hybrid_store_demarkation", "682", "yes");
INSERT INTO `wp_options` VALUES("76601", "schema-ActionScheduler_StoreSchema", "7.0.1686783049", "yes");
INSERT INTO `wp_options` VALUES("76602", "schema-ActionScheduler_LoggerSchema", "3.0.1662506228", "yes");
INSERT INTO `wp_options` VALUES("76607", "tec_ct1_events_table_schema_version", "1.0.1", "yes");
INSERT INTO `wp_options` VALUES("76608", "tec_ct1_occurrences_table_schema_version", "1.0.2", "yes");
INSERT INTO `wp_options` VALUES("76609", "tec_ct1_migration_state", "a:3:{s:18:\"complete_timestamp\";N;s:5:\"phase\";s:22:\"migration-not-required\";s:19:\"preview_unsupported\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("76646", "action_scheduler_lock_async-request-runner", "67b859718457f7.49851455|1740134829", "yes");
INSERT INTO `wp_options` VALUES("118579", "tec_timed_tribe_supports_async_process", "a:3:{s:3:\"key\";s:28:\"tribe_supports_async_process\";s:5:\"value\";i:1;s:10:\"expiration\";i:1740548119;}", "on");
INSERT INTO `wp_options` VALUES("178365", "PUBLISHPRESS_CAPS_VERSION", "2.19.0", "on");
INSERT INTO `wp_options` VALUES("185804", "tec_freemius_accounts_archive", "s:2400:\"a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:3069;a:3:{s:4:\"slug\";s:19:\"the-events-calendar\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:11:\"plugin_data\";a:1:{s:19:\"the-events-calendar\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1629378117;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:5:\"2.4.3\";s:11:\"sdk_version\";s:5:\"2.4.4\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"6.0.13\";s:14:\"plugin_version\";s:8:\"6.0.13.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:8:\"ikosz.hu\";s:9:\"server_ip\";s:14:\"213.222.136.14\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1629378117;s:7:\"version\";s:5:\"5.8.2\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:1:{s:43:\"the-events-calendar/the-events-calendar.php\";s:19:\"the-events-calendar\";}s:7:\"plugins\";a:1:{s:19:\"the-events-calendar\";O:9:\"FS_Plugin\":23:{s:16:\"parent_plugin_id\";N;s:5:\"title\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:12:\"premium_slug\";s:27:\"the-events-calendar-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:43:\"the-events-calendar/the-events-calendar.php\";s:7:\"version\";s:8:\"6.0.13.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e32061abc28cfedf231f3e5c4e626\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3069\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"326034a18d56aa4c60c7895901637b07\";s:13:\"admin_notices\";a:1:{s:19:\"the-events-calendar\";a:1:{s:15:\"connect_account\";a:8:{s:7:\"message\";s:177:\"We made a few tweaks to the plugin, <b><a href=\"https://ikosz.hu/wp-admin/edit.php?post_type=tribe_events&page=tribe-common\">Opt in to make \"The Events Calendar\" better!</a></b>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:10:\"update-nag\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"connect_account\";s:10:\"manager_id\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:19:\"The Events Calendar\";s:10:\"wp_user_id\";N;}}}}\";", "yes");
INSERT INTO `wp_options` VALUES("185805", "tec_freemius_accounts_data_archive", "a:6:{s:21:\"id_slug_type_path_map\";a:1:{i:3069;a:3:{s:4:\"slug\";s:19:\"the-events-calendar\";s:4:\"type\";s:6:\"plugin\";s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:11:\"plugin_data\";a:1:{s:19:\"the-events-calendar\";a:16:{s:16:\"plugin_main_file\";O:8:\"stdClass\":1:{s:4:\"path\";s:43:\"the-events-calendar/the-events-calendar.php\";}s:20:\"is_network_activated\";b:0;s:17:\"install_timestamp\";i:1629378117;s:17:\"was_plugin_loaded\";b:1;s:21:\"is_plugin_new_install\";b:0;s:16:\"sdk_last_version\";s:5:\"2.4.3\";s:11:\"sdk_version\";s:5:\"2.4.4\";s:16:\"sdk_upgrade_mode\";b:1;s:18:\"sdk_downgrade_mode\";b:0;s:19:\"plugin_last_version\";s:6:\"6.0.13\";s:14:\"plugin_version\";s:8:\"6.0.13.1\";s:19:\"plugin_upgrade_mode\";b:1;s:21:\"plugin_downgrade_mode\";b:0;s:17:\"connectivity_test\";a:6:{s:12:\"is_connected\";b:1;s:4:\"host\";s:8:\"ikosz.hu\";s:9:\"server_ip\";s:14:\"213.222.136.14\";s:9:\"is_active\";b:1;s:9:\"timestamp\";i:1629378117;s:7:\"version\";s:5:\"5.8.2\";}s:15:\"prev_is_premium\";b:0;s:18:\"sticky_optin_added\";b:1;}}s:13:\"file_slug_map\";a:1:{s:43:\"the-events-calendar/the-events-calendar.php\";s:19:\"the-events-calendar\";}s:7:\"plugins\";a:1:{s:19:\"the-events-calendar\";a:24:{s:10:\"tec_fs_key\";s:9:\"FS_Plugin\";s:16:\"parent_plugin_id\";N;s:5:\"title\";s:19:\"The Events Calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:12:\"premium_slug\";s:27:\"the-events-calendar-premium\";s:4:\"type\";s:6:\"plugin\";s:20:\"affiliate_moderation\";b:0;s:19:\"is_wp_org_compliant\";b:1;s:22:\"premium_releases_count\";N;s:4:\"file\";s:43:\"the-events-calendar/the-events-calendar.php\";s:7:\"version\";s:8:\"6.0.13.1\";s:11:\"auto_update\";N;s:4:\"info\";N;s:10:\"is_premium\";b:0;s:14:\"premium_suffix\";s:9:\"(Premium)\";s:7:\"is_live\";b:1;s:9:\"bundle_id\";N;s:17:\"bundle_public_key\";N;s:10:\"public_key\";s:32:\"pk_e32061abc28cfedf231f3e5c4e626\";s:10:\"secret_key\";N;s:2:\"id\";s:4:\"3069\";s:7:\"updated\";N;s:7:\"created\";N;s:22:\"\0FS_Entity\0_is_updated\";b:1;}}s:9:\"unique_id\";s:32:\"326034a18d56aa4c60c7895901637b07\";s:13:\"admin_notices\";a:1:{s:19:\"the-events-calendar\";a:1:{s:15:\"connect_account\";a:8:{s:7:\"message\";s:177:\"We made a few tweaks to the plugin, <b><a href=\"https://ikosz.hu/wp-admin/edit.php?post_type=tribe_events&page=tribe-common\">Opt in to make \"The Events Calendar\" better!</a></b>\";s:5:\"title\";s:0:\"\";s:4:\"type\";s:10:\"update-nag\";s:6:\"sticky\";b:1;s:2:\"id\";s:15:\"connect_account\";s:10:\"manager_id\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:19:\"The Events Calendar\";s:10:\"wp_user_id\";N;}}}}", "yes");
INSERT INTO `wp_options` VALUES("185806", "stellarwp_telemetry", "a:1:{s:7:\"plugins\";a:1:{s:19:\"the-events-calendar\";a:2:{s:7:\"wp_slug\";s:43:\"the-events-calendar/the-events-calendar.php\";s:5:\"optin\";b:0;}}}", "yes");
INSERT INTO `wp_options` VALUES("185807", "stellarwp_telemetry_the-events-calendar_show_optin", "0", "yes");
INSERT INTO `wp_options` VALUES("185808", "tec_freemius_plugins_archive", "O:8:\"stdClass\":3:{s:7:\"plugins\";a:1:{s:42:\"the-events-calendar/common/vendor/freemius\";O:8:\"stdClass\":4:{s:7:\"version\";s:5:\"2.4.4\";s:4:\"type\";s:6:\"plugin\";s:9:\"timestamp\";i:1658455514;s:11:\"plugin_path\";s:43:\"the-events-calendar/the-events-calendar.php\";}}s:7:\"abspath\";s:24:\"/home/ikosz/public_html/\";s:6:\"newest\";O:8:\"stdClass\":5:{s:11:\"plugin_path\";s:43:\"the-events-calendar/the-events-calendar.php\";s:8:\"sdk_path\";s:42:\"the-events-calendar/common/vendor/freemius\";s:7:\"version\";s:5:\"2.4.4\";s:13:\"in_activation\";b:0;s:9:\"timestamp\";i:1658455514;}}", "yes");
INSERT INTO `wp_options` VALUES("185811", "tec_timed_tec_custom_tables_v1_initialized", "a:3:{s:3:\"key\";s:32:\"tec_custom_tables_v1_initialized\";s:5:\"value\";i:1;s:10:\"expiration\";i:1740205812;}", "on");
INSERT INTO `wp_options` VALUES("185812", "stellarwp_telemetry_last_send", "", "yes");
INSERT INTO `wp_options` VALUES("203176", "wp_attachment_pages_enabled", "1", "yes");
INSERT INTO `wp_options` VALUES("203183", "customize_presets_settings", "minimalist", "yes");
INSERT INTO `wp_options` VALUES("203198", "loginpress_autologin", "", "yes");
INSERT INTO `wp_options` VALUES("203199", "loginpress_hidelogin", "", "yes");
INSERT INTO `wp_options` VALUES("203200", "loginpress_limit_login_attempts", "", "yes");
INSERT INTO `wp_options` VALUES("203201", "loginpress_login_redirects", "", "yes");
INSERT INTO `wp_options` VALUES("203202", "loginpress_social_logins", "", "yes");
INSERT INTO `wp_options` VALUES("213758", "filemanager_email_verified_1", "yes", "yes");
INSERT INTO `wp_options` VALUES("254290", "duplicator_version_plugin", "1.5.8.1", "yes");
INSERT INTO `wp_options` VALUES("254292", "duplicator_install_info", "a:3:{s:7:\"version\";s:7:\"1.5.8.1\";s:4:\"time\";i:1709631568;s:10:\"updateTime\";i:1709631568;}", "no");
INSERT INTO `wp_options` VALUES("254293", "duplicator_uninstall_package", "1", "yes");
INSERT INTO `wp_options` VALUES("254294", "duplicator_uninstall_settings", "1", "yes");
INSERT INTO `wp_options` VALUES("254295", "duplicator_settings", "a:20:{s:7:\"version\";s:7:\"1.5.8.1\";s:18:\"uninstall_settings\";b:1;s:15:\"uninstall_files\";b:1;s:13:\"package_debug\";b:0;s:23:\"email_summary_frequency\";s:6:\"weekly\";s:9:\"amNotices\";b:1;s:17:\"package_mysqldump\";b:1;s:22:\"package_mysqldump_path\";s:0:\"\";s:24:\"package_phpdump_qrylimit\";s:3:\"100\";s:17:\"package_zip_flush\";b:0;s:19:\"installer_name_mode\";s:6:\"simple\";s:16:\"storage_position\";s:6:\"wpcont\";s:20:\"storage_htaccess_off\";b:0;s:18:\"archive_build_mode\";i:2;s:17:\"skip_archive_scan\";b:0;s:21:\"unhook_third_party_js\";b:0;s:22:\"unhook_third_party_css\";b:0;s:17:\"active_package_id\";i:2;s:14:\"usage_tracking\";b:0;i:0;b:0;}", "yes");
INSERT INTO `wp_options` VALUES("254297", "duplicator_notifications", "a:4:{s:6:\"update\";i:1740109777;s:4:\"feed\";a:0:{}s:6:\"events\";a:0:{}s:9:\"dismissed\";a:0:{}}", "yes");
INSERT INTO `wp_options` VALUES("254299", "duplicator_package_active", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-21 10:46:40\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.41\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20240305_ikosz\";s:4:\"Hash\";s:35:\"2452a9ac53ba5d3d8349_20250221104640\";s:8:\"NameHash\";s:50:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:60:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";N;s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:23:\"/home/ikosz/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2376;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:13795;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-02-21 10:46:40\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.7.2\";s:9:\"VersionDB\";s:6:\"8.0.41\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:14:\"20240305_ikosz\";s:4:\"Hash\";s:35:\"2452a9ac53ba5d3d8349_20250221104640\";s:8:\"NameHash\";s:50:\"20240305_ikosz_2452a9ac53ba5d3d8349_20250221104640\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";N;s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:37:\"/home/ikosz/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";N;s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:28:\"MySQL Community Server - GPL\";s:19:\"sameNameTableExists\";N;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:65;s:24:\"\0DUP_Database\0tempDbPath\";N;s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:32:\"/home/ikosz/public_html/wp-admin\";i:1;s:35:\"/home/ikosz/public_html/wp-includes\";i:2;s:44:\"/home/ikosz/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:23:\"/home/ikosz/public_html\";i:1;s:23:\"/home/ikosz/public_html\";i:2;s:34:\"/home/ikosz/public_html/wp-content\";i:3;s:42:\"/home/ikosz/public_html/wp-content/uploads\";i:4;s:42:\"/home/ikosz/public_html/wp-content/plugins\";i:5;s:45:\"/home/ikosz/public_html/wp-content/mu-plugins\";i:6;s:41:\"/home/ikosz/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:55:\"/home/ikosz/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}", "yes");
INSERT INTO `wp_options` VALUES("254300", "duplicator_pro_exe_safe_mode", "0", "yes");
INSERT INTO `wp_options` VALUES("254301", "duplicator_activate_plugins_after_installation", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("254303", "duplicator_migration_data", "{\n    \"plugin\": \"dup-lite\",\n    \"installerVersion\": \"1.5.8.1\",\n    \"installType\": -1,\n    \"logicModes\": [\n        \"CLASSIC\"\n    ],\n    \"template\": \"base\",\n    \"restoreBackupMode\": false,\n    \"recoveryMode\": false,\n    \"archivePath\": \"\\/home\\/ikosz\\/public_html\\/20240305_ikosz_77501bd281c8e78c7796_20240305093958_archive.zip\",\n    \"packageHash\": \"77501bd-05093958\",\n    \"installerPath\": \"\\/home\\/ikosz\\/public_html\\/20240305_ikosz_77501bd281c8e78c7796_20240305093958_installer.php\",\n    \"installerBootLog\": \"\\/home\\/ikosz\\/public_html\\/dup-installer-bootlog__9c5a889-05093958.txt\",\n    \"installerLog\": \"\\/home\\/ikosz\\/public_html\\/dup-installer\\/dup-installer-log__9c5a889-05093958.txt\",\n    \"dupInstallerPath\": \"\\/home\\/ikosz\\/public_html\\/dup-installer\",\n    \"origFileFolderPath\": \"\\/home\\/ikosz\\/public_html\\/dup-installer\\/original_files_77501bd-05093958\",\n    \"safeMode\": 0,\n    \"cleanInstallerFiles\": true,\n    \"licenseType\": 0,\n    \"phpVersion\": \"7.4.33\",\n    \"archiveType\": \"zip\",\n    \"siteSize\": 135498052,\n    \"siteNumFiles\": 14309,\n    \"siteDbSize\": 17891328,\n    \"siteDBNumTables\": 50,\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"ustatIdentifier\": \"\",\n    \"time\": 1709654600\n}", "no");
INSERT INTO `wp_options` VALUES("254317", "duplicator_plugin_data_stats", "{\n    \"lastSendTime\": 0,\n    \"identifier\": \"j4AAUklik50VK-0bo99W1Y_Q&KZF8Ai8XuBvhDtFed_v\",\n    \"plugin\": \"dup-lite\",\n    \"pluginStatus\": \"active\",\n    \"buildCount\": 0,\n    \"buildLastDate\": 0,\n    \"buildFailedCount\": 0,\n    \"buildFailedLastDate\": 0,\n    \"siteSizeMB\": 309.259999999999990905052982270717620849609375,\n    \"siteNumFiles\": 16171,\n    \"siteDbSizeMB\": 19.280000000000001136868377216160297393798828125,\n    \"siteDbNumTables\": 51\n}", "yes");
INSERT INTO `wp_options` VALUES("254321", "action_scheduler_migration_status", "complete", "yes");
INSERT INTO `wp_options` VALUES("254324", "_transient_health-check-site-status-result", "{\"good\":16,\"recommended\":5,\"critical\":2}", "yes");
INSERT INTO `wp_options` VALUES("254392", "bsr_data", "a:8:{s:13:\"select_tables\";a:50:{i:0;s:26:\"wp_actionscheduler_actions\";i:1;s:25:\"wp_actionscheduler_claims\";i:2;s:25:\"wp_actionscheduler_groups\";i:3;s:23:\"wp_actionscheduler_logs\";i:4;s:14:\"wp_commentmeta\";i:5;s:11:\"wp_comments\";i:6;s:22:\"wp_duplicator_packages\";i:7;s:8:\"wp_links\";i:8;s:10:\"wp_options\";i:9;s:11:\"wp_postmeta\";i:10;s:8:\"wp_posts\";i:11;s:13:\"wp_tec_events\";i:12;s:18:\"wp_tec_occurrences\";i:13;s:21:\"wp_term_relationships\";i:14;s:16:\"wp_term_taxonomy\";i:15;s:11:\"wp_termmeta\";i:16;s:8:\"wp_terms\";i:17;s:11:\"wp_usermeta\";i:18;s:8:\"wp_users\";i:19;s:17:\"wp_wfblockediplog\";i:20;s:12:\"wp_wfblocks7\";i:21;s:11:\"wp_wfconfig\";i:22;s:13:\"wp_wfcrawlers\";i:23;s:16:\"wp_wffilechanges\";i:24;s:13:\"wp_wffilemods\";i:25;s:9:\"wp_wfhits\";i:26;s:11:\"wp_wfhoover\";i:27;s:11:\"wp_wfissues\";i:28;s:18:\"wp_wfknownfilelist\";i:29;s:21:\"wp_wflivetraffichuman\";i:30;s:9:\"wp_wflocs\";i:31;s:11:\"wp_wflogins\";i:32;s:19:\"wp_wfls_2fa_secrets\";i:33;s:19:\"wp_wfls_role_counts\";i:34;s:16:\"wp_wfls_settings\";i:35;s:18:\"wp_wfnotifications\";i:36;s:18:\"wp_wfpendingissues\";i:37;s:17:\"wp_wfreversecache\";i:38;s:19:\"wp_wfsecurityevents\";i:39;s:14:\"wp_wfsnipcache\";i:40;s:11:\"wp_wfstatus\";i:41;s:17:\"wp_wftrafficrates\";i:42;s:16:\"wp_wfwaffailures\";i:43;s:14:\"wp_wpfm_backup\";i:44;s:22:\"wp_wpfront_ure_options\";i:45;s:18:\"wp_yoast_indexable\";i:46;s:28:\"wp_yoast_indexable_hierarchy\";i:47;s:19:\"wp_yoast_migrations\";i:48;s:21:\"wp_yoast_primary_term\";i:49;s:18:\"wp_yoast_seo_links\";}s:16:\"case_insensitive\";s:3:\"off\";s:13:\"replace_guids\";s:3:\"off\";s:7:\"dry_run\";s:3:\"off\";s:10:\"search_for\";s:5:\"http:\";s:12:\"replace_with\";s:6:\"https:\";s:15:\"completed_pages\";i:50;s:11:\"total_pages\";i:50;}", "yes");
INSERT INTO `wp_options` VALUES("258087", "duplicator_email_summary_info", "{\"CL_-=_-=\":\"Duplicator\\\\Utils\\\\Email\\\\EmailSummary\",\"manualPackageIds\":[],\"failedPackageIds\":[]}", "yes");
INSERT INTO `wp_options` VALUES("294403", "acf_site_health", "{\"version\":\"6.3.12\",\"plugin_type\":\"Free\",\"update_source\":\"wordpress.org\",\"wp_version\":\"6.7.2\",\"mysql_version\":\"8.0.41\",\"is_multisite\":false,\"active_theme\":{\"name\":\"ikosz\",\"version\":\"1.0.0\",\"theme_uri\":\"http:\\/\\/underscores.me\\/\",\"stylesheet\":false},\"active_plugins\":{\"advanced-custom-fields\\/acf.php\":{\"name\":\"Advanced Custom Fields\",\"version\":\"6.3.12\",\"plugin_uri\":\"https:\\/\\/www.advancedcustomfields.com\"},\"ajax-search-lite\\/ajax-search-lite.php\":{\"name\":\"Ajax Search Lite\",\"version\":\"4.12.6\",\"plugin_uri\":\"http:\\/\\/wp-dreams.com\"},\"better-search-replace\\/better-search-replace.php\":{\"name\":\"Better Search Replace\",\"version\":\"1.4.5\",\"plugin_uri\":\"https:\\/\\/bettersearchreplace.com\"},\"classic-editor\\/classic-editor.php\":{\"name\":\"Classic Editor\",\"version\":\"1.6.7\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/classic-editor\\/\"},\"classic-widgets\\/classic-widgets.php\":{\"name\":\"Classic Widgets\",\"version\":\"0.3\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/classic-widgets\\/\"},\"custom-post-type-ui\\/custom-post-type-ui.php\":{\"name\":\"Custom Post Type UI\",\"version\":\"1.17.2\",\"plugin_uri\":\"https:\\/\\/github.com\\/WebDevStudios\\/custom-post-type-ui\\/\"},\"duplicator\\/duplicator.php\":{\"name\":\"Duplicator\",\"version\":\"1.5.8.1\",\"plugin_uri\":\"https:\\/\\/duplicator.com\\/\"},\"intuitive-custom-post-order\\/intuitive-custom-post-order.php\":{\"name\":\"Intuitive Custom Post Order\",\"version\":\"3.1.5.1\",\"plugin_uri\":\"http:\\/\\/hijiriworld.com\\/web\\/plugins\\/intuitive-custom-post-order\\/\"},\"loginpress\\/loginpress.php\":{\"name\":\"LoginPress\",\"version\":\"3.3.1\",\"plugin_uri\":\"https:\\/\\/loginpress.pro?utm_source=loginpress-lite&utm_medium=plugin-header&utm_campaign=pro-upgrade&utm_content=plugin-uri\"},\"capability-manager-enhanced\\/capsman-enhanced.php\":{\"name\":\"PublishPress Capabilities\",\"version\":\"2.19.0\",\"plugin_uri\":\"https:\\/\\/publishpress.com\\/capability-manager\\/\"},\"qtranslate-xt-master\\/qtranslate.php\":{\"name\":\"qTranslate-XT\",\"version\":\"3.10.0\",\"plugin_uri\":\"https:\\/\\/github.com\\/qtranslate\\/qtranslate-xt\\/\"},\"search-filter\\/search-filter.php\":{\"name\":\"Search & Filter\",\"version\":\"1.2.17\",\"plugin_uri\":\"https:\\/\\/free.searchandfilter.com\\/\"},\"the-events-calendar\\/the-events-calendar.php\":{\"name\":\"The Events Calendar\",\"version\":\"6.10.1.1\",\"plugin_uri\":\"\"},\"wordfence\\/wordfence.php\":{\"name\":\"Wordfence Security\",\"version\":\"8.0.3\",\"plugin_uri\":\"https:\\/\\/www.wordfence.com\\/\"},\"wp-file-manager\\/file_folder_manager.php\":{\"name\":\"WP File Manager\",\"version\":\"7.1.6\",\"plugin_uri\":\"https:\\/\\/wordpress.org\\/plugins\\/wp-file-manager\"},\"wordpress-seo\\/wp-seo.php\":{\"name\":\"Yoast SEO\",\"version\":\"24.5\",\"plugin_uri\":\"https:\\/\\/yoa.st\\/1uj\"}},\"ui_field_groups\":\"5\",\"php_field_groups\":\"0\",\"json_field_groups\":\"0\",\"rest_field_groups\":\"0\",\"number_of_fields_by_type\":{\"image\":4,\"color_picker\":2,\"true_false\":2,\"textarea\":1,\"group\":2},\"number_of_third_party_fields_by_type\":[],\"post_types_enabled\":true,\"ui_post_types\":\"12\",\"json_post_types\":\"0\",\"ui_taxonomies\":\"5\",\"json_taxonomies\":\"0\",\"rest_api_format\":\"light\",\"admin_ui_enabled\":true,\"field_type-modal_enabled\":true,\"field_settings_tabs_enabled\":false,\"shortcode_enabled\":true,\"registered_acf_forms\":\"0\",\"json_save_paths\":1,\"json_load_paths\":1,\"last_updated\":1740003860}", "off");
INSERT INTO `wp_options` VALUES("353405", "wpb_sdk_module_id", "6", "auto");
INSERT INTO `wp_options` VALUES("353406", "wpb_sdk_module_slug", "loginpress", "auto");
INSERT INTO `wp_options` VALUES("381453", "rdn_fetch_12516765", "fetch", "auto");
INSERT INTO `wp_options` VALUES("433442", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"8c7d46a72d7d4591fc1dd9485bedb304\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("483168", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:7:\"upgrade\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/hu_HU/wordpress-6.7.2.zip\";s:6:\"locale\";s:5:\"hu_HU\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/hu_HU/wordpress-6.7.2.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.7.2\";s:7:\"version\";s:5:\"6.7.2\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1740103592;s:15:\"version_checked\";s:5:\"6.7.2\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("484247", "cme_admin_notice_options", "a:5:{s:13:\"administrator\";a:3:{s:21:\"enable_toolbar_access\";b:1;s:18:\"notice_type_remove\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}s:19:\"notice_type_display\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}}s:6:\"editor\";a:3:{s:21:\"enable_toolbar_access\";b:1;s:18:\"notice_type_remove\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}s:19:\"notice_type_display\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}}s:6:\"author\";a:3:{s:21:\"enable_toolbar_access\";b:1;s:18:\"notice_type_remove\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}s:19:\"notice_type_display\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}}s:11:\"contributor\";a:3:{s:21:\"enable_toolbar_access\";b:1;s:18:\"notice_type_remove\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}s:19:\"notice_type_display\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}}s:10:\"subscriber\";a:3:{s:21:\"enable_toolbar_access\";b:1;s:18:\"notice_type_remove\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}s:19:\"notice_type_display\";a:4:{i:0;s:7:\"success\";i:1;s:5:\"error\";i:2;s:7:\"warning\";i:3;s:4:\"info\";}}}", "auto");
INSERT INTO `wp_options` VALUES("485881", "_site_transient_update_themes", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1740132262;s:7:\"checked\";a:5:{s:5:\"ikosz\";s:5:\"1.0.0\";s:16:\"twentytwentyfive\";s:3:\"1.0\";s:16:\"twentytwentyfour\";s:3:\"1.0\";s:17:\"twentytwentythree\";s:3:\"1.0\";s:15:\"twentytwentytwo\";s:3:\"1.0\";}s:8:\"response\";a:4:{s:16:\"twentytwentyfive\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfive\";s:11:\"new_version\";s:3:\"1.1\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfive/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfive.1.1.zip\";s:8:\"requires\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.2\";}s:16:\"twentytwentyfour\";a:6:{s:5:\"theme\";s:16:\"twentytwentyfour\";s:11:\"new_version\";s:3:\"1.3\";s:3:\"url\";s:46:\"https://wordpress.org/themes/twentytwentyfour/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/theme/twentytwentyfour.1.3.zip\";s:8:\"requires\";s:3:\"6.4\";s:12:\"requires_php\";s:3:\"7.0\";}s:17:\"twentytwentythree\";a:6:{s:5:\"theme\";s:17:\"twentytwentythree\";s:11:\"new_version\";s:3:\"1.6\";s:3:\"url\";s:47:\"https://wordpress.org/themes/twentytwentythree/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/theme/twentytwentythree.1.6.zip\";s:8:\"requires\";s:3:\"6.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:15:\"twentytwentytwo\";a:6:{s:5:\"theme\";s:15:\"twentytwentytwo\";s:11:\"new_version\";s:3:\"1.9\";s:3:\"url\";s:45:\"https://wordpress.org/themes/twentytwentytwo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/theme/twentytwentytwo.1.9.zip\";s:8:\"requires\";s:3:\"5.9\";s:12:\"requires_php\";s:3:\"5.6\";}}s:9:\"no_update\";a:0:{}s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("486222", "_site_transient_timeout_php_check_38979a08dcd71638878b7b4419751271", "1740477917", "off");
INSERT INTO `wp_options` VALUES("486223", "_site_transient_php_check_38979a08dcd71638878b7b4419751271", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("486745", "_site_transient_update_plugins", "O:8:\"stdClass\":4:{s:12:\"last_checked\";i:1740132262;s:8:\"response\";a:3:{s:47:\"better-search-replace/better-search-replace.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:35:\"w.org/plugins/better-search-replace\";s:4:\"slug\";s:21:\"better-search-replace\";s:6:\"plugin\";s:47:\"better-search-replace/better-search-replace.php\";s:11:\"new_version\";s:6:\"1.4.10\";s:3:\"url\";s:52:\"https://wordpress.org/plugins/better-search-replace/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/better-search-replace.1.4.10.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-256x256.png?rev=2706527\";s:2:\"1x\";s:74:\"https://ps.w.org/better-search-replace/assets/icon-128x128.png?rev=2706527\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:77:\"https://ps.w.org/better-search-replace/assets/banner-1544x500.png?rev=2706527\";s:2:\"1x\";s:76:\"https://ps.w.org/better-search-replace/assets/banner-772x250.jpg?rev=2706527\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.0.1\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";b:0;s:16:\"requires_plugins\";a:0:{}}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:8:\"1.5.11.2\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/duplicator.1.5.11.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:6:\"5.6.20\";s:16:\"requires_plugins\";a:0:{}}s:39:\"wp-file-manager/file_folder_manager.php\";O:8:\"stdClass\":13:{s:2:\"id\";s:29:\"w.org/plugins/wp-file-manager\";s:4:\"slug\";s:15:\"wp-file-manager\";s:6:\"plugin\";s:39:\"wp-file-manager/file_folder_manager.php\";s:11:\"new_version\";s:5:\"8.0.1\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/wp-file-manager/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wp-file-manager.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:68:\"https://ps.w.org/wp-file-manager/assets/icon-128x128.png?rev=2491299\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:70:\"https://ps.w.org/wp-file-manager/assets/banner-772x250.jpg?rev=2491299\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";s:6:\"tested\";s:5:\"6.7.2\";s:12:\"requires_php\";s:5:\"5.2.4\";s:16:\"requires_plugins\";a:0:{}}}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:17:{s:30:\"advanced-custom-fields/acf.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:36:\"w.org/plugins/advanced-custom-fields\";s:4:\"slug\";s:22:\"advanced-custom-fields\";s:6:\"plugin\";s:30:\"advanced-custom-fields/acf.php\";s:11:\"new_version\";s:6:\"6.3.12\";s:3:\"url\";s:53:\"https://wordpress.org/plugins/advanced-custom-fields/\";s:7:\"package\";s:72:\"https://downloads.wordpress.org/plugin/advanced-custom-fields.6.3.12.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";s:3:\"svg\";s:67:\"https://ps.w.org/advanced-custom-fields/assets/icon.svg?rev=3207824\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:78:\"https://ps.w.org/advanced-custom-fields/assets/banner-1544x500.jpg?rev=3207824\";s:2:\"1x\";s:77:\"https://ps.w.org/advanced-custom-fields/assets/banner-772x250.jpg?rev=3207824\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.0\";}s:37:\"ajax-search-lite/ajax-search-lite.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/ajax-search-lite\";s:4:\"slug\";s:16:\"ajax-search-lite\";s:6:\"plugin\";s:37:\"ajax-search-lite/ajax-search-lite.php\";s:11:\"new_version\";s:6:\"4.12.6\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/ajax-search-lite/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/ajax-search-lite.4.12.6.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/ajax-search-lite/assets/icon-256x256.png?rev=3192672\";s:2:\"1x\";s:69:\"https://ps.w.org/ajax-search-lite/assets/icon-128x128.png?rev=3192672\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/ajax-search-lite/assets/banner-1544x500.png?rev=3179552\";s:2:\"1x\";s:71:\"https://ps.w.org/ajax-search-lite/assets/banner-772x250.png?rev=3179552\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";}s:19:\"akismet/akismet.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:21:\"w.org/plugins/akismet\";s:4:\"slug\";s:7:\"akismet\";s:6:\"plugin\";s:19:\"akismet/akismet.php\";s:11:\"new_version\";s:5:\"5.3.7\";s:3:\"url\";s:38:\"https://wordpress.org/plugins/akismet/\";s:7:\"package\";s:56:\"https://downloads.wordpress.org/plugin/akismet.5.3.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:60:\"https://ps.w.org/akismet/assets/icon-256x256.png?rev=2818463\";s:2:\"1x\";s:60:\"https://ps.w.org/akismet/assets/icon-128x128.png?rev=2818463\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/akismet/assets/banner-1544x500.png?rev=2900731\";s:2:\"1x\";s:62:\"https://ps.w.org/akismet/assets/banner-772x250.png?rev=2900731\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.8\";}s:33:\"classic-editor/classic-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/classic-editor\";s:4:\"slug\";s:14:\"classic-editor\";s:6:\"plugin\";s:33:\"classic-editor/classic-editor.php\";s:11:\"new_version\";s:5:\"1.6.7\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/classic-editor/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/classic-editor.1.6.7.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-256x256.png?rev=1998671\";s:2:\"1x\";s:67:\"https://ps.w.org/classic-editor/assets/icon-128x128.png?rev=1998671\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/classic-editor/assets/banner-1544x500.png?rev=1998671\";s:2:\"1x\";s:69:\"https://ps.w.org/classic-editor/assets/banner-772x250.png?rev=1998676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:43:\"custom-post-type-ui/custom-post-type-ui.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:33:\"w.org/plugins/custom-post-type-ui\";s:4:\"slug\";s:19:\"custom-post-type-ui\";s:6:\"plugin\";s:43:\"custom-post-type-ui/custom-post-type-ui.php\";s:11:\"new_version\";s:6:\"1.17.2\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/custom-post-type-ui/\";s:7:\"package\";s:69:\"https://downloads.wordpress.org/plugin/custom-post-type-ui.1.17.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/custom-post-type-ui/assets/icon-256x256.png?rev=2744389\";s:2:\"1x\";s:72:\"https://ps.w.org/custom-post-type-ui/assets/icon-128x128.png?rev=2744389\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/custom-post-type-ui/assets/banner-1544x500.png?rev=2744389\";s:2:\"1x\";s:74:\"https://ps.w.org/custom-post-type-ui/assets/banner-772x250.png?rev=2744389\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:32:\"duplicate-page/duplicatepage.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/duplicate-page\";s:4:\"slug\";s:14:\"duplicate-page\";s:6:\"plugin\";s:32:\"duplicate-page/duplicatepage.php\";s:11:\"new_version\";s:5:\"4.5.4\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/duplicate-page/\";s:7:\"package\";s:57:\"https://downloads.wordpress.org/plugin/duplicate-page.zip\";s:5:\"icons\";a:1:{s:2:\"1x\";s:67:\"https://ps.w.org/duplicate-page/assets/icon-128x128.jpg?rev=1412874\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:69:\"https://ps.w.org/duplicate-page/assets/banner-772x250.jpg?rev=1410328\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.4\";}s:9:\"hello.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/hello-dolly\";s:4:\"slug\";s:11:\"hello-dolly\";s:6:\"plugin\";s:9:\"hello.php\";s:11:\"new_version\";s:5:\"1.7.2\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/hello-dolly/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/hello-dolly.1.7.3.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-256x256.jpg?rev=2052855\";s:2:\"1x\";s:64:\"https://ps.w.org/hello-dolly/assets/icon-128x128.jpg?rev=2052855\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/hello-dolly/assets/banner-1544x500.jpg?rev=2645582\";s:2:\"1x\";s:66:\"https://ps.w.org/hello-dolly/assets/banner-772x250.jpg?rev=2052855\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.6\";}s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/intuitive-custom-post-order\";s:4:\"slug\";s:27:\"intuitive-custom-post-order\";s:6:\"plugin\";s:59:\"intuitive-custom-post-order/intuitive-custom-post-order.php\";s:11:\"new_version\";s:7:\"3.1.5.1\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/intuitive-custom-post-order/\";s:7:\"package\";s:78:\"https://downloads.wordpress.org/plugin/intuitive-custom-post-order.3.1.5.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/intuitive-custom-post-order/assets/icon-256x256.png?rev=1078797\";s:2:\"1x\";s:80:\"https://ps.w.org/intuitive-custom-post-order/assets/icon-128x128.png?rev=1078797\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/intuitive-custom-post-order/assets/banner-1544x500.png?rev=1209666\";s:2:\"1x\";s:82:\"https://ps.w.org/intuitive-custom-post-order/assets/banner-772x250.png?rev=1078755\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"3.5.0\";}s:25:\"loginpress/loginpress.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/loginpress\";s:4:\"slug\";s:10:\"loginpress\";s:6:\"plugin\";s:25:\"loginpress/loginpress.php\";s:11:\"new_version\";s:5:\"3.3.1\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/loginpress/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/loginpress.3.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/loginpress/assets/icon-256x256.png?rev=3005027\";s:2:\"1x\";s:63:\"https://ps.w.org/loginpress/assets/icon-128x128.png?rev=3005027\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/loginpress/assets/banner-1544x500.png?rev=3005027\";s:2:\"1x\";s:65:\"https://ps.w.org/loginpress/assets/banner-772x250.png?rev=3005027\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.0\";}s:48:\"capability-manager-enhanced/capsman-enhanced.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:41:\"w.org/plugins/capability-manager-enhanced\";s:4:\"slug\";s:27:\"capability-manager-enhanced\";s:6:\"plugin\";s:48:\"capability-manager-enhanced/capsman-enhanced.php\";s:11:\"new_version\";s:6:\"2.19.0\";s:3:\"url\";s:58:\"https://wordpress.org/plugins/capability-manager-enhanced/\";s:7:\"package\";s:77:\"https://downloads.wordpress.org/plugin/capability-manager-enhanced.2.19.0.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:80:\"https://ps.w.org/capability-manager-enhanced/assets/icon-256x256.png?rev=2977153\";s:2:\"1x\";s:80:\"https://ps.w.org/capability-manager-enhanced/assets/icon-128x128.png?rev=2977153\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:83:\"https://ps.w.org/capability-manager-enhanced/assets/banner-1544x500.png?rev=3010239\";s:2:\"1x\";s:82:\"https://ps.w.org/capability-manager-enhanced/assets/banner-772x250.png?rev=3010239\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.5\";}s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:31:\"w.org/plugins/really-simple-ssl\";s:4:\"slug\";s:17:\"really-simple-ssl\";s:6:\"plugin\";s:47:\"really-simple-ssl/rlrsssl-really-simple-ssl.php\";s:11:\"new_version\";s:5:\"9.3.1\";s:3:\"url\";s:48:\"https://wordpress.org/plugins/really-simple-ssl/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/really-simple-ssl.9.3.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-256x256.png?rev=2839720\";s:2:\"1x\";s:70:\"https://ps.w.org/really-simple-ssl/assets/icon-128x128.png?rev=2839720\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/really-simple-ssl/assets/banner-1544x500.png?rev=3100992\";s:2:\"1x\";s:72:\"https://ps.w.org/really-simple-ssl/assets/banner-772x250.png?rev=3100992\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.9\";}s:31:\"search-filter/search-filter.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/search-filter\";s:4:\"slug\";s:13:\"search-filter\";s:6:\"plugin\";s:31:\"search-filter/search-filter.php\";s:11:\"new_version\";s:6:\"1.2.17\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/search-filter/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/search-filter.1.2.17.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/search-filter/assets/icon-256x256.png?rev=3096093\";s:2:\"1x\";s:66:\"https://ps.w.org/search-filter/assets/icon-128x128.png?rev=3096093\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/search-filter/assets/banner-1544x500.png?rev=3096074\";s:2:\"1x\";s:68:\"https://ps.w.org/search-filter/assets/banner-772x250.png?rev=3096074\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"3.5\";}s:43:\"the-events-calendar/the-events-calendar.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:33:\"w.org/plugins/the-events-calendar\";s:4:\"slug\";s:19:\"the-events-calendar\";s:6:\"plugin\";s:43:\"the-events-calendar/the-events-calendar.php\";s:11:\"new_version\";s:8:\"6.10.1.1\";s:3:\"url\";s:50:\"https://wordpress.org/plugins/the-events-calendar/\";s:7:\"package\";s:71:\"https://downloads.wordpress.org/plugin/the-events-calendar.6.10.1.1.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-256x256.gif?rev=2516440\";s:2:\"1x\";s:72:\"https://ps.w.org/the-events-calendar/assets/icon-128x128.gif?rev=2516440\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:75:\"https://ps.w.org/the-events-calendar/assets/banner-1544x500.png?rev=2257622\";s:2:\"1x\";s:74:\"https://ps.w.org/the-events-calendar/assets/banner-772x250.png?rev=2257622\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:37:\"user-role-editor/user-role-editor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:30:\"w.org/plugins/user-role-editor\";s:4:\"slug\";s:16:\"user-role-editor\";s:6:\"plugin\";s:37:\"user-role-editor/user-role-editor.php\";s:11:\"new_version\";s:6:\"4.64.4\";s:3:\"url\";s:47:\"https://wordpress.org/plugins/user-role-editor/\";s:7:\"package\";s:66:\"https://downloads.wordpress.org/plugin/user-role-editor.4.64.4.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-256x256.jpg?rev=1020390\";s:2:\"1x\";s:69:\"https://ps.w.org/user-role-editor/assets/icon-128x128.jpg?rev=1020390\";}s:7:\"banners\";a:1:{s:2:\"1x\";s:71:\"https://ps.w.org/user-role-editor/assets/banner-772x250.png?rev=1263116\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.4\";}s:23:\"wordfence/wordfence.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/wordfence\";s:4:\"slug\";s:9:\"wordfence\";s:6:\"plugin\";s:23:\"wordfence/wordfence.php\";s:11:\"new_version\";s:5:\"8.0.3\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/wordfence/\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/wordfence.8.0.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";s:3:\"svg\";s:54:\"https://ps.w.org/wordfence/assets/icon.svg?rev=2070865\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/wordfence/assets/banner-1544x500.jpg?rev=2124102\";s:2:\"1x\";s:64:\"https://ps.w.org/wordfence/assets/banner-772x250.jpg?rev=2124102\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.7\";}s:24:\"wordpress-seo/wp-seo.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:27:\"w.org/plugins/wordpress-seo\";s:4:\"slug\";s:13:\"wordpress-seo\";s:6:\"plugin\";s:24:\"wordpress-seo/wp-seo.php\";s:11:\"new_version\";s:4:\"24.5\";s:3:\"url\";s:44:\"https://wordpress.org/plugins/wordpress-seo/\";s:7:\"package\";s:61:\"https://downloads.wordpress.org/plugin/wordpress-seo.24.5.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-256x256.gif?rev=3112542\";s:2:\"1x\";s:66:\"https://ps.w.org/wordpress-seo/assets/icon-128x128.gif?rev=3112542\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500.png?rev=2643727\";s:2:\"1x\";s:68:\"https://ps.w.org/wordpress-seo/assets/banner-772x250.png?rev=2643727\";}s:11:\"banners_rtl\";a:2:{s:2:\"2x\";s:73:\"https://ps.w.org/wordpress-seo/assets/banner-1544x500-rtl.png?rev=2643727\";s:2:\"1x\";s:72:\"https://ps.w.org/wordpress-seo/assets/banner-772x250-rtl.png?rev=2643727\";}s:8:\"requires\";s:3:\"6.5\";}}}", "off");
INSERT INTO `wp_options` VALUES("488287", "_transient_timeout_tribe_views_v2_cache_fe060e760da0:1739930717.7646_0", "1740136852", "off");
INSERT INTO `wp_options` VALUES("488288", "_transient_tribe_views_v2_cache_fe060e760da0:1739930717.7646_0", "<div\n	 class=\"tribe-common tribe-events tribe-events-view tribe-events-view--month\" 	data-js=\"tribe-events-view\"\n	data-view-rest-nonce=\"\"\n	data-view-rest-url=\"https://ikosz.hu/en/wp-json/tribe/views/v2/html\"\n	data-view-rest-method=\"POST\"\n	data-view-manage-url=\"1\"\n				data-view-breakpoint-pointer=\"505bd33c-5483-4aba-a337-b73430233c73\"\n	>\n	<div class=\"tribe-common-l-container tribe-events-l-container\">\n		<div\n	class=\"tribe-events-view-loader tribe-common-a11y-hidden\"\n	role=\"alert\"\n	aria-live=\"polite\"\n>\n	<span class=\"tribe-events-view-loader__text tribe-common-a11y-visual-hide\">\n		42 events found.	</span>\n	<div class=\"tribe-events-view-loader__dots tribe-common-c-loader\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--first\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--second\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n	</div>\n</div>\n\n		\n		<script data-js=\"tribe-events-view-data\" type=\"application/json\">\n	{\"slug\":\"month\",\"prev_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-02\\/\",\"next_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-04\\/\",\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_slug\":\"month\",\"view_label\":\"Month\",\"title\":\"Events Arch\\u00edv\\u00e1lt - ikosz\",\"events\":{\"2025-02-24\":[],\"2025-02-25\":[],\"2025-02-26\":[],\"2025-02-27\":[],\"2025-02-28\":[],\"2025-03-01\":[],\"2025-03-02\":[],\"2025-03-03\":[],\"2025-03-04\":[],\"2025-03-05\":[],\"2025-03-06\":[],\"2025-03-07\":[],\"2025-03-08\":[],\"2025-03-09\":[],\"2025-03-10\":[],\"2025-03-11\":[],\"2025-03-12\":[],\"2025-03-13\":[],\"2025-03-14\":[],\"2025-03-15\":[],\"2025-03-16\":[],\"2025-03-17\":[],\"2025-03-18\":[],\"2025-03-19\":[],\"2025-03-20\":[],\"2025-03-21\":[],\"2025-03-22\":[],\"2025-03-23\":[],\"2025-03-24\":[],\"2025-03-25\":[],\"2025-03-26\":[],\"2025-03-27\":[],\"2025-03-28\":[],\"2025-03-29\":[],\"2025-03-30\":[],\"2025-03-31\":[],\"2025-04-01\":[],\"2025-04-02\":[],\"2025-04-03\":[],\"2025-04-04\":[],\"2025-04-05\":[],\"2025-04-06\":[]},\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-03\\/\",\"url_event_date\":\"2025-03-01\",\"bar\":{\"keyword\":\"\",\"date\":\"2025-03\"},\"today\":\"2025-02-20 00:00:00\",\"now\":\"2025-02-20 11:20:51\",\"rest_url\":\"https:\\/\\/ikosz.hu\\/en\\/wp-json\\/tribe\\/views\\/v2\\/html\",\"rest_method\":\"POST\",\"rest_nonce\":\"\",\"should_manage_url\":true,\"today_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/\",\"today_title\":\"Click to select the current month\",\"today_label\":\"This Month\",\"prev_label\":\"Feb\",\"next_label\":\"Apr\",\"date_formats\":{\"compact\":\"n\\/j\\/Y\",\"month_and_year_compact\":\"n\\/Y\",\"month_and_year\":\"F Y\",\"time_range_separator\":\" - \",\"date_time_separator\":\" @ \"},\"messages\":{\"notice\":[\"There are no upcoming events.\"]},\"start_of_week\":\"1\",\"header_title\":\"\",\"header_title_element\":\"h1\",\"content_title\":\"\",\"breadcrumbs\":[],\"before_events\":\"\",\"after_events\":\"\\n<!--\\nThis calendar is powered by The Events Calendar.\\nhttp:\\/\\/evnt.is\\/18wn\\n-->\\n\",\"display_events_bar\":true,\"disable_event_search\":true,\"live_refresh\":true,\"ical\":{\"display_link\":true,\"link\":{\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-03\\/?ical=1\",\"text\":\"Export Events\",\"title\":\"Use this to share calendar data with Google Calendar, Apple iCal and other compatible apps\"}},\"container_classes\":[\"tribe-common\",\"tribe-events\",\"tribe-events-view\",\"tribe-events-view--month\"],\"container_data\":[],\"is_past\":false,\"breakpoints\":{\"xsmall\":500,\"medium\":768,\"full\":960},\"breakpoint_pointer\":\"505bd33c-5483-4aba-a337-b73430233c73\",\"is_initial_load\":true,\"public_views\":{\"list\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\List_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/list\\/?tribe-bar-date=2025-03-01\",\"view_label\":\"List\"},\"month\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-03\\/\",\"view_label\":\"Month\"},\"day\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Day_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-01\\/\",\"view_label\":\"Day\"}},\"show_latest_past\":true,\"today_date\":\"2025-02-20\",\"grid_date\":\"2025-03-01\",\"formatted_grid_date\":\"March 2025\",\"formatted_grid_date_mobile\":\"3\\/1\\/2025\",\"days\":{\"2025-02-24\":{\"date\":\"2025-02-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-24\\/\"},\"2025-02-25\":{\"date\":\"2025-02-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-25\\/\"},\"2025-02-26\":{\"date\":\"2025-02-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-26\\/\"},\"2025-02-27\":{\"date\":\"2025-02-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-27\\/\"},\"2025-02-28\":{\"date\":\"2025-02-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-28\\/\"},\"2025-03-01\":{\"date\":\"2025-03-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-01\\/\"},\"2025-03-02\":{\"date\":\"2025-03-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-02\\/\"},\"2025-03-03\":{\"date\":\"2025-03-03\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-03\\/\"},\"2025-03-04\":{\"date\":\"2025-03-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-04\\/\"},\"2025-03-05\":{\"date\":\"2025-03-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-05\\/\"},\"2025-03-06\":{\"date\":\"2025-03-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-06\\/\"},\"2025-03-07\":{\"date\":\"2025-03-07\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"7\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-07\\/\"},\"2025-03-08\":{\"date\":\"2025-03-08\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"8\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-08\\/\"},\"2025-03-09\":{\"date\":\"2025-03-09\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"9\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-09\\/\"},\"2025-03-10\":{\"date\":\"2025-03-10\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"10\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-10\\/\"},\"2025-03-11\":{\"date\":\"2025-03-11\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"11\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-11\\/\"},\"2025-03-12\":{\"date\":\"2025-03-12\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"12\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-12\\/\"},\"2025-03-13\":{\"date\":\"2025-03-13\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"13\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-13\\/\"},\"2025-03-14\":{\"date\":\"2025-03-14\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"14\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-14\\/\"},\"2025-03-15\":{\"date\":\"2025-03-15\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"15\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-15\\/\"},\"2025-03-16\":{\"date\":\"2025-03-16\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"16\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-16\\/\"},\"2025-03-17\":{\"date\":\"2025-03-17\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"17\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-17\\/\"},\"2025-03-18\":{\"date\":\"2025-03-18\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"18\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-18\\/\"},\"2025-03-19\":{\"date\":\"2025-03-19\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"19\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-19\\/\"},\"2025-03-20\":{\"date\":\"2025-03-20\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"20\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-20\\/\"},\"2025-03-21\":{\"date\":\"2025-03-21\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"21\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-21\\/\"},\"2025-03-22\":{\"date\":\"2025-03-22\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"22\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-22\\/\"},\"2025-03-23\":{\"date\":\"2025-03-23\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"23\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-23\\/\"},\"2025-03-24\":{\"date\":\"2025-03-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-24\\/\"},\"2025-03-25\":{\"date\":\"2025-03-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-25\\/\"},\"2025-03-26\":{\"date\":\"2025-03-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-26\\/\"},\"2025-03-27\":{\"date\":\"2025-03-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-27\\/\"},\"2025-03-28\":{\"date\":\"2025-03-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-28\\/\"},\"2025-03-29\":{\"date\":\"2025-03-29\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"29\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-29\\/\"},\"2025-03-30\":{\"date\":\"2025-03-30\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"30\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-30\\/\"},\"2025-03-31\":{\"date\":\"2025-03-31\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"31\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-31\\/\"},\"2025-04-01\":{\"date\":\"2025-04-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-01\\/\"},\"2025-04-02\":{\"date\":\"2025-04-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-02\\/\"},\"2025-04-03\":{\"date\":\"2025-04-03\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-03\\/\"},\"2025-04-04\":{\"date\":\"2025-04-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-04\\/\"},\"2025-04-05\":{\"date\":\"2025-04-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-05\\/\"},\"2025-04-06\":{\"date\":\"2025-04-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"04\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-04-06\\/\"}},\"next_month\":\"4\",\"prev_month\":\"2\",\"next_rel\":\"noindex\",\"prev_rel\":\"noindex\",\"mobile_messages\":{\"notice\":{\"no-events-in-day\":\"There are no events on this day.\"}},\"grid_start_date\":\"2025-02-24\",\"subscribe_links\":{\"gcal\":{\"label\":\"Google Calendar\",\"single_label\":\"Add to Google Calendar\",\"visible\":true,\"block_slug\":\"hasGoogleCalendar\"},\"ical\":{\"label\":\"iCalendar\",\"single_label\":\"Add to iCalendar\",\"visible\":true,\"block_slug\":\"hasiCal\"},\"outlook-365\":{\"label\":\"Outlook 365\",\"single_label\":\"Outlook 365\",\"visible\":true,\"block_slug\":\"hasOutlook365\"},\"outlook-live\":{\"label\":\"Outlook Live\",\"single_label\":\"Outlook Live\",\"visible\":true,\"block_slug\":\"hasOutlookLive\"},\"ics\":{\"label\":\"Export .ics file\",\"single_label\":\"Export .ics file\",\"visible\":true,\"block_slug\":null},\"outlook-ics\":{\"label\":\"Export Outlook .ics file\",\"single_label\":\"Export Outlook .ics file\",\"visible\":true,\"block_slug\":null}},\"_context\":{\"slug\":\"month\"},\"text\":\"Loading...\",\"classes\":[\"tribe-common-c-loader__dot\",\"tribe-common-c-loader__dot--third\"]}</script>\n\n		\n		<header  class=\"tribe-events-header\" >\n			<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"0\" 					>\n					There are no upcoming events.					</li>\n							</ul>\n		</div>\n	</div>\n\n			\n			<div\n	 class=\"tribe-events-header__events-bar tribe-events-c-events-bar\" 	data-js=\"tribe-events-events-bar\"\n>\n\n	<h2 class=\"tribe-common-a11y-visual-hide\">\n		Views Navigation	</h2>\n\n	\n	<div class=\"tribe-events-c-events-bar__views\">\n	<h3 class=\"tribe-common-a11y-visual-hide\">\n		Event Views Navigation	</h3>\n	<div  class=\"tribe-events-c-view-selector\"  data-js=\"tribe-events-view-selector\">\n		<button\n			class=\"tribe-events-c-view-selector__button tribe-common-c-btn__clear\"\n			data-js=\"tribe-events-view-selector-button\"\n		>\n			<span class=\"tribe-events-c-view-selector__button-icon\">\n				<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__button-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>			</span>\n			<span class=\"tribe-events-c-view-selector__button-text tribe-common-a11y-visual-hide\">\n				Month			</span>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-view-selector__button-icon-caret-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</button>\n		<div\n	class=\"tribe-events-c-view-selector__content\"\n	id=\"tribe-events-view-selector-content\"\n	data-js=\"tribe-events-view-selector-list-container\"\n>\n	<ul class=\"tribe-events-c-view-selector__list\">\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--list\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/list/?tribe-bar-date=2025-03-01\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--list tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.451.432V17.6c0 .238.163.432.364.432H18.12c.2 0 .364-.194.364-.432V.432c0-.239-.163-.432-.364-.432H.815c-.2 0-.364.193-.364.432zm.993.81h16.024V3.56H1.444V1.24zM17.468 3.56H1.444v13.227h16.024V3.56z\" class=\"tribe-common-c-svgicon__svg-fill\"/><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-0)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 4.912v1.825c0 .504.409.913.913.913h1.825a.913.913 0 00.912-.913V4.912A.913.913 0 0014.57 4h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 7.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 5.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-1)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 10.912v1.825c0 .505.409.913.913.913h1.825a.913.913 0 00.912-.912v-1.825A.913.913 0 0014.57 10h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 13.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 11.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><defs><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-0\"><path transform=\"translate(3.451 4)\" d=\"M0 0h13v4H0z\"/></clipPath><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-1\"><path transform=\"translate(3.451 10)\" d=\"M0 0h13v4H0z\"/></clipPath></defs></svg>\n		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			List		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--month tribe-events-c-view-selector__list-item--active\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-03/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Month		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--day\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/2025-03-01/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--day tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 18\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.363 17.569V.43C.363.193.526 0 .726 0H18c.201 0 .364.193.364.431V17.57c0 .238-.163.431-.364.431H.726c-.2 0-.363-.193-.363-.431zm16.985-16.33H1.354v2.314h15.994V1.24zM1.354 4.688h15.994v12.07H1.354V4.687zm11.164 9.265v-1.498c0-.413.335-.748.748-.748h1.498c.413 0 .748.335.748.748v1.498a.749.749 0 01-.748.748h-1.498a.749.749 0 01-.748-.748z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Day		</span>\n	</a>\n</li>\n			</ul>\n</div>\n	</div>\n</div>\n\n</div>\n\n			<div class=\"tribe-events-c-top-bar tribe-events-header__top-bar\">\n\n	<nav class=\"tribe-events-c-top-bar__nav tribe-common-a11y-hidden\">\n	<ul class=\"tribe-events-c-top-bar__nav-list\">\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-02/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-left tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--prev\"\n		aria-label=\"Previous month\"\n		title=\"Previous month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</a>\n</li>\n\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-04/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-right tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--next\"\n		aria-label=\"Next month\"\n		title=\"Next month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n	<a\n	href=\"https://ikosz.hu/en/esemenyek/month/\"\n	class=\"tribe-common-c-btn-border-small tribe-events-c-top-bar__today-button tribe-common-a11y-hidden\"\n	data-js=\"tribe-events-view-link\"\n	aria-label=\"Click to select the current month\"\n	title=\"Click to select the current month\"\n>\n	This Month</a>\n\n	<div class=\"tribe-events-c-top-bar__datepicker\">\n	<button\n		class=\"tribe-common-c-btn__clear tribe-common-h3 tribe-common-h--alt tribe-events-c-top-bar__datepicker-button\"\n		data-js=\"tribe-events-top-bar-datepicker-button\"\n		type=\"button\"\n		aria-label=\"Click to toggle datepicker\"\n		title=\"Click to toggle datepicker\"\n	>\n		<time\n			datetime=\"2025-03\"\n			class=\"tribe-events-c-top-bar__datepicker-time\"\n		>\n			<span class=\"tribe-events-c-top-bar__datepicker-mobile\">\n				3/1/2025			</span>\n			<span class=\"tribe-events-c-top-bar__datepicker-desktop tribe-common-a11y-hidden\">\n				March 2025			</span>\n		</time>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-top-bar__datepicker-button-icon-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n	</button>\n	<label\n		class=\"tribe-events-c-top-bar__datepicker-label tribe-common-a11y-visual-hide\"\n		for=\"tribe-events-top-bar-date\"\n	>\n		Select date.	</label>\n	<input\n		type=\"text\"\n		class=\"tribe-events-c-top-bar__datepicker-input tribe-common-a11y-visual-hide\"\n		data-js=\"tribe-events-top-bar-date\"\n		id=\"tribe-events-top-bar-date\"\n		name=\"tribe-events-views[tribe-bar-date]\"\n		value=\"3/1/2025\"\n		tabindex=\"-1\"\n		autocomplete=\"off\"\n		readonly=\"readonly\"\n	/>\n	<div class=\"tribe-events-c-top-bar__datepicker-container\" data-js=\"tribe-events-top-bar-datepicker-container\"></div>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-prev-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</template>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-next-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</template>\n</div>\n\n	<div class=\"tribe-events-c-top-bar__actions tribe-common-a11y-hidden\">\n	</div>\n\n</div>\n		</header>\n\n		\n		<div\n			class=\"tribe-events-calendar-month\"\n			role=\"grid\"\n			aria-labelledby=\"tribe-events-calendar-header\"\n			aria-readonly=\"true\"\n			data-js=\"tribe-events-month-grid\"\n		>\n\n			<header class=\"tribe-events-calendar-month__header\" role=\"rowgroup\">\n\n	<h2 class=\"tribe-common-a11y-visual-hide\" id=\"tribe-events-calendar-header\">\n		Calendar of Events	</h2>\n\n	<div role=\"row\" class=\"tribe-events-calendar-month__header-row\">\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Monday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						M					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Mon					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Tuesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Tue					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Wednesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						W					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Wed					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Thursday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Thu					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Friday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						F					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Fri					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Saturday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sat					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Sunday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sun					</span>\n				</h3>\n			</div>\n			</div>\n</header>\n\n			\n<div class=\"tribe-events-calendar-month__body\" role=\"rowgroup\">\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-07\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-7\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-07\"\n		>\n			7		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-07\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-07\"\n	>\n					7			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-08\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-8\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-08\"\n		>\n			8		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-08\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-08\"\n	>\n					8			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-09\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-9\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-09\"\n		>\n			9		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-09\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-09\"\n	>\n					9			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-10\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-10\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-10\"\n		>\n			10		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-10\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-10\"\n	>\n					10			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-11\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-11\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-11\"\n		>\n			11		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-11\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-11\"\n	>\n					11			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-12\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-12\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-12\"\n		>\n			12		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-12\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-12\"\n	>\n					12			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-13\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-13\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-13\"\n		>\n			13		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-13\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-13\"\n	>\n					13			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-14\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-14\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-14\"\n		>\n			14		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-14\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-14\"\n	>\n					14			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-15\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-15\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-15\"\n		>\n			15		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-15\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-15\"\n	>\n					15			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-16\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-16\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-16\"\n		>\n			16		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-16\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-16\"\n	>\n					16			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-17\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-17\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-17\"\n		>\n			17		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-17\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-17\"\n	>\n					17			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-18\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-18\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-18\"\n		>\n			18		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-18\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-18\"\n	>\n					18			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-19\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-19\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-19\"\n		>\n			19		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-19\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-19\"\n	>\n					19			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-20\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-20\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-20\"\n		>\n			20		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-20\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-20\"\n	>\n					20			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-21\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-21\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-21\"\n		>\n			21		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-21\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-21\"\n	>\n					21			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-22\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-22\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-22\"\n		>\n			22		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-22\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-22\"\n	>\n					22			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-23\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-23\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-23\"\n		>\n			23		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-23\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-23\"\n	>\n					23			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-29\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-29\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-29\"\n		>\n			29		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-29\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-29\"\n	>\n					29			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-30\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-30\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-30\"\n		>\n			30		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-30\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-30\"\n	>\n					30			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-31\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-31\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-31\"\n		>\n			31		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-31\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-31\"\n	>\n					31			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-04-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-04-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-04-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-04-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-04-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n</div>\n\n		</div>\n\n		<section class=\"tribe-events-calendar-month-mobile-events\" data-js=\"tribe-events-calendar-month-mobile-events\">\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-24\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-25\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-26\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-7\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-8\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-9\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-10\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-11\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-12\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-13\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-14\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-15\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-16\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-17\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-18\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-19\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-20\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-21\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-22\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-23\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-24\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-25\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-26\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-29\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-30\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-31\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-04-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n	<nav class=\"tribe-events-calendar-month-nav tribe-events-c-nav\">\n	<ul class=\"tribe-events-c-nav__list\">\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--prev\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-02/\"\n		rel=\"prev\"\n		class=\"tribe-events-c-nav__prev tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Previous month, Feb\"\n		title=\"Previous month, Feb\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-nav__prev-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n		Feb	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--today\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/\"\n		class=\"tribe-events-c-nav__today tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Click to select the current month\"\n		title=\"Click to select the current month\"\n	>\n		This Month	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--next\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-04/\"\n		rel=\"next\"\n		class=\"tribe-events-c-nav__next tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Next month, Apr\"\n		title=\"Next month, Apr\"\n		rel=\"noindex\"\n	>\n		Apr		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-nav__next-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n</section>\n\n		<div class=\"tribe-events-c-subscribe-dropdown__container\">\n	<div class=\"tribe-events-c-subscribe-dropdown\">\n		<div class=\"tribe-common-c-btn-border tribe-events-c-subscribe-dropdown__button\">\n			<button\n				class=\"tribe-events-c-subscribe-dropdown__button-text tribe-common-c-btn--clear\"\n				aria-expanded=\"false\"\n				aria-controls=\"tribe-events-subscribe-dropdown-content\"\n				aria-label=\"\"\n			>\n				Subscribe to calendar			</button>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-subscribe-dropdown__button-icon\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</div>\n		<div id=\"tribe-events-c-subscribe-dropdown-content\" class=\"tribe-events-c-subscribe-dropdown__content\">\n			<ul class=\"tribe-events-c-subscribe-dropdown__list\">\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://www.google.com/calendar/render?cid=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26tribe-bar-date%3D2025-03%26ical%3D1%26eventDisplay%3Dlist\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Google Calendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"webcal://ikosz.hu/en/?post_type=tribe_events&#038;tribe-bar-date=2025-03&#038;ical=1&#038;eventDisplay=list\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		iCalendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.office.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26tribe-bar-date%3D2025-03%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+Events+Archívált+-+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook 365	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.live.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26tribe-bar-date%3D2025-03%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+Events+Archívált+-+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook Live	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-03/?ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export .ics file	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-03/?outlook-ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export Outlook .ics file	</a>\n</li>\n							</ul>\n		</div>\n	</div>\n</div>\n\n		<div class=\"tribe-events-after-html\">\n	\n<!--\nThis calendar is powered by The Events Calendar.\nhttp://evnt.is/18wn\n-->\n</div>\n\n	</div>\n\n</div>\n\n<script class=\"tribe-events-breakpoints\">\n	( function () {\n		var completed = false;\n\n		function initBreakpoints() {\n			if ( completed ) {\n				// This was fired already and completed no need to attach to the event listener.\n				document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views.breakpoints ) {\n				return;\n			}\n\n			if ( \'function\' !== typeof (window.tribe.events.views.breakpoints.setup) ) {\n				return;\n			}\n\n			var container = document.querySelectorAll( \'[data-view-breakpoint-pointer=\"505bd33c-5483-4aba-a337-b73430233c73\"]\' );\n			if ( ! container ) {\n				return;\n			}\n\n			window.tribe.events.views.breakpoints.setup( container );\n			completed = true;\n			// This was fired already and completed no need to attach to the event listener.\n			document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n		}\n\n		// Try to init the breakpoints right away.\n		initBreakpoints();\n		document.addEventListener( \'DOMContentLoaded\', initBreakpoints );\n	})();\n</script>\n", "off");
INSERT INTO `wp_options` VALUES("488321", "_transient_timeout_tribe_views_v2_cache_8f5581eafbba:1739930717.7646_0", "1740138544", "off");
INSERT INTO `wp_options` VALUES("488322", "_transient_tribe_views_v2_cache_8f5581eafbba:1739930717.7646_0", "<div\n	 class=\"tribe-common tribe-events tribe-events-view tribe-events-view--month\" 	data-js=\"tribe-events-view\"\n	data-view-rest-nonce=\"\"\n	data-view-rest-url=\"https://ikosz.hu/wp-json/tribe/views/v2/html\"\n	data-view-rest-method=\"POST\"\n	data-view-manage-url=\"1\"\n				data-view-breakpoint-pointer=\"f568182d-5cf8-4a41-84e4-e38aad50f7c8\"\n	>\n	<div class=\"tribe-common-l-container tribe-events-l-container\">\n		<div\n	class=\"tribe-events-view-loader tribe-common-a11y-hidden\"\n	role=\"alert\"\n	aria-live=\"polite\"\n>\n	<span class=\"tribe-events-view-loader__text tribe-common-a11y-visual-hide\">\n		35 events found.	</span>\n	<div class=\"tribe-events-view-loader__dots tribe-common-c-loader\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--first\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--second\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n	</div>\n</div>\n\n		\n		<script data-js=\"tribe-events-view-data\" type=\"application/json\">\n	{\"slug\":\"month\",\"prev_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/2025-01\\/\",\"next_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/2025-03\\/\",\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_slug\":\"month\",\"view_label\":\"Month\",\"title\":\"ikosz\",\"events\":{\"2025-01-27\":[],\"2025-01-28\":[],\"2025-01-29\":[],\"2025-01-30\":[],\"2025-01-31\":[],\"2025-02-01\":[],\"2025-02-02\":[],\"2025-02-03\":[],\"2025-02-04\":[],\"2025-02-05\":[],\"2025-02-06\":[],\"2025-02-07\":[],\"2025-02-08\":[],\"2025-02-09\":[],\"2025-02-10\":[],\"2025-02-11\":[],\"2025-02-12\":[],\"2025-02-13\":[],\"2025-02-14\":[],\"2025-02-15\":[],\"2025-02-16\":[],\"2025-02-17\":[],\"2025-02-18\":[],\"2025-02-19\":[],\"2025-02-20\":[],\"2025-02-21\":[],\"2025-02-22\":[],\"2025-02-23\":[],\"2025-02-24\":[],\"2025-02-25\":[],\"2025-02-26\":[],\"2025-02-27\":[],\"2025-02-28\":[],\"2025-03-01\":[],\"2025-03-02\":[]},\"url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/month\\/\",\"url_event_date\":false,\"bar\":{\"keyword\":\"\",\"date\":\"\"},\"today\":\"2025-02-20 00:00:00\",\"now\":\"2025-02-20 11:49:04\",\"rest_url\":\"https:\\/\\/ikosz.hu\\/wp-json\\/tribe\\/views\\/v2\\/html\",\"rest_method\":\"POST\",\"rest_nonce\":\"\",\"should_manage_url\":true,\"today_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/month\\/\",\"today_title\":\"Click to select the current month\",\"today_label\":\"This Month\",\"prev_label\":\"jan\",\"next_label\":\"m\\u00e1rc\",\"date_formats\":{\"compact\":\"n\\/j\\/Y\",\"month_and_year_compact\":\"n\\/Y\",\"month_and_year\":\"F Y\",\"time_range_separator\":\" - \",\"date_time_separator\":\" @ \"},\"messages\":{\"notice\":[\"Nincsenek k\\u00f6zelg\\u0151 esem\\u00e9nyek.\"]},\"start_of_week\":\"1\",\"header_title\":\"k\\u00fclt\\u00e9ri\",\"header_title_element\":\"h1\",\"content_title\":\"\",\"breadcrumbs\":[{\"link\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/\",\"label\":\"Events\"},{\"link\":\"\",\"label\":\"k\\u00fclt\\u00e9ri\"}],\"before_events\":\"\",\"after_events\":\"\\n<!--\\nThis calendar is powered by The Events Calendar.\\nhttp:\\/\\/evnt.is\\/18wn\\n-->\\n\",\"display_events_bar\":true,\"disable_event_search\":true,\"live_refresh\":true,\"ical\":{\"display_link\":true,\"link\":{\"url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/month\\/?ical=1\",\"text\":\"Export Events\",\"title\":\"Use this to share calendar data with Google Calendar, Apple iCal and other compatible apps\"}},\"container_classes\":[\"tribe-common\",\"tribe-events\",\"tribe-events-view\",\"tribe-events-view--month\"],\"container_data\":[],\"is_past\":false,\"breakpoints\":{\"xsmall\":500,\"medium\":768,\"full\":960},\"breakpoint_pointer\":\"f568182d-5cf8-4a41-84e4-e38aad50f7c8\",\"is_initial_load\":true,\"public_views\":{\"list\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\List_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/list\\/\",\"view_label\":\"List\"},\"month\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/month\\/\",\"view_label\":\"Month\"},\"day\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Day_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/today\\/\",\"view_label\":\"Day\"}},\"show_latest_past\":true,\"today_date\":\"2025-02-20\",\"grid_date\":\"2025-02-20\",\"formatted_grid_date\":\"febru\\u00e1r 2025\",\"formatted_grid_date_mobile\":\"2\\/20\\/2025\",\"days\":{\"2025-01-27\":{\"date\":\"2025-01-27\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-01-27\\/\"},\"2025-01-28\":{\"date\":\"2025-01-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-01-28\\/\"},\"2025-01-29\":{\"date\":\"2025-01-29\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"29\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-01-29\\/\"},\"2025-01-30\":{\"date\":\"2025-01-30\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"30\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-01-30\\/\"},\"2025-01-31\":{\"date\":\"2025-01-31\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"31\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-01-31\\/\"},\"2025-02-01\":{\"date\":\"2025-02-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-01\\/\"},\"2025-02-02\":{\"date\":\"2025-02-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-02\\/\"},\"2025-02-03\":{\"date\":\"2025-02-03\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-03\\/\"},\"2025-02-04\":{\"date\":\"2025-02-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-04\\/\"},\"2025-02-05\":{\"date\":\"2025-02-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-05\\/\"},\"2025-02-06\":{\"date\":\"2025-02-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-06\\/\"},\"2025-02-07\":{\"date\":\"2025-02-07\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"7\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-07\\/\"},\"2025-02-08\":{\"date\":\"2025-02-08\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"8\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-08\\/\"},\"2025-02-09\":{\"date\":\"2025-02-09\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"9\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-09\\/\"},\"2025-02-10\":{\"date\":\"2025-02-10\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"10\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-10\\/\"},\"2025-02-11\":{\"date\":\"2025-02-11\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"11\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-11\\/\"},\"2025-02-12\":{\"date\":\"2025-02-12\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"12\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-12\\/\"},\"2025-02-13\":{\"date\":\"2025-02-13\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"13\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-13\\/\"},\"2025-02-14\":{\"date\":\"2025-02-14\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"14\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-14\\/\"},\"2025-02-15\":{\"date\":\"2025-02-15\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"15\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-15\\/\"},\"2025-02-16\":{\"date\":\"2025-02-16\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"16\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-16\\/\"},\"2025-02-17\":{\"date\":\"2025-02-17\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"17\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-17\\/\"},\"2025-02-18\":{\"date\":\"2025-02-18\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"18\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-18\\/\"},\"2025-02-19\":{\"date\":\"2025-02-19\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"19\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-19\\/\"},\"2025-02-20\":{\"date\":\"2025-02-20\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"20\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-20\\/\"},\"2025-02-21\":{\"date\":\"2025-02-21\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"21\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-21\\/\"},\"2025-02-22\":{\"date\":\"2025-02-22\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"22\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-22\\/\"},\"2025-02-23\":{\"date\":\"2025-02-23\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"23\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-23\\/\"},\"2025-02-24\":{\"date\":\"2025-02-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-24\\/\"},\"2025-02-25\":{\"date\":\"2025-02-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-25\\/\"},\"2025-02-26\":{\"date\":\"2025-02-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-26\\/\"},\"2025-02-27\":{\"date\":\"2025-02-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-27\\/\"},\"2025-02-28\":{\"date\":\"2025-02-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-02-28\\/\"},\"2025-03-01\":{\"date\":\"2025-03-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-03-01\\/\"},\"2025-03-02\":{\"date\":\"2025-03-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/outside\\/day\\/2025-03-02\\/\"}},\"next_month\":\"3\",\"prev_month\":\"1\",\"next_rel\":\"noindex\",\"prev_rel\":\"noindex\",\"mobile_messages\":{\"notice\":{\"no-events-in-day\":\"There are no events on this day.\"}},\"grid_start_date\":\"2025-01-27\",\"subscribe_links\":{\"gcal\":{\"label\":\"Google Calendar\",\"single_label\":\"Add to Google Calendar\",\"visible\":true,\"block_slug\":\"hasGoogleCalendar\"},\"ical\":{\"label\":\"iCalendar\",\"single_label\":\"Add to iCalendar\",\"visible\":true,\"block_slug\":\"hasiCal\"},\"outlook-365\":{\"label\":\"Outlook 365\",\"single_label\":\"Outlook 365\",\"visible\":true,\"block_slug\":\"hasOutlook365\"},\"outlook-live\":{\"label\":\"Outlook Live\",\"single_label\":\"Outlook Live\",\"visible\":true,\"block_slug\":\"hasOutlookLive\"},\"ics\":{\"label\":\"Export .ics file\",\"single_label\":\"Export .ics file\",\"visible\":true,\"block_slug\":null},\"outlook-ics\":{\"label\":\"Export Outlook .ics file\",\"single_label\":\"Export Outlook .ics file\",\"visible\":true,\"block_slug\":null}},\"_context\":{\"slug\":\"month\"},\"text\":\"Loading...\",\"classes\":[\"tribe-common-c-loader__dot\",\"tribe-common-c-loader__dot--third\"]}</script>\n\n		\n		<header  class=\"tribe-events-header\" >\n			<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"0\" 					>\n					Nincsenek közelgő események.					</li>\n							</ul>\n		</div>\n	</div>\n\n			<div class=\"tribe-events-header__breadcrumbs tribe-events-c-breadcrumbs\">\n	<ol class=\"tribe-events-c-breadcrumbs__list\">\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/\"\n		class=\"tribe-events-c-breadcrumbs__list-item-link tribe-common-anchor\"\n		title=\"\"\n		data-js=\"tribe-events-view-link\"\n	>\n		Events	</a>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<span class=\"tribe-events-c-breadcrumbs__list-item-text\">\n		kültéri	</span>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n			</ol>\n</div>\n\n			<div\n	 class=\"tribe-events-header__events-bar tribe-events-c-events-bar\" 	data-js=\"tribe-events-events-bar\"\n>\n\n	<h2 class=\"tribe-common-a11y-visual-hide\">\n		Views Navigation	</h2>\n\n	\n	<div class=\"tribe-events-c-events-bar__views\">\n	<h3 class=\"tribe-common-a11y-visual-hide\">\n		Event Views Navigation	</h3>\n	<div  class=\"tribe-events-c-view-selector\"  data-js=\"tribe-events-view-selector\">\n		<button\n			class=\"tribe-events-c-view-selector__button tribe-common-c-btn__clear\"\n			data-js=\"tribe-events-view-selector-button\"\n		>\n			<span class=\"tribe-events-c-view-selector__button-icon\">\n				<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__button-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>			</span>\n			<span class=\"tribe-events-c-view-selector__button-text tribe-common-a11y-visual-hide\">\n				Month			</span>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-view-selector__button-icon-caret-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</button>\n		<div\n	class=\"tribe-events-c-view-selector__content\"\n	id=\"tribe-events-view-selector-content\"\n	data-js=\"tribe-events-view-selector-list-container\"\n>\n	<ul class=\"tribe-events-c-view-selector__list\">\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--list\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/list/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--list tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.451.432V17.6c0 .238.163.432.364.432H18.12c.2 0 .364-.194.364-.432V.432c0-.239-.163-.432-.364-.432H.815c-.2 0-.364.193-.364.432zm.993.81h16.024V3.56H1.444V1.24zM17.468 3.56H1.444v13.227h16.024V3.56z\" class=\"tribe-common-c-svgicon__svg-fill\"/><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-0)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 4.912v1.825c0 .504.409.913.913.913h1.825a.913.913 0 00.912-.913V4.912A.913.913 0 0014.57 4h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 7.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 5.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-1)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 10.912v1.825c0 .505.409.913.913.913h1.825a.913.913 0 00.912-.912v-1.825A.913.913 0 0014.57 10h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 13.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 11.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><defs><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-0\"><path transform=\"translate(3.451 4)\" d=\"M0 0h13v4H0z\"/></clipPath><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-1\"><path transform=\"translate(3.451 10)\" d=\"M0 0h13v4H0z\"/></clipPath></defs></svg>\n		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			List		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--month tribe-events-c-view-selector__list-item--active\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/month/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Month		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--day\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/today/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--day tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 18\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.363 17.569V.43C.363.193.526 0 .726 0H18c.201 0 .364.193.364.431V17.57c0 .238-.163.431-.364.431H.726c-.2 0-.363-.193-.363-.431zm16.985-16.33H1.354v2.314h15.994V1.24zM1.354 4.688h15.994v12.07H1.354V4.687zm11.164 9.265v-1.498c0-.413.335-.748.748-.748h1.498c.413 0 .748.335.748.748v1.498a.749.749 0 01-.748.748h-1.498a.749.749 0 01-.748-.748z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Day		</span>\n	</a>\n</li>\n			</ul>\n</div>\n	</div>\n</div>\n\n</div>\n\n			<div class=\"tribe-events-c-top-bar tribe-events-header__top-bar\">\n\n	<nav class=\"tribe-events-c-top-bar__nav tribe-common-a11y-hidden\">\n	<ul class=\"tribe-events-c-top-bar__nav-list\">\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/2025-01/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-left tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--prev\"\n		aria-label=\"Previous month\"\n		title=\"Previous month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</a>\n</li>\n\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/2025-03/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-right tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--next\"\n		aria-label=\"Next month\"\n		title=\"Next month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n	<a\n	href=\"https://ikosz.hu/esemenyek/category/outside/month/\"\n	class=\"tribe-common-c-btn-border-small tribe-events-c-top-bar__today-button tribe-common-a11y-hidden\"\n	data-js=\"tribe-events-view-link\"\n	aria-label=\"Click to select the current month\"\n	title=\"Click to select the current month\"\n>\n	This Month</a>\n\n	<div class=\"tribe-events-c-top-bar__datepicker\">\n	<button\n		class=\"tribe-common-c-btn__clear tribe-common-h3 tribe-common-h--alt tribe-events-c-top-bar__datepicker-button\"\n		data-js=\"tribe-events-top-bar-datepicker-button\"\n		type=\"button\"\n		aria-label=\"Click to toggle datepicker\"\n		title=\"Click to toggle datepicker\"\n	>\n		<time\n			datetime=\"2025-02\"\n			class=\"tribe-events-c-top-bar__datepicker-time\"\n		>\n			<span class=\"tribe-events-c-top-bar__datepicker-mobile\">\n				2/20/2025			</span>\n			<span class=\"tribe-events-c-top-bar__datepicker-desktop tribe-common-a11y-hidden\">\n				február 2025			</span>\n		</time>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-top-bar__datepicker-button-icon-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n	</button>\n	<label\n		class=\"tribe-events-c-top-bar__datepicker-label tribe-common-a11y-visual-hide\"\n		for=\"tribe-events-top-bar-date\"\n	>\n		Select date.	</label>\n	<input\n		type=\"text\"\n		class=\"tribe-events-c-top-bar__datepicker-input tribe-common-a11y-visual-hide\"\n		data-js=\"tribe-events-top-bar-date\"\n		id=\"tribe-events-top-bar-date\"\n		name=\"tribe-events-views[tribe-bar-date]\"\n		value=\"2/20/2025\"\n		tabindex=\"-1\"\n		autocomplete=\"off\"\n		readonly=\"readonly\"\n	/>\n	<div class=\"tribe-events-c-top-bar__datepicker-container\" data-js=\"tribe-events-top-bar-datepicker-container\"></div>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-prev-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</template>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-next-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</template>\n</div>\n\n	<div class=\"tribe-events-c-top-bar__actions tribe-common-a11y-hidden\">\n	</div>\n\n</div>\n		</header>\n\n		\n		<div\n			class=\"tribe-events-calendar-month\"\n			role=\"grid\"\n			aria-labelledby=\"tribe-events-calendar-header\"\n			aria-readonly=\"true\"\n			data-js=\"tribe-events-month-grid\"\n		>\n\n			<header class=\"tribe-events-calendar-month__header\" role=\"rowgroup\">\n\n	<h2 class=\"tribe-common-a11y-visual-hide\" id=\"tribe-events-calendar-header\">\n		Calendar of Events	</h2>\n\n	<div role=\"row\" class=\"tribe-events-calendar-month__header-row\">\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"hétfő\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						h					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						hét					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"kedd\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						K					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						ked					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"szerda\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						s					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						sze					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"csütörtök\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						c					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						csü					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"péntek\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						p					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						pén					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"szombat\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						s					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						szo					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"vasárnap\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						v					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						vas					</span>\n				</h3>\n			</div>\n			</div>\n</header>\n\n			\n<div class=\"tribe-events-calendar-month__body\" role=\"rowgroup\">\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-29\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-29\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-29\"\n		>\n			29		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-29\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-29\"\n	>\n					29			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-30\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-30\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-30\"\n		>\n			30		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-30\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-30\"\n	>\n					30			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-31\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-31\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-31\"\n		>\n			31		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-31\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-31\"\n	>\n					31			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-07\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-7\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-07\"\n		>\n			7		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-07\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-07\"\n	>\n					7			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-08\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-8\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-08\"\n		>\n			8		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-08\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-08\"\n	>\n					8			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-09\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-9\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-09\"\n		>\n			9		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-09\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-09\"\n	>\n					9			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-10\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-10\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-10\"\n		>\n			10		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-10\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-10\"\n	>\n					10			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-11\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-11\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-11\"\n		>\n			11		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-11\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-11\"\n	>\n					11			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-12\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-12\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-12\"\n		>\n			12		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-12\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-12\"\n	>\n					12			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-13\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-13\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-13\"\n		>\n			13		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-13\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-13\"\n	>\n					13			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-14\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-14\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-14\"\n		>\n			14		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-14\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-14\"\n	>\n					14			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-15\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-15\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-15\"\n		>\n			15		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-15\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-15\"\n	>\n					15			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-16\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-16\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-16\"\n		>\n			16		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-16\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-16\"\n	>\n					16			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-17\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-17\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-17\"\n		>\n			17		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-17\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-17\"\n	>\n					17			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-18\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-18\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-18\"\n		>\n			18		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-18\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-18\"\n	>\n					18			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-19\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-19\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-19\"\n		>\n			19		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-19\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-19\"\n	>\n					19			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--current\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-20\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"true\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-20\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile tribe-events-calendar-month__day-cell--selected\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-20\"\n		>\n			20		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-20\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-20\"\n	>\n					20			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-21\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-21\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-21\"\n		>\n			21		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-21\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-21\"\n	>\n					21			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-22\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-22\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-22\"\n		>\n			22		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-22\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-22\"\n	>\n					22			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-23\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-23\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-23\"\n		>\n			23		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-23\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-23\"\n	>\n					23			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n</div>\n\n		</div>\n\n		<section class=\"tribe-events-calendar-month-mobile-events\" data-js=\"tribe-events-calendar-month-mobile-events\">\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-29\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-30\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-31\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-7\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-8\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-9\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-10\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-11\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-12\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-13\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-14\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-15\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-16\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-17\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-18\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-19\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day tribe-events-calendar-month-mobile-events__mobile-day--show\"  id=\"tribe-events-calendar-mobile-day-2025-02-20\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-21\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-22\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-23\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-24\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-25\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-26\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n	<nav class=\"tribe-events-calendar-month-nav tribe-events-c-nav\">\n	<ul class=\"tribe-events-c-nav__list\">\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--prev\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/2025-01/\"\n		rel=\"prev\"\n		class=\"tribe-events-c-nav__prev tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Previous month, jan\"\n		title=\"Previous month, jan\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-nav__prev-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n		jan	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--today\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/month/\"\n		class=\"tribe-events-c-nav__today tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Click to select the current month\"\n		title=\"Click to select the current month\"\n	>\n		This Month	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--next\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/2025-03/\"\n		rel=\"next\"\n		class=\"tribe-events-c-nav__next tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Next month, márc\"\n		title=\"Next month, márc\"\n		rel=\"noindex\"\n	>\n		márc		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-nav__next-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n</section>\n\n		<div class=\"tribe-events-c-subscribe-dropdown__container\">\n	<div class=\"tribe-events-c-subscribe-dropdown\">\n		<div class=\"tribe-common-c-btn-border tribe-events-c-subscribe-dropdown__button\">\n			<button\n				class=\"tribe-events-c-subscribe-dropdown__button-text tribe-common-c-btn--clear\"\n				aria-expanded=\"false\"\n				aria-controls=\"tribe-events-subscribe-dropdown-content\"\n				aria-label=\"\"\n			>\n				Subscribe to calendar			</button>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-subscribe-dropdown__button-icon\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</div>\n		<div id=\"tribe-events-c-subscribe-dropdown-content\" class=\"tribe-events-c-subscribe-dropdown__content\">\n			<ul class=\"tribe-events-c-subscribe-dropdown__list\">\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://www.google.com/calendar/render?cid=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Doutside%26ical%3D1%26eventDisplay%3Dlist\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Google Calendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"webcal://ikosz.hu/?post_type=tribe_events&#038;tribe_events_cat=outside&#038;ical=1&#038;eventDisplay=list\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		iCalendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.office.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Doutside%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook 365	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.live.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Doutside%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook Live	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/month/?ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export .ics file	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/outside/month/?outlook-ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export Outlook .ics file	</a>\n</li>\n							</ul>\n		</div>\n	</div>\n</div>\n\n		<div class=\"tribe-events-after-html\">\n	\n<!--\nThis calendar is powered by The Events Calendar.\nhttp://evnt.is/18wn\n-->\n</div>\n\n	</div>\n\n</div>\n\n<script class=\"tribe-events-breakpoints\">\n	( function () {\n		var completed = false;\n\n		function initBreakpoints() {\n			if ( completed ) {\n				// This was fired already and completed no need to attach to the event listener.\n				document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views.breakpoints ) {\n				return;\n			}\n\n			if ( \'function\' !== typeof (window.tribe.events.views.breakpoints.setup) ) {\n				return;\n			}\n\n			var container = document.querySelectorAll( \'[data-view-breakpoint-pointer=\"f568182d-5cf8-4a41-84e4-e38aad50f7c8\"]\' );\n			if ( ! container ) {\n				return;\n			}\n\n			window.tribe.events.views.breakpoints.setup( container );\n			completed = true;\n			// This was fired already and completed no need to attach to the event listener.\n			document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n		}\n\n		// Try to init the breakpoints right away.\n		initBreakpoints();\n		document.addEventListener( \'DOMContentLoaded\', initBreakpoints );\n	})();\n</script>\n", "off");
INSERT INTO `wp_options` VALUES("488520", "_transient_timeout_tribe_views_v2_cache_c043ac1af586:1739930717.7646_0", "1740148801", "off");
INSERT INTO `wp_options` VALUES("488521", "_transient_tribe_views_v2_cache_c043ac1af586:1739930717.7646_0", "<div\n	 class=\"tribe-common tribe-events tribe-events-view tribe-events-view--month\" 	data-js=\"tribe-events-view\"\n	data-view-rest-nonce=\"\"\n	data-view-rest-url=\"https://ikosz.hu/en/wp-json/tribe/views/v2/html\"\n	data-view-rest-method=\"POST\"\n	data-view-manage-url=\"1\"\n				data-view-breakpoint-pointer=\"04ff8f40-2c89-4d05-8ac0-34b49f9e157f\"\n	>\n	<div class=\"tribe-common-l-container tribe-events-l-container\">\n		<div\n	class=\"tribe-events-view-loader tribe-common-a11y-hidden\"\n	role=\"alert\"\n	aria-live=\"polite\"\n>\n	<span class=\"tribe-events-view-loader__text tribe-common-a11y-visual-hide\">\n		35 events found.	</span>\n	<div class=\"tribe-events-view-loader__dots tribe-common-c-loader\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--first\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--second\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n	</div>\n</div>\n\n		\n		<script data-js=\"tribe-events-view-data\" type=\"application/json\">\n	{\"slug\":\"month\",\"prev_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-01\\/\",\"next_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/2025-03\\/\",\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_slug\":\"month\",\"view_label\":\"Month\",\"title\":\"Events Arch\\u00edv\\u00e1lt - ikosz\",\"events\":{\"2025-01-27\":[],\"2025-01-28\":[],\"2025-01-29\":[],\"2025-01-30\":[],\"2025-01-31\":[],\"2025-02-01\":[],\"2025-02-02\":[],\"2025-02-03\":[],\"2025-02-04\":[],\"2025-02-05\":[],\"2025-02-06\":[],\"2025-02-07\":[],\"2025-02-08\":[],\"2025-02-09\":[],\"2025-02-10\":[],\"2025-02-11\":[],\"2025-02-12\":[],\"2025-02-13\":[],\"2025-02-14\":[],\"2025-02-15\":[],\"2025-02-16\":[],\"2025-02-17\":[],\"2025-02-18\":[],\"2025-02-19\":[],\"2025-02-20\":[],\"2025-02-21\":[],\"2025-02-22\":[],\"2025-02-23\":[],\"2025-02-24\":[],\"2025-02-25\":[],\"2025-02-26\":[],\"2025-02-27\":[],\"2025-02-28\":[],\"2025-03-01\":[],\"2025-03-02\":[]},\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/\",\"url_event_date\":false,\"bar\":{\"keyword\":\"\",\"date\":\"\"},\"today\":\"2025-02-20 00:00:00\",\"now\":\"2025-02-20 14:40:00\",\"rest_url\":\"https:\\/\\/ikosz.hu\\/en\\/wp-json\\/tribe\\/views\\/v2\\/html\",\"rest_method\":\"POST\",\"rest_nonce\":\"\",\"should_manage_url\":true,\"today_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/\",\"today_title\":\"Click to select the current month\",\"today_label\":\"This Month\",\"prev_label\":\"Jan\",\"next_label\":\"Mar\",\"date_formats\":{\"compact\":\"n\\/j\\/Y\",\"month_and_year_compact\":\"n\\/Y\",\"month_and_year\":\"F Y\",\"time_range_separator\":\" - \",\"date_time_separator\":\" @ \"},\"messages\":{\"notice\":[\"There are no upcoming events.\"]},\"start_of_week\":\"1\",\"header_title\":\"\",\"header_title_element\":\"h1\",\"content_title\":\"\",\"breadcrumbs\":[],\"before_events\":\"\",\"after_events\":\"\\n<!--\\nThis calendar is powered by The Events Calendar.\\nhttp:\\/\\/evnt.is\\/18wn\\n-->\\n\",\"display_events_bar\":true,\"disable_event_search\":true,\"live_refresh\":true,\"ical\":{\"display_link\":true,\"link\":{\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/?ical=1\",\"text\":\"Export Events\",\"title\":\"Use this to share calendar data with Google Calendar, Apple iCal and other compatible apps\"}},\"container_classes\":[\"tribe-common\",\"tribe-events\",\"tribe-events-view\",\"tribe-events-view--month\"],\"container_data\":[],\"is_past\":false,\"breakpoints\":{\"xsmall\":500,\"medium\":768,\"full\":960},\"breakpoint_pointer\":\"04ff8f40-2c89-4d05-8ac0-34b49f9e157f\",\"is_initial_load\":true,\"public_views\":{\"list\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\List_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/list\\/\",\"view_label\":\"List\"},\"month\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/month\\/\",\"view_label\":\"Month\"},\"day\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Day_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/today\\/\",\"view_label\":\"Day\"}},\"show_latest_past\":true,\"today_date\":\"2025-02-20\",\"grid_date\":\"2025-02-20\",\"formatted_grid_date\":\"February 2025\",\"formatted_grid_date_mobile\":\"2\\/20\\/2025\",\"days\":{\"2025-01-27\":{\"date\":\"2025-01-27\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-01-27\\/\"},\"2025-01-28\":{\"date\":\"2025-01-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-01-28\\/\"},\"2025-01-29\":{\"date\":\"2025-01-29\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"29\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-01-29\\/\"},\"2025-01-30\":{\"date\":\"2025-01-30\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"30\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-01-30\\/\"},\"2025-01-31\":{\"date\":\"2025-01-31\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"31\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-01-31\\/\"},\"2025-02-01\":{\"date\":\"2025-02-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-01\\/\"},\"2025-02-02\":{\"date\":\"2025-02-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-02\\/\"},\"2025-02-03\":{\"date\":\"2025-02-03\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-03\\/\"},\"2025-02-04\":{\"date\":\"2025-02-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-04\\/\"},\"2025-02-05\":{\"date\":\"2025-02-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-05\\/\"},\"2025-02-06\":{\"date\":\"2025-02-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-06\\/\"},\"2025-02-07\":{\"date\":\"2025-02-07\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"7\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-07\\/\"},\"2025-02-08\":{\"date\":\"2025-02-08\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"8\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-08\\/\"},\"2025-02-09\":{\"date\":\"2025-02-09\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"9\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-09\\/\"},\"2025-02-10\":{\"date\":\"2025-02-10\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"10\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-10\\/\"},\"2025-02-11\":{\"date\":\"2025-02-11\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"11\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-11\\/\"},\"2025-02-12\":{\"date\":\"2025-02-12\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"12\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-12\\/\"},\"2025-02-13\":{\"date\":\"2025-02-13\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"13\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-13\\/\"},\"2025-02-14\":{\"date\":\"2025-02-14\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"14\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-14\\/\"},\"2025-02-15\":{\"date\":\"2025-02-15\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"15\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-15\\/\"},\"2025-02-16\":{\"date\":\"2025-02-16\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"16\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-16\\/\"},\"2025-02-17\":{\"date\":\"2025-02-17\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"17\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-17\\/\"},\"2025-02-18\":{\"date\":\"2025-02-18\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"18\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-18\\/\"},\"2025-02-19\":{\"date\":\"2025-02-19\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"19\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-19\\/\"},\"2025-02-20\":{\"date\":\"2025-02-20\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"20\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-20\\/\"},\"2025-02-21\":{\"date\":\"2025-02-21\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"21\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-21\\/\"},\"2025-02-22\":{\"date\":\"2025-02-22\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"22\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-22\\/\"},\"2025-02-23\":{\"date\":\"2025-02-23\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"23\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-23\\/\"},\"2025-02-24\":{\"date\":\"2025-02-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-24\\/\"},\"2025-02-25\":{\"date\":\"2025-02-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-25\\/\"},\"2025-02-26\":{\"date\":\"2025-02-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-26\\/\"},\"2025-02-27\":{\"date\":\"2025-02-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-27\\/\"},\"2025-02-28\":{\"date\":\"2025-02-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-02-28\\/\"},\"2025-03-01\":{\"date\":\"2025-03-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-01\\/\"},\"2025-03-02\":{\"date\":\"2025-03-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/2025-03-02\\/\"}},\"next_month\":\"3\",\"prev_month\":\"1\",\"next_rel\":\"noindex\",\"prev_rel\":\"noindex\",\"mobile_messages\":{\"notice\":{\"no-events-in-day\":\"There are no events on this day.\"}},\"grid_start_date\":\"2025-01-27\",\"subscribe_links\":{\"gcal\":{\"label\":\"Google Calendar\",\"single_label\":\"Add to Google Calendar\",\"visible\":true,\"block_slug\":\"hasGoogleCalendar\"},\"ical\":{\"label\":\"iCalendar\",\"single_label\":\"Add to iCalendar\",\"visible\":true,\"block_slug\":\"hasiCal\"},\"outlook-365\":{\"label\":\"Outlook 365\",\"single_label\":\"Outlook 365\",\"visible\":true,\"block_slug\":\"hasOutlook365\"},\"outlook-live\":{\"label\":\"Outlook Live\",\"single_label\":\"Outlook Live\",\"visible\":true,\"block_slug\":\"hasOutlookLive\"},\"ics\":{\"label\":\"Export .ics file\",\"single_label\":\"Export .ics file\",\"visible\":true,\"block_slug\":null},\"outlook-ics\":{\"label\":\"Export Outlook .ics file\",\"single_label\":\"Export Outlook .ics file\",\"visible\":true,\"block_slug\":null}},\"_context\":{\"slug\":\"month\"},\"text\":\"Loading...\",\"classes\":[\"tribe-common-c-loader__dot\",\"tribe-common-c-loader__dot--third\"]}</script>\n\n		\n		<header  class=\"tribe-events-header\" >\n			<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"0\" 					>\n					There are no upcoming events.					</li>\n							</ul>\n		</div>\n	</div>\n\n			\n			<div\n	 class=\"tribe-events-header__events-bar tribe-events-c-events-bar\" 	data-js=\"tribe-events-events-bar\"\n>\n\n	<h2 class=\"tribe-common-a11y-visual-hide\">\n		Views Navigation	</h2>\n\n	\n	<div class=\"tribe-events-c-events-bar__views\">\n	<h3 class=\"tribe-common-a11y-visual-hide\">\n		Event Views Navigation	</h3>\n	<div  class=\"tribe-events-c-view-selector\"  data-js=\"tribe-events-view-selector\">\n		<button\n			class=\"tribe-events-c-view-selector__button tribe-common-c-btn__clear\"\n			data-js=\"tribe-events-view-selector-button\"\n		>\n			<span class=\"tribe-events-c-view-selector__button-icon\">\n				<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__button-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>			</span>\n			<span class=\"tribe-events-c-view-selector__button-text tribe-common-a11y-visual-hide\">\n				Month			</span>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-view-selector__button-icon-caret-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</button>\n		<div\n	class=\"tribe-events-c-view-selector__content\"\n	id=\"tribe-events-view-selector-content\"\n	data-js=\"tribe-events-view-selector-list-container\"\n>\n	<ul class=\"tribe-events-c-view-selector__list\">\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--list\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/list/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--list tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.451.432V17.6c0 .238.163.432.364.432H18.12c.2 0 .364-.194.364-.432V.432c0-.239-.163-.432-.364-.432H.815c-.2 0-.364.193-.364.432zm.993.81h16.024V3.56H1.444V1.24zM17.468 3.56H1.444v13.227h16.024V3.56z\" class=\"tribe-common-c-svgicon__svg-fill\"/><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-0)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 4.912v1.825c0 .504.409.913.913.913h1.825a.913.913 0 00.912-.913V4.912A.913.913 0 0014.57 4h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 7.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 5.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-1)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 10.912v1.825c0 .505.409.913.913.913h1.825a.913.913 0 00.912-.912v-1.825A.913.913 0 0014.57 10h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 13.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 11.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><defs><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-0\"><path transform=\"translate(3.451 4)\" d=\"M0 0h13v4H0z\"/></clipPath><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-1\"><path transform=\"translate(3.451 10)\" d=\"M0 0h13v4H0z\"/></clipPath></defs></svg>\n		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			List		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--month tribe-events-c-view-selector__list-item--active\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Month		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--day\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/today/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--day tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 18\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.363 17.569V.43C.363.193.526 0 .726 0H18c.201 0 .364.193.364.431V17.57c0 .238-.163.431-.364.431H.726c-.2 0-.363-.193-.363-.431zm16.985-16.33H1.354v2.314h15.994V1.24zM1.354 4.688h15.994v12.07H1.354V4.687zm11.164 9.265v-1.498c0-.413.335-.748.748-.748h1.498c.413 0 .748.335.748.748v1.498a.749.749 0 01-.748.748h-1.498a.749.749 0 01-.748-.748z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Day		</span>\n	</a>\n</li>\n			</ul>\n</div>\n	</div>\n</div>\n\n</div>\n\n			<div class=\"tribe-events-c-top-bar tribe-events-header__top-bar\">\n\n	<nav class=\"tribe-events-c-top-bar__nav tribe-common-a11y-hidden\">\n	<ul class=\"tribe-events-c-top-bar__nav-list\">\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-01/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-left tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--prev\"\n		aria-label=\"Previous month\"\n		title=\"Previous month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</a>\n</li>\n\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-03/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-right tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--next\"\n		aria-label=\"Next month\"\n		title=\"Next month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n	<a\n	href=\"https://ikosz.hu/en/esemenyek/month/\"\n	class=\"tribe-common-c-btn-border-small tribe-events-c-top-bar__today-button tribe-common-a11y-hidden\"\n	data-js=\"tribe-events-view-link\"\n	aria-label=\"Click to select the current month\"\n	title=\"Click to select the current month\"\n>\n	This Month</a>\n\n	<div class=\"tribe-events-c-top-bar__datepicker\">\n	<button\n		class=\"tribe-common-c-btn__clear tribe-common-h3 tribe-common-h--alt tribe-events-c-top-bar__datepicker-button\"\n		data-js=\"tribe-events-top-bar-datepicker-button\"\n		type=\"button\"\n		aria-label=\"Click to toggle datepicker\"\n		title=\"Click to toggle datepicker\"\n	>\n		<time\n			datetime=\"2025-02\"\n			class=\"tribe-events-c-top-bar__datepicker-time\"\n		>\n			<span class=\"tribe-events-c-top-bar__datepicker-mobile\">\n				2/20/2025			</span>\n			<span class=\"tribe-events-c-top-bar__datepicker-desktop tribe-common-a11y-hidden\">\n				February 2025			</span>\n		</time>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-top-bar__datepicker-button-icon-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n	</button>\n	<label\n		class=\"tribe-events-c-top-bar__datepicker-label tribe-common-a11y-visual-hide\"\n		for=\"tribe-events-top-bar-date\"\n	>\n		Select date.	</label>\n	<input\n		type=\"text\"\n		class=\"tribe-events-c-top-bar__datepicker-input tribe-common-a11y-visual-hide\"\n		data-js=\"tribe-events-top-bar-date\"\n		id=\"tribe-events-top-bar-date\"\n		name=\"tribe-events-views[tribe-bar-date]\"\n		value=\"2/20/2025\"\n		tabindex=\"-1\"\n		autocomplete=\"off\"\n		readonly=\"readonly\"\n	/>\n	<div class=\"tribe-events-c-top-bar__datepicker-container\" data-js=\"tribe-events-top-bar-datepicker-container\"></div>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-prev-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</template>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-next-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</template>\n</div>\n\n	<div class=\"tribe-events-c-top-bar__actions tribe-common-a11y-hidden\">\n	</div>\n\n</div>\n		</header>\n\n		\n		<div\n			class=\"tribe-events-calendar-month\"\n			role=\"grid\"\n			aria-labelledby=\"tribe-events-calendar-header\"\n			aria-readonly=\"true\"\n			data-js=\"tribe-events-month-grid\"\n		>\n\n			<header class=\"tribe-events-calendar-month__header\" role=\"rowgroup\">\n\n	<h2 class=\"tribe-common-a11y-visual-hide\" id=\"tribe-events-calendar-header\">\n		Calendar of Events	</h2>\n\n	<div role=\"row\" class=\"tribe-events-calendar-month__header-row\">\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Monday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						M					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Mon					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Tuesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Tue					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Wednesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						W					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Wed					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Thursday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Thu					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Friday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						F					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Fri					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Saturday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sat					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Sunday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sun					</span>\n				</h3>\n			</div>\n			</div>\n</header>\n\n			\n<div class=\"tribe-events-calendar-month__body\" role=\"rowgroup\">\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-29\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-29\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-29\"\n		>\n			29		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-29\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-29\"\n	>\n					29			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-30\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-30\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-30\"\n		>\n			30		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-30\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-30\"\n	>\n					30			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-31\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-31\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-31\"\n		>\n			31		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-31\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-31\"\n	>\n					31			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-07\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-7\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-07\"\n		>\n			7		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-07\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-07\"\n	>\n					7			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-08\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-8\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-08\"\n		>\n			8		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-08\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-08\"\n	>\n					8			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-09\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-9\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-09\"\n		>\n			9		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-09\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-09\"\n	>\n					9			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-10\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-10\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-10\"\n		>\n			10		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-10\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-10\"\n	>\n					10			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-11\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-11\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-11\"\n		>\n			11		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-11\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-11\"\n	>\n					11			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-12\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-12\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-12\"\n		>\n			12		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-12\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-12\"\n	>\n					12			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-13\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-13\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-13\"\n		>\n			13		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-13\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-13\"\n	>\n					13			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-14\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-14\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-14\"\n		>\n			14		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-14\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-14\"\n	>\n					14			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-15\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-15\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-15\"\n		>\n			15		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-15\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-15\"\n	>\n					15			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-16\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-16\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-16\"\n		>\n			16		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-16\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-16\"\n	>\n					16			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-17\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-17\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-17\"\n		>\n			17		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-17\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-17\"\n	>\n					17			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-18\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-18\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-18\"\n		>\n			18		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-18\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-18\"\n	>\n					18			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-19\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-19\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-19\"\n		>\n			19		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-19\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-19\"\n	>\n					19			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--current\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-20\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"true\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-20\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile tribe-events-calendar-month__day-cell--selected\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-20\"\n		>\n			20		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-20\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-20\"\n	>\n					20			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-21\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-21\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-21\"\n		>\n			21		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-21\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-21\"\n	>\n					21			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-22\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-22\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-22\"\n		>\n			22		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-22\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-22\"\n	>\n					22			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-23\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-23\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-23\"\n		>\n			23		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-23\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-23\"\n	>\n					23			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n</div>\n\n		</div>\n\n		<section class=\"tribe-events-calendar-month-mobile-events\" data-js=\"tribe-events-calendar-month-mobile-events\">\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-29\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-30\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-31\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-7\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-8\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-9\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-10\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-11\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-12\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-13\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-14\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-15\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-16\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-17\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-18\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-19\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day tribe-events-calendar-month-mobile-events__mobile-day--show\"  id=\"tribe-events-calendar-mobile-day-2025-02-20\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-21\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-22\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-23\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-24\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-25\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-26\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n	<nav class=\"tribe-events-calendar-month-nav tribe-events-c-nav\">\n	<ul class=\"tribe-events-c-nav__list\">\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--prev\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-01/\"\n		rel=\"prev\"\n		class=\"tribe-events-c-nav__prev tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Previous month, Jan\"\n		title=\"Previous month, Jan\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-nav__prev-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n		Jan	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--today\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/\"\n		class=\"tribe-events-c-nav__today tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Click to select the current month\"\n		title=\"Click to select the current month\"\n	>\n		This Month	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--next\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/2025-03/\"\n		rel=\"next\"\n		class=\"tribe-events-c-nav__next tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Next month, Mar\"\n		title=\"Next month, Mar\"\n		rel=\"noindex\"\n	>\n		Mar		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-nav__next-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n</section>\n\n		<div class=\"tribe-events-c-subscribe-dropdown__container\">\n	<div class=\"tribe-events-c-subscribe-dropdown\">\n		<div class=\"tribe-common-c-btn-border tribe-events-c-subscribe-dropdown__button\">\n			<button\n				class=\"tribe-events-c-subscribe-dropdown__button-text tribe-common-c-btn--clear\"\n				aria-expanded=\"false\"\n				aria-controls=\"tribe-events-subscribe-dropdown-content\"\n				aria-label=\"\"\n			>\n				Subscribe to calendar			</button>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-subscribe-dropdown__button-icon\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</div>\n		<div id=\"tribe-events-c-subscribe-dropdown-content\" class=\"tribe-events-c-subscribe-dropdown__content\">\n			<ul class=\"tribe-events-c-subscribe-dropdown__list\">\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://www.google.com/calendar/render?cid=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26ical%3D1%26eventDisplay%3Dlist\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Google Calendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"webcal://ikosz.hu/en/?post_type=tribe_events&#038;ical=1&#038;eventDisplay=list\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		iCalendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.office.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+Events+Archívált+-+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook 365	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.live.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2Fen%2F%3Fpost_type%3Dtribe_events%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+Events+Archívált+-+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook Live	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/?ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export .ics file	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/month/?outlook-ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export Outlook .ics file	</a>\n</li>\n							</ul>\n		</div>\n	</div>\n</div>\n\n		<div class=\"tribe-events-after-html\">\n	\n<!--\nThis calendar is powered by The Events Calendar.\nhttp://evnt.is/18wn\n-->\n</div>\n\n	</div>\n\n</div>\n\n<script class=\"tribe-events-breakpoints\">\n	( function () {\n		var completed = false;\n\n		function initBreakpoints() {\n			if ( completed ) {\n				// This was fired already and completed no need to attach to the event listener.\n				document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views.breakpoints ) {\n				return;\n			}\n\n			if ( \'function\' !== typeof (window.tribe.events.views.breakpoints.setup) ) {\n				return;\n			}\n\n			var container = document.querySelectorAll( \'[data-view-breakpoint-pointer=\"04ff8f40-2c89-4d05-8ac0-34b49f9e157f\"]\' );\n			if ( ! container ) {\n				return;\n			}\n\n			window.tribe.events.views.breakpoints.setup( container );\n			completed = true;\n			// This was fired already and completed no need to attach to the event listener.\n			document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n		}\n\n		// Try to init the breakpoints right away.\n		initBreakpoints();\n		document.addEventListener( \'DOMContentLoaded\', initBreakpoints );\n	})();\n</script>\n", "off");
INSERT INTO `wp_options` VALUES("488984", "_transient_timeout_tribe_views_v2_cache_df9c41d98cba:1739930717.7646_0", "1740173429", "off");
INSERT INTO `wp_options` VALUES("488985", "_transient_tribe_views_v2_cache_df9c41d98cba:1739930717.7646_0", "<div\n	 class=\"tribe-common tribe-events tribe-events-view tribe-events-view--month\" 	data-js=\"tribe-events-view\"\n	data-view-rest-nonce=\"\"\n	data-view-rest-url=\"https://ikosz.hu/wp-json/tribe/views/v2/html\"\n	data-view-rest-method=\"POST\"\n	data-view-manage-url=\"1\"\n				data-view-breakpoint-pointer=\"47f7a1f0-353e-42f4-925a-1b0b7b404366\"\n	>\n	<div class=\"tribe-common-l-container tribe-events-l-container\">\n		<div\n	class=\"tribe-events-view-loader tribe-common-a11y-hidden\"\n	role=\"alert\"\n	aria-live=\"polite\"\n>\n	<span class=\"tribe-events-view-loader__text tribe-common-a11y-visual-hide\">\n		35 events found.	</span>\n	<div class=\"tribe-events-view-loader__dots tribe-common-c-loader\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--first\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--second\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n	</div>\n</div>\n\n		\n		<script data-js=\"tribe-events-view-data\" type=\"application/json\">\n	{\"slug\":\"month\",\"prev_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/2025-01\\/\",\"next_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/2025-03\\/\",\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_slug\":\"month\",\"view_label\":\"Month\",\"title\":\"ikosz\",\"events\":{\"2025-01-27\":[],\"2025-01-28\":[],\"2025-01-29\":[],\"2025-01-30\":[],\"2025-01-31\":[],\"2025-02-01\":[],\"2025-02-02\":[],\"2025-02-03\":[],\"2025-02-04\":[],\"2025-02-05\":[],\"2025-02-06\":[],\"2025-02-07\":[],\"2025-02-08\":[],\"2025-02-09\":[],\"2025-02-10\":[],\"2025-02-11\":[],\"2025-02-12\":[],\"2025-02-13\":[],\"2025-02-14\":[],\"2025-02-15\":[],\"2025-02-16\":[],\"2025-02-17\":[],\"2025-02-18\":[],\"2025-02-19\":[],\"2025-02-20\":[],\"2025-02-21\":[],\"2025-02-22\":[],\"2025-02-23\":[],\"2025-02-24\":[],\"2025-02-25\":[],\"2025-02-26\":[],\"2025-02-27\":[],\"2025-02-28\":[],\"2025-03-01\":[],\"2025-03-02\":[]},\"url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/month\\/\",\"url_event_date\":false,\"bar\":{\"keyword\":\"\",\"date\":\"\"},\"today\":\"2025-02-20 00:00:00\",\"now\":\"2025-02-20 21:30:29\",\"rest_url\":\"https:\\/\\/ikosz.hu\\/wp-json\\/tribe\\/views\\/v2\\/html\",\"rest_method\":\"POST\",\"rest_nonce\":\"\",\"should_manage_url\":true,\"today_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/month\\/\",\"today_title\":\"Click to select the current month\",\"today_label\":\"This Month\",\"prev_label\":\"jan\",\"next_label\":\"m\\u00e1rc\",\"date_formats\":{\"compact\":\"n\\/j\\/Y\",\"month_and_year_compact\":\"n\\/Y\",\"month_and_year\":\"F Y\",\"time_range_separator\":\" - \",\"date_time_separator\":\" @ \"},\"messages\":{\"notice\":[\"Nincsenek k\\u00f6zelg\\u0151 esem\\u00e9nyek.\"]},\"start_of_week\":\"1\",\"header_title\":\"ingyenes\",\"header_title_element\":\"h1\",\"content_title\":\"\",\"breadcrumbs\":[{\"link\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/\",\"label\":\"Events\"},{\"link\":\"\",\"label\":\"ingyenes\"}],\"before_events\":\"\",\"after_events\":\"\\n<!--\\nThis calendar is powered by The Events Calendar.\\nhttp:\\/\\/evnt.is\\/18wn\\n-->\\n\",\"display_events_bar\":true,\"disable_event_search\":true,\"live_refresh\":true,\"ical\":{\"display_link\":true,\"link\":{\"url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/month\\/?ical=1\",\"text\":\"Export Events\",\"title\":\"Use this to share calendar data with Google Calendar, Apple iCal and other compatible apps\"}},\"container_classes\":[\"tribe-common\",\"tribe-events\",\"tribe-events-view\",\"tribe-events-view--month\"],\"container_data\":[],\"is_past\":false,\"breakpoints\":{\"xsmall\":500,\"medium\":768,\"full\":960},\"breakpoint_pointer\":\"47f7a1f0-353e-42f4-925a-1b0b7b404366\",\"is_initial_load\":true,\"public_views\":{\"list\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\List_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/list\\/\",\"view_label\":\"List\"},\"month\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/month\\/\",\"view_label\":\"Month\"},\"day\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Day_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/today\\/\",\"view_label\":\"Day\"}},\"show_latest_past\":true,\"today_date\":\"2025-02-20\",\"grid_date\":\"2025-02-20\",\"formatted_grid_date\":\"febru\\u00e1r 2025\",\"formatted_grid_date_mobile\":\"2\\/20\\/2025\",\"days\":{\"2025-01-27\":{\"date\":\"2025-01-27\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-01-27\\/\"},\"2025-01-28\":{\"date\":\"2025-01-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-01-28\\/\"},\"2025-01-29\":{\"date\":\"2025-01-29\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"29\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-01-29\\/\"},\"2025-01-30\":{\"date\":\"2025-01-30\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"30\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-01-30\\/\"},\"2025-01-31\":{\"date\":\"2025-01-31\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"31\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-01-31\\/\"},\"2025-02-01\":{\"date\":\"2025-02-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-01\\/\"},\"2025-02-02\":{\"date\":\"2025-02-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-02\\/\"},\"2025-02-03\":{\"date\":\"2025-02-03\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-03\\/\"},\"2025-02-04\":{\"date\":\"2025-02-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-04\\/\"},\"2025-02-05\":{\"date\":\"2025-02-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-05\\/\"},\"2025-02-06\":{\"date\":\"2025-02-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-06\\/\"},\"2025-02-07\":{\"date\":\"2025-02-07\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"7\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-07\\/\"},\"2025-02-08\":{\"date\":\"2025-02-08\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"8\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-08\\/\"},\"2025-02-09\":{\"date\":\"2025-02-09\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"9\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-09\\/\"},\"2025-02-10\":{\"date\":\"2025-02-10\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"10\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-10\\/\"},\"2025-02-11\":{\"date\":\"2025-02-11\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"11\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-11\\/\"},\"2025-02-12\":{\"date\":\"2025-02-12\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"12\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-12\\/\"},\"2025-02-13\":{\"date\":\"2025-02-13\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"13\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-13\\/\"},\"2025-02-14\":{\"date\":\"2025-02-14\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"14\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-14\\/\"},\"2025-02-15\":{\"date\":\"2025-02-15\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"15\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-15\\/\"},\"2025-02-16\":{\"date\":\"2025-02-16\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"16\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-16\\/\"},\"2025-02-17\":{\"date\":\"2025-02-17\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"17\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-17\\/\"},\"2025-02-18\":{\"date\":\"2025-02-18\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"18\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-18\\/\"},\"2025-02-19\":{\"date\":\"2025-02-19\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"19\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-19\\/\"},\"2025-02-20\":{\"date\":\"2025-02-20\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"20\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-20\\/\"},\"2025-02-21\":{\"date\":\"2025-02-21\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"21\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-21\\/\"},\"2025-02-22\":{\"date\":\"2025-02-22\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"22\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-22\\/\"},\"2025-02-23\":{\"date\":\"2025-02-23\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"23\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-23\\/\"},\"2025-02-24\":{\"date\":\"2025-02-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-24\\/\"},\"2025-02-25\":{\"date\":\"2025-02-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-25\\/\"},\"2025-02-26\":{\"date\":\"2025-02-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-26\\/\"},\"2025-02-27\":{\"date\":\"2025-02-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-27\\/\"},\"2025-02-28\":{\"date\":\"2025-02-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-02-28\\/\"},\"2025-03-01\":{\"date\":\"2025-03-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-03-01\\/\"},\"2025-03-02\":{\"date\":\"2025-03-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/esemenyek\\/category\\/free\\/day\\/2025-03-02\\/\"}},\"next_month\":\"3\",\"prev_month\":\"1\",\"next_rel\":\"noindex\",\"prev_rel\":\"noindex\",\"mobile_messages\":{\"notice\":{\"no-events-in-day\":\"There are no events on this day.\"}},\"grid_start_date\":\"2025-01-27\",\"subscribe_links\":{\"gcal\":{\"label\":\"Google Calendar\",\"single_label\":\"Add to Google Calendar\",\"visible\":true,\"block_slug\":\"hasGoogleCalendar\"},\"ical\":{\"label\":\"iCalendar\",\"single_label\":\"Add to iCalendar\",\"visible\":true,\"block_slug\":\"hasiCal\"},\"outlook-365\":{\"label\":\"Outlook 365\",\"single_label\":\"Outlook 365\",\"visible\":true,\"block_slug\":\"hasOutlook365\"},\"outlook-live\":{\"label\":\"Outlook Live\",\"single_label\":\"Outlook Live\",\"visible\":true,\"block_slug\":\"hasOutlookLive\"},\"ics\":{\"label\":\"Export .ics file\",\"single_label\":\"Export .ics file\",\"visible\":true,\"block_slug\":null},\"outlook-ics\":{\"label\":\"Export Outlook .ics file\",\"single_label\":\"Export Outlook .ics file\",\"visible\":true,\"block_slug\":null}},\"_context\":{\"slug\":\"month\"},\"text\":\"Loading...\",\"classes\":[\"tribe-common-c-loader__dot\",\"tribe-common-c-loader__dot--third\"]}</script>\n\n		\n		<header  class=\"tribe-events-header\" >\n			<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"0\" 					>\n					Nincsenek közelgő események.					</li>\n							</ul>\n		</div>\n	</div>\n\n			<div class=\"tribe-events-header__breadcrumbs tribe-events-c-breadcrumbs\">\n	<ol class=\"tribe-events-c-breadcrumbs__list\">\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/\"\n		class=\"tribe-events-c-breadcrumbs__list-item-link tribe-common-anchor\"\n		title=\"\"\n		data-js=\"tribe-events-view-link\"\n	>\n		Events	</a>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<span class=\"tribe-events-c-breadcrumbs__list-item-text\">\n		ingyenes	</span>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n			</ol>\n</div>\n\n			<div\n	 class=\"tribe-events-header__events-bar tribe-events-c-events-bar\" 	data-js=\"tribe-events-events-bar\"\n>\n\n	<h2 class=\"tribe-common-a11y-visual-hide\">\n		Views Navigation	</h2>\n\n	\n	<div class=\"tribe-events-c-events-bar__views\">\n	<h3 class=\"tribe-common-a11y-visual-hide\">\n		Event Views Navigation	</h3>\n	<div  class=\"tribe-events-c-view-selector\"  data-js=\"tribe-events-view-selector\">\n		<button\n			class=\"tribe-events-c-view-selector__button tribe-common-c-btn__clear\"\n			data-js=\"tribe-events-view-selector-button\"\n		>\n			<span class=\"tribe-events-c-view-selector__button-icon\">\n				<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__button-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>			</span>\n			<span class=\"tribe-events-c-view-selector__button-text tribe-common-a11y-visual-hide\">\n				Month			</span>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-view-selector__button-icon-caret-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</button>\n		<div\n	class=\"tribe-events-c-view-selector__content\"\n	id=\"tribe-events-view-selector-content\"\n	data-js=\"tribe-events-view-selector-list-container\"\n>\n	<ul class=\"tribe-events-c-view-selector__list\">\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--list\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/list/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--list tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.451.432V17.6c0 .238.163.432.364.432H18.12c.2 0 .364-.194.364-.432V.432c0-.239-.163-.432-.364-.432H.815c-.2 0-.364.193-.364.432zm.993.81h16.024V3.56H1.444V1.24zM17.468 3.56H1.444v13.227h16.024V3.56z\" class=\"tribe-common-c-svgicon__svg-fill\"/><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-0)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 4.912v1.825c0 .504.409.913.913.913h1.825a.913.913 0 00.912-.913V4.912A.913.913 0 0014.57 4h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 7.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 5.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-1)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 10.912v1.825c0 .505.409.913.913.913h1.825a.913.913 0 00.912-.912v-1.825A.913.913 0 0014.57 10h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 13.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 11.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><defs><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-0\"><path transform=\"translate(3.451 4)\" d=\"M0 0h13v4H0z\"/></clipPath><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-1\"><path transform=\"translate(3.451 10)\" d=\"M0 0h13v4H0z\"/></clipPath></defs></svg>\n		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			List		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--month tribe-events-c-view-selector__list-item--active\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/month/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Month		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--day\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/today/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--day tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 18\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.363 17.569V.43C.363.193.526 0 .726 0H18c.201 0 .364.193.364.431V17.57c0 .238-.163.431-.364.431H.726c-.2 0-.363-.193-.363-.431zm16.985-16.33H1.354v2.314h15.994V1.24zM1.354 4.688h15.994v12.07H1.354V4.687zm11.164 9.265v-1.498c0-.413.335-.748.748-.748h1.498c.413 0 .748.335.748.748v1.498a.749.749 0 01-.748.748h-1.498a.749.749 0 01-.748-.748z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Day		</span>\n	</a>\n</li>\n			</ul>\n</div>\n	</div>\n</div>\n\n</div>\n\n			<div class=\"tribe-events-c-top-bar tribe-events-header__top-bar\">\n\n	<nav class=\"tribe-events-c-top-bar__nav tribe-common-a11y-hidden\">\n	<ul class=\"tribe-events-c-top-bar__nav-list\">\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/2025-01/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-left tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--prev\"\n		aria-label=\"Previous month\"\n		title=\"Previous month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</a>\n</li>\n\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/2025-03/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-right tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--next\"\n		aria-label=\"Next month\"\n		title=\"Next month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n	<a\n	href=\"https://ikosz.hu/esemenyek/category/free/month/\"\n	class=\"tribe-common-c-btn-border-small tribe-events-c-top-bar__today-button tribe-common-a11y-hidden\"\n	data-js=\"tribe-events-view-link\"\n	aria-label=\"Click to select the current month\"\n	title=\"Click to select the current month\"\n>\n	This Month</a>\n\n	<div class=\"tribe-events-c-top-bar__datepicker\">\n	<button\n		class=\"tribe-common-c-btn__clear tribe-common-h3 tribe-common-h--alt tribe-events-c-top-bar__datepicker-button\"\n		data-js=\"tribe-events-top-bar-datepicker-button\"\n		type=\"button\"\n		aria-label=\"Click to toggle datepicker\"\n		title=\"Click to toggle datepicker\"\n	>\n		<time\n			datetime=\"2025-02\"\n			class=\"tribe-events-c-top-bar__datepicker-time\"\n		>\n			<span class=\"tribe-events-c-top-bar__datepicker-mobile\">\n				2/20/2025			</span>\n			<span class=\"tribe-events-c-top-bar__datepicker-desktop tribe-common-a11y-hidden\">\n				február 2025			</span>\n		</time>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-top-bar__datepicker-button-icon-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n	</button>\n	<label\n		class=\"tribe-events-c-top-bar__datepicker-label tribe-common-a11y-visual-hide\"\n		for=\"tribe-events-top-bar-date\"\n	>\n		Select date.	</label>\n	<input\n		type=\"text\"\n		class=\"tribe-events-c-top-bar__datepicker-input tribe-common-a11y-visual-hide\"\n		data-js=\"tribe-events-top-bar-date\"\n		id=\"tribe-events-top-bar-date\"\n		name=\"tribe-events-views[tribe-bar-date]\"\n		value=\"2/20/2025\"\n		tabindex=\"-1\"\n		autocomplete=\"off\"\n		readonly=\"readonly\"\n	/>\n	<div class=\"tribe-events-c-top-bar__datepicker-container\" data-js=\"tribe-events-top-bar-datepicker-container\"></div>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-prev-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</template>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-next-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</template>\n</div>\n\n	<div class=\"tribe-events-c-top-bar__actions tribe-common-a11y-hidden\">\n	</div>\n\n</div>\n		</header>\n\n		\n		<div\n			class=\"tribe-events-calendar-month\"\n			role=\"grid\"\n			aria-labelledby=\"tribe-events-calendar-header\"\n			aria-readonly=\"true\"\n			data-js=\"tribe-events-month-grid\"\n		>\n\n			<header class=\"tribe-events-calendar-month__header\" role=\"rowgroup\">\n\n	<h2 class=\"tribe-common-a11y-visual-hide\" id=\"tribe-events-calendar-header\">\n		Calendar of Events	</h2>\n\n	<div role=\"row\" class=\"tribe-events-calendar-month__header-row\">\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"hétfő\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						h					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						hét					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"kedd\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						K					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						ked					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"szerda\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						s					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						sze					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"csütörtök\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						c					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						csü					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"péntek\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						p					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						pén					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"szombat\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						s					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						szo					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"vasárnap\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						v					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						vas					</span>\n				</h3>\n			</div>\n			</div>\n</header>\n\n			\n<div class=\"tribe-events-calendar-month__body\" role=\"rowgroup\">\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-29\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-29\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-29\"\n		>\n			29		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-29\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-29\"\n	>\n					29			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-30\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-30\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-30\"\n		>\n			30		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-30\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-30\"\n	>\n					30			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-31\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-31\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-31\"\n		>\n			31		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-31\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-31\"\n	>\n					31			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-07\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-7\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-07\"\n		>\n			7		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-07\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-07\"\n	>\n					7			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-08\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-8\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-08\"\n		>\n			8		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-08\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-08\"\n	>\n					8			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-09\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-9\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-09\"\n		>\n			9		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-09\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-09\"\n	>\n					9			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-10\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-10\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-10\"\n		>\n			10		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-10\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-10\"\n	>\n					10			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-11\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-11\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-11\"\n		>\n			11		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-11\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-11\"\n	>\n					11			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-12\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-12\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-12\"\n		>\n			12		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-12\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-12\"\n	>\n					12			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-13\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-13\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-13\"\n		>\n			13		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-13\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-13\"\n	>\n					13			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-14\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-14\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-14\"\n		>\n			14		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-14\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-14\"\n	>\n					14			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-15\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-15\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-15\"\n		>\n			15		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-15\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-15\"\n	>\n					15			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-16\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-16\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-16\"\n		>\n			16		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-16\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-16\"\n	>\n					16			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-17\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-17\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-17\"\n		>\n			17		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-17\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-17\"\n	>\n					17			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-18\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-18\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-18\"\n		>\n			18		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-18\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-18\"\n	>\n					18			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-19\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-19\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-19\"\n		>\n			19		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-19\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-19\"\n	>\n					19			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--current\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-20\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"true\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-20\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile tribe-events-calendar-month__day-cell--selected\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-20\"\n		>\n			20		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-20\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-20\"\n	>\n					20			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-21\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-21\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-21\"\n		>\n			21		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-21\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-21\"\n	>\n					21			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-22\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-22\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-22\"\n		>\n			22		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-22\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-22\"\n	>\n					22			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-23\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-23\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-23\"\n		>\n			23		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-23\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-23\"\n	>\n					23			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n</div>\n\n		</div>\n\n		<section class=\"tribe-events-calendar-month-mobile-events\" data-js=\"tribe-events-calendar-month-mobile-events\">\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-29\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-30\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-31\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-7\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-8\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-9\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-10\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-11\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-12\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-13\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-14\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-15\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-16\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-17\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-18\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-19\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day tribe-events-calendar-month-mobile-events__mobile-day--show\"  id=\"tribe-events-calendar-mobile-day-2025-02-20\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-21\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-22\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-23\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-24\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-25\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-26\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-03-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n	<nav class=\"tribe-events-calendar-month-nav tribe-events-c-nav\">\n	<ul class=\"tribe-events-c-nav__list\">\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--prev\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/2025-01/\"\n		rel=\"prev\"\n		class=\"tribe-events-c-nav__prev tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Previous month, jan\"\n		title=\"Previous month, jan\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-nav__prev-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n		jan	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--today\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/month/\"\n		class=\"tribe-events-c-nav__today tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Click to select the current month\"\n		title=\"Click to select the current month\"\n	>\n		This Month	</a>\n</li>\n\n		<li class=\"tribe-events-c-nav__list-item tribe-events-c-nav__list-item--next\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/2025-03/\"\n		rel=\"next\"\n		class=\"tribe-events-c-nav__next tribe-common-b2\"\n		data-js=\"tribe-events-view-link\"\n		aria-label=\"Next month, márc\"\n		title=\"Next month, márc\"\n		rel=\"noindex\"\n	>\n		márc		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-nav__next-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n</section>\n\n		<div class=\"tribe-events-c-subscribe-dropdown__container\">\n	<div class=\"tribe-events-c-subscribe-dropdown\">\n		<div class=\"tribe-common-c-btn-border tribe-events-c-subscribe-dropdown__button\">\n			<button\n				class=\"tribe-events-c-subscribe-dropdown__button-text tribe-common-c-btn--clear\"\n				aria-expanded=\"false\"\n				aria-controls=\"tribe-events-subscribe-dropdown-content\"\n				aria-label=\"\"\n			>\n				Subscribe to calendar			</button>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-subscribe-dropdown__button-icon\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</div>\n		<div id=\"tribe-events-c-subscribe-dropdown-content\" class=\"tribe-events-c-subscribe-dropdown__content\">\n			<ul class=\"tribe-events-c-subscribe-dropdown__list\">\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://www.google.com/calendar/render?cid=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Dfree%26ical%3D1%26eventDisplay%3Dlist\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Google Calendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"webcal://ikosz.hu/?post_type=tribe_events&#038;tribe_events_cat=free&#038;ical=1&#038;eventDisplay=list\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		iCalendar	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.office.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Dfree%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook 365	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://outlook.live.com/owa?path=/calendar/action/compose&#038;rru=addsubscription&#038;url=webcal%3A%2F%2Fikosz.hu%2F%3Fpost_type%3Dtribe_events%26tribe_events_cat%3Dfree%26ical%3D1%26eventDisplay%3Dlist&#038;name=ikosz+ikosz\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Outlook Live	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/month/?ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export .ics file	</a>\n</li>\n									\n<li class=\"tribe-events-c-subscribe-dropdown__list-item\">\n	<a\n		href=\"https://ikosz.hu/esemenyek/category/free/month/?outlook-ical=1\"\n		class=\"tribe-events-c-subscribe-dropdown__list-item-link\"\n		target=\"_blank\"\n		rel=\"noopener noreferrer nofollow noindex\"\n	>\n		Export Outlook .ics file	</a>\n</li>\n							</ul>\n		</div>\n	</div>\n</div>\n\n		<div class=\"tribe-events-after-html\">\n	\n<!--\nThis calendar is powered by The Events Calendar.\nhttp://evnt.is/18wn\n-->\n</div>\n\n	</div>\n\n</div>\n\n<script class=\"tribe-events-breakpoints\">\n	( function () {\n		var completed = false;\n\n		function initBreakpoints() {\n			if ( completed ) {\n				// This was fired already and completed no need to attach to the event listener.\n				document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views ) {\n				return;\n			}\n\n			if ( \'undefined\' === typeof window.tribe.events.views.breakpoints ) {\n				return;\n			}\n\n			if ( \'function\' !== typeof (window.tribe.events.views.breakpoints.setup) ) {\n				return;\n			}\n\n			var container = document.querySelectorAll( \'[data-view-breakpoint-pointer=\"47f7a1f0-353e-42f4-925a-1b0b7b404366\"]\' );\n			if ( ! container ) {\n				return;\n			}\n\n			window.tribe.events.views.breakpoints.setup( container );\n			completed = true;\n			// This was fired already and completed no need to attach to the event listener.\n			document.removeEventListener( \'DOMContentLoaded\', initBreakpoints );\n		}\n\n		// Try to init the breakpoints right away.\n		initBreakpoints();\n		document.addEventListener( \'DOMContentLoaded\', initBreakpoints );\n	})();\n</script>\n", "off");
INSERT INTO `wp_options` VALUES("489168", "_transient_timeout_tribe_views_v2_cache_bc049acf7eb1:1739930717.7646_0", "1740183086", "off");
INSERT INTO `wp_options` VALUES("489169", "_transient_tribe_views_v2_cache_bc049acf7eb1:1739930717.7646_0", "<div\n	 class=\"tribe-common tribe-events tribe-events-view tribe-events-view--month\" 	data-js=\"tribe-events-view\"\n	data-view-rest-nonce=\"\"\n	data-view-rest-url=\"https://ikosz.hu/en/wp-json/tribe/views/v2/html\"\n	data-view-rest-method=\"POST\"\n	data-view-manage-url=\"1\"\n				data-view-breakpoint-pointer=\"8816717b-d442-48cc-8d4a-86d55dc47739\"\n	>\n	<div class=\"tribe-common-l-container tribe-events-l-container\">\n		<div\n	class=\"tribe-events-view-loader tribe-common-a11y-hidden\"\n	role=\"alert\"\n	aria-live=\"polite\"\n>\n	<span class=\"tribe-events-view-loader__text tribe-common-a11y-visual-hide\">\n		35 events found.	</span>\n	<div class=\"tribe-events-view-loader__dots tribe-common-c-loader\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--first\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--second\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--dot tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  viewBox=\"0 0 15 15\" xmlns=\"http://www.w3.org/2000/svg\"><circle cx=\"7.5\" cy=\"7.5\" r=\"7.5\"/></svg>\n	</div>\n</div>\n\n		\n		<script data-js=\"tribe-events-view-data\" type=\"application/json\">\n	{\"slug\":\"month\",\"prev_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/2025-01\\/\",\"next_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/2025-03\\/\",\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_slug\":\"month\",\"view_label\":\"Month\",\"title\":\"ikosz\",\"events\":{\"2025-01-27\":[],\"2025-01-28\":[],\"2025-01-29\":[],\"2025-01-30\":[],\"2025-01-31\":[],\"2025-02-01\":[],\"2025-02-02\":[],\"2025-02-03\":[],\"2025-02-04\":[],\"2025-02-05\":[],\"2025-02-06\":[],\"2025-02-07\":[],\"2025-02-08\":[],\"2025-02-09\":[],\"2025-02-10\":[],\"2025-02-11\":[],\"2025-02-12\":[],\"2025-02-13\":[],\"2025-02-14\":[],\"2025-02-15\":[],\"2025-02-16\":[],\"2025-02-17\":[],\"2025-02-18\":[],\"2025-02-19\":[],\"2025-02-20\":[],\"2025-02-21\":[],\"2025-02-22\":[],\"2025-02-23\":[],\"2025-02-24\":[],\"2025-02-25\":[],\"2025-02-26\":[],\"2025-02-27\":[],\"2025-02-28\":[],\"2025-03-01\":[],\"2025-03-02\":[]},\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/month\\/\",\"url_event_date\":false,\"bar\":{\"keyword\":\"\",\"date\":\"\"},\"today\":\"2025-02-21 00:00:00\",\"now\":\"2025-02-21 00:11:26\",\"rest_url\":\"https:\\/\\/ikosz.hu\\/en\\/wp-json\\/tribe\\/views\\/v2\\/html\",\"rest_method\":\"POST\",\"rest_nonce\":\"\",\"should_manage_url\":true,\"today_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/month\\/\",\"today_title\":\"Click to select the current month\",\"today_label\":\"This Month\",\"prev_label\":\"Jan\",\"next_label\":\"Mar\",\"date_formats\":{\"compact\":\"n\\/j\\/Y\",\"month_and_year_compact\":\"n\\/Y\",\"month_and_year\":\"F Y\",\"time_range_separator\":\" - \",\"date_time_separator\":\" @ \"},\"messages\":{\"notice\":[\"There are no upcoming events.\"]},\"start_of_week\":\"1\",\"header_title\":\"outside\",\"header_title_element\":\"h1\",\"content_title\":\"\",\"breadcrumbs\":[{\"link\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/\",\"label\":\"Events\"},{\"link\":\"\",\"label\":\"outside\"}],\"before_events\":\"\",\"after_events\":\"\\n<!--\\nThis calendar is powered by The Events Calendar.\\nhttp:\\/\\/evnt.is\\/18wn\\n-->\\n\",\"display_events_bar\":true,\"disable_event_search\":true,\"live_refresh\":true,\"ical\":{\"display_link\":true,\"link\":{\"url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/month\\/?ical=1\",\"text\":\"Export Events\",\"title\":\"Use this to share calendar data with Google Calendar, Apple iCal and other compatible apps\"}},\"container_classes\":[\"tribe-common\",\"tribe-events\",\"tribe-events-view\",\"tribe-events-view--month\"],\"container_data\":[],\"is_past\":false,\"breakpoints\":{\"xsmall\":500,\"medium\":768,\"full\":960},\"breakpoint_pointer\":\"8816717b-d442-48cc-8d4a-86d55dc47739\",\"is_initial_load\":true,\"public_views\":{\"list\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\List_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/list\\/\",\"view_label\":\"List\"},\"month\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Month_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/month\\/\",\"view_label\":\"Month\"},\"day\":{\"view_class\":\"Tribe\\\\Events\\\\Views\\\\V2\\\\Views\\\\Day_View\",\"view_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/today\\/\",\"view_label\":\"Day\"}},\"show_latest_past\":true,\"today_date\":\"2025-02-21\",\"grid_date\":\"2025-02-21\",\"formatted_grid_date\":\"February 2025\",\"formatted_grid_date_mobile\":\"2\\/21\\/2025\",\"days\":{\"2025-01-27\":{\"date\":\"2025-01-27\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-01-27\\/\"},\"2025-01-28\":{\"date\":\"2025-01-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-01-28\\/\"},\"2025-01-29\":{\"date\":\"2025-01-29\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"29\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-01-29\\/\"},\"2025-01-30\":{\"date\":\"2025-01-30\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"30\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-01-30\\/\"},\"2025-01-31\":{\"date\":\"2025-01-31\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"01\",\"day_number\":\"31\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-01-31\\/\"},\"2025-02-01\":{\"date\":\"2025-02-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-01\\/\"},\"2025-02-02\":{\"date\":\"2025-02-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-02\\/\"},\"2025-02-03\":{\"date\":\"2025-02-03\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"3\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-03\\/\"},\"2025-02-04\":{\"date\":\"2025-02-04\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"4\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-04\\/\"},\"2025-02-05\":{\"date\":\"2025-02-05\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"5\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-05\\/\"},\"2025-02-06\":{\"date\":\"2025-02-06\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"6\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-06\\/\"},\"2025-02-07\":{\"date\":\"2025-02-07\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"7\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-07\\/\"},\"2025-02-08\":{\"date\":\"2025-02-08\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"8\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-08\\/\"},\"2025-02-09\":{\"date\":\"2025-02-09\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"9\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-09\\/\"},\"2025-02-10\":{\"date\":\"2025-02-10\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"10\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-10\\/\"},\"2025-02-11\":{\"date\":\"2025-02-11\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"11\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-11\\/\"},\"2025-02-12\":{\"date\":\"2025-02-12\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"12\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-12\\/\"},\"2025-02-13\":{\"date\":\"2025-02-13\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"13\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-13\\/\"},\"2025-02-14\":{\"date\":\"2025-02-14\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"14\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-14\\/\"},\"2025-02-15\":{\"date\":\"2025-02-15\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"15\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-15\\/\"},\"2025-02-16\":{\"date\":\"2025-02-16\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"16\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-16\\/\"},\"2025-02-17\":{\"date\":\"2025-02-17\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"17\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-17\\/\"},\"2025-02-18\":{\"date\":\"2025-02-18\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"18\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-18\\/\"},\"2025-02-19\":{\"date\":\"2025-02-19\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"19\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-19\\/\"},\"2025-02-20\":{\"date\":\"2025-02-20\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"20\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-20\\/\"},\"2025-02-21\":{\"date\":\"2025-02-21\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"21\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-21\\/\"},\"2025-02-22\":{\"date\":\"2025-02-22\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"22\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-22\\/\"},\"2025-02-23\":{\"date\":\"2025-02-23\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"23\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-23\\/\"},\"2025-02-24\":{\"date\":\"2025-02-24\",\"is_start_of_week\":true,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"24\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-24\\/\"},\"2025-02-25\":{\"date\":\"2025-02-25\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"25\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-25\\/\"},\"2025-02-26\":{\"date\":\"2025-02-26\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"26\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-26\\/\"},\"2025-02-27\":{\"date\":\"2025-02-27\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"27\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-27\\/\"},\"2025-02-28\":{\"date\":\"2025-02-28\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"02\",\"day_number\":\"28\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-02-28\\/\"},\"2025-03-01\":{\"date\":\"2025-03-01\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"1\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-03-01\\/\"},\"2025-03-02\":{\"date\":\"2025-03-02\",\"is_start_of_week\":false,\"year_number\":\"2025\",\"month_number\":\"03\",\"day_number\":\"2\",\"events\":[],\"featured_events\":[],\"multiday_events\":[],\"found_events\":0,\"more_events\":0,\"day_url\":\"https:\\/\\/ikosz.hu\\/en\\/esemenyek\\/category\\/outside\\/day\\/2025-03-02\\/\"}},\"next_month\":\"3\",\"prev_month\":\"1\",\"next_rel\":\"noindex\",\"prev_rel\":\"noindex\",\"mobile_messages\":{\"notice\":{\"no-events-in-day\":\"There are no events on this day.\"}},\"grid_start_date\":\"2025-01-27\",\"subscribe_links\":{\"gcal\":{\"label\":\"Google Calendar\",\"single_label\":\"Add to Google Calendar\",\"visible\":true,\"block_slug\":\"hasGoogleCalendar\"},\"ical\":{\"label\":\"iCalendar\",\"single_label\":\"Add to iCalendar\",\"visible\":true,\"block_slug\":\"hasiCal\"},\"outlook-365\":{\"label\":\"Outlook 365\",\"single_label\":\"Outlook 365\",\"visible\":true,\"block_slug\":\"hasOutlook365\"},\"outlook-live\":{\"label\":\"Outlook Live\",\"single_label\":\"Outlook Live\",\"visible\":true,\"block_slug\":\"hasOutlookLive\"},\"ics\":{\"label\":\"Export .ics file\",\"single_label\":\"Export .ics file\",\"visible\":true,\"block_slug\":null},\"outlook-ics\":{\"label\":\"Export Outlook .ics file\",\"single_label\":\"Export Outlook .ics file\",\"visible\":true,\"block_slug\":null}},\"_context\":{\"slug\":\"month\"},\"text\":\"Loading...\",\"classes\":[\"tribe-common-c-loader__dot\",\"tribe-common-c-loader__dot--third\"]}</script>\n\n		\n		<header  class=\"tribe-events-header\" >\n			<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-common-c-loader__dot tribe-common-c-loader__dot--third\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"0\" 					>\n					There are no upcoming events.					</li>\n							</ul>\n		</div>\n	</div>\n\n			<div class=\"tribe-events-header__breadcrumbs tribe-events-c-breadcrumbs\">\n	<ol class=\"tribe-events-c-breadcrumbs__list\">\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/\"\n		class=\"tribe-events-c-breadcrumbs__list-item-link tribe-common-anchor\"\n		title=\"\"\n		data-js=\"tribe-events-view-link\"\n	>\n		Events	</a>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n		\n							<li class=\"tribe-events-c-breadcrumbs__list-item\">\n	<span class=\"tribe-events-c-breadcrumbs__list-item-text\">\n		outside	</span>\n	<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-breadcrumbs__list-item-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n</li>\n			\n			</ol>\n</div>\n\n			<div\n	 class=\"tribe-events-header__events-bar tribe-events-c-events-bar\" 	data-js=\"tribe-events-events-bar\"\n>\n\n	<h2 class=\"tribe-common-a11y-visual-hide\">\n		Views Navigation	</h2>\n\n	\n	<div class=\"tribe-events-c-events-bar__views\">\n	<h3 class=\"tribe-common-a11y-visual-hide\">\n		Event Views Navigation	</h3>\n	<div  class=\"tribe-events-c-view-selector\"  data-js=\"tribe-events-view-selector\">\n		<button\n			class=\"tribe-events-c-view-selector__button tribe-common-c-btn__clear\"\n			data-js=\"tribe-events-view-selector-button\"\n		>\n			<span class=\"tribe-events-c-view-selector__button-icon\">\n				<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__button-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>			</span>\n			<span class=\"tribe-events-c-view-selector__button-text tribe-common-a11y-visual-hide\">\n				Month			</span>\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-view-selector__button-icon-caret-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n		</button>\n		<div\n	class=\"tribe-events-c-view-selector__content\"\n	id=\"tribe-events-view-selector-content\"\n	data-js=\"tribe-events-view-selector-list-container\"\n>\n	<ul class=\"tribe-events-c-view-selector__list\">\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--list\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/category/outside/list/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--list tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.451.432V17.6c0 .238.163.432.364.432H18.12c.2 0 .364-.194.364-.432V.432c0-.239-.163-.432-.364-.432H.815c-.2 0-.364.193-.364.432zm.993.81h16.024V3.56H1.444V1.24zM17.468 3.56H1.444v13.227h16.024V3.56z\" class=\"tribe-common-c-svgicon__svg-fill\"/><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-0)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 4.912v1.825c0 .504.409.913.913.913h1.825a.913.913 0 00.912-.913V4.912A.913.913 0 0014.57 4h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 7.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 5.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><g clip-path=\"url(#tribe-events-c-view-selector__list-item-icon-svg-1)\" class=\"tribe-common-c-svgicon__svg-fill\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M11.831 10.912v1.825c0 .505.409.913.913.913h1.825a.913.913 0 00.912-.912v-1.825A.913.913 0 0014.57 10h-1.825a.912.912 0 00-.913.912z\"/><path d=\"M8.028 13.66a.449.449 0 00.446-.448v-.364c0-.246-.2-.448-.446-.448h-4.13a.449.449 0 00-.447.448v.364c0 .246.201.448.447.448h4.13zM9.797 11.26a.449.449 0 00.447-.448v-.364c0-.246-.201-.448-.447-.448h-5.9a.449.449 0 00-.446.448v.364c0 .246.201.448.447.448h5.9z\"/></g><defs><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-0\"><path transform=\"translate(3.451 4)\" d=\"M0 0h13v4H0z\"/></clipPath><clipPath id=\"tribe-events-c-view-selector__list-item-icon-svg-1\"><path transform=\"translate(3.451 10)\" d=\"M0 0h13v4H0z\"/></clipPath></defs></svg>\n		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			List		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--month tribe-events-c-view-selector__list-item--active\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/category/outside/month/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--month tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 18 19\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M0 .991v17.04c0 .236.162.428.361.428h17.175c.2 0 .361-.192.361-.429V.991c0-.237-.162-.428-.361-.428H.36C.161.563 0 .754 0 .99zm.985.803H16.89v2.301H.985v-2.3zM16.89 5.223H.985v12H16.89v-12zM6.31 7.366v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429zm3.428-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429h-.857a.429.429 0 00-.429.429zm-6.857 4.286v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428H6.74a.429.429 0 01-.429-.428zm3.429-.858v.858c0 .236.191.428.428.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.428.428 0 00-.428.428zm3.428.858v-.858c0-.236.192-.428.429-.428h.857c.236 0 .428.192.428.428v.858a.429.429 0 01-.428.428h-.857a.429.429 0 01-.429-.428zm-10.286-.858v.858c0 .236.192.428.429.428h.857a.429.429 0 00.429-.428v-.858a.429.429 0 00-.429-.428h-.857a.429.429 0 00-.429.428zm0 4.286v-.857c0-.237.192-.429.429-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.429-.429zm3.429-.857v.857c0 .237.192.429.429.429h.857a.429.429 0 00.428-.429v-.857a.429.429 0 00-.428-.429H6.74a.429.429 0 00-.429.429zm3.429.857v-.857c0-.237.191-.429.428-.429h.857c.237 0 .429.192.429.429v.857a.429.429 0 01-.429.429h-.857a.429.429 0 01-.428-.429z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Month		</span>\n	</a>\n</li>\n					<li class=\"tribe-events-c-view-selector__list-item tribe-events-c-view-selector__list-item--day\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/category/outside/today/\"\n		class=\"tribe-events-c-view-selector__list-item-link\"\n		data-js=\"tribe-events-view-link\"\n	>\n		<span class=\"tribe-events-c-view-selector__list-item-icon\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--day tribe-events-c-view-selector__list-item-icon-svg\"  viewBox=\"0 0 19 18\" xmlns=\"http://www.w3.org/2000/svg\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M.363 17.569V.43C.363.193.526 0 .726 0H18c.201 0 .364.193.364.431V17.57c0 .238-.163.431-.364.431H.726c-.2 0-.363-.193-.363-.431zm16.985-16.33H1.354v2.314h15.994V1.24zM1.354 4.688h15.994v12.07H1.354V4.687zm11.164 9.265v-1.498c0-.413.335-.748.748-.748h1.498c.413 0 .748.335.748.748v1.498a.749.749 0 01-.748.748h-1.498a.749.749 0 01-.748-.748z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>		</span>\n		<span class=\"tribe-events-c-view-selector__list-item-text\">\n			Day		</span>\n	</a>\n</li>\n			</ul>\n</div>\n	</div>\n</div>\n\n</div>\n\n			<div class=\"tribe-events-c-top-bar tribe-events-header__top-bar\">\n\n	<nav class=\"tribe-events-c-top-bar__nav tribe-common-a11y-hidden\">\n	<ul class=\"tribe-events-c-top-bar__nav-list\">\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/category/outside/2025-01/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-left tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--prev\"\n		aria-label=\"Previous month\"\n		title=\"Previous month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</a>\n</li>\n\n		<li class=\"tribe-events-c-top-bar__nav-list-item\">\n	<a\n		href=\"https://ikosz.hu/en/esemenyek/category/outside/2025-03/\"\n		class=\"tribe-common-c-btn-icon tribe-common-c-btn-icon--caret-right tribe-events-c-top-bar__nav-link tribe-events-c-top-bar__nav-link--next\"\n		aria-label=\"Next month\"\n		title=\"Next month\"\n		data-js=\"tribe-events-view-link\"\n		rel=\"noindex\"\n	>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-common-c-btn-icon__icon-svg tribe-events-c-top-bar__nav-link-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</a>\n</li>\n	</ul>\n</nav>\n\n	<a\n	href=\"https://ikosz.hu/en/esemenyek/category/outside/month/\"\n	class=\"tribe-common-c-btn-border-small tribe-events-c-top-bar__today-button tribe-common-a11y-hidden\"\n	data-js=\"tribe-events-view-link\"\n	aria-label=\"Click to select the current month\"\n	title=\"Click to select the current month\"\n>\n	This Month</a>\n\n	<div class=\"tribe-events-c-top-bar__datepicker\">\n	<button\n		class=\"tribe-common-c-btn__clear tribe-common-h3 tribe-common-h--alt tribe-events-c-top-bar__datepicker-button\"\n		data-js=\"tribe-events-top-bar-datepicker-button\"\n		type=\"button\"\n		aria-label=\"Click to toggle datepicker\"\n		title=\"Click to toggle datepicker\"\n	>\n		<time\n			datetime=\"2025-02\"\n			class=\"tribe-events-c-top-bar__datepicker-time\"\n		>\n			<span class=\"tribe-events-c-top-bar__datepicker-mobile\">\n				2/21/2025			</span>\n			<span class=\"tribe-events-c-top-bar__datepicker-desktop tribe-common-a11y-hidden\">\n				February 2025			</span>\n		</time>\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-down tribe-events-c-top-bar__datepicker-button-icon-svg\"  viewBox=\"0 0 10 7\" xmlns=\"http://www.w3.org/2000/svg\" aria-hidden=\"true\"><path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M1.008.609L5 4.6 8.992.61l.958.958L5 6.517.05 1.566l.958-.958z\" class=\"tribe-common-c-svgicon__svg-fill\"/></svg>\n	</button>\n	<label\n		class=\"tribe-events-c-top-bar__datepicker-label tribe-common-a11y-visual-hide\"\n		for=\"tribe-events-top-bar-date\"\n	>\n		Select date.	</label>\n	<input\n		type=\"text\"\n		class=\"tribe-events-c-top-bar__datepicker-input tribe-common-a11y-visual-hide\"\n		data-js=\"tribe-events-top-bar-date\"\n		id=\"tribe-events-top-bar-date\"\n		name=\"tribe-events-views[tribe-bar-date]\"\n		value=\"2/21/2025\"\n		tabindex=\"-1\"\n		autocomplete=\"off\"\n		readonly=\"readonly\"\n	/>\n	<div class=\"tribe-events-c-top-bar__datepicker-container\" data-js=\"tribe-events-top-bar-datepicker-container\"></div>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-prev-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-left tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M9.7 14.4l-1.5 1.5L.3 8 8.2.1l1.5 1.5L3.3 8l6.4 6.4z\"/></svg>\n	</template>\n	<template class=\"tribe-events-c-top-bar__datepicker-template-next-icon\">\n		<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--caret-right tribe-events-c-top-bar__datepicker-nav-icon-svg\"  xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 10 16\" aria-hidden=\"true\"><path d=\"M.3 1.6L1.8.1 9.7 8l-7.9 7.9-1.5-1.5L6.7 8 .3 1.6z\"/></svg>\n	</template>\n</div>\n\n	<div class=\"tribe-events-c-top-bar__actions tribe-common-a11y-hidden\">\n	</div>\n\n</div>\n		</header>\n\n		\n		<div\n			class=\"tribe-events-calendar-month\"\n			role=\"grid\"\n			aria-labelledby=\"tribe-events-calendar-header\"\n			aria-readonly=\"true\"\n			data-js=\"tribe-events-month-grid\"\n		>\n\n			<header class=\"tribe-events-calendar-month__header\" role=\"rowgroup\">\n\n	<h2 class=\"tribe-common-a11y-visual-hide\" id=\"tribe-events-calendar-header\">\n		Calendar of Events	</h2>\n\n	<div role=\"row\" class=\"tribe-events-calendar-month__header-row\">\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Monday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						M					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Mon					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Tuesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Tue					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Wednesday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						W					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Wed					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Thursday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						T					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Thu					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Friday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						F					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Fri					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Saturday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sat					</span>\n				</h3>\n			</div>\n					<div\n				class=\"tribe-events-calendar-month__header-column\"\n				role=\"columnheader\"\n				aria-label=\"Sunday\"\n			>\n				<h3 class=\"tribe-events-calendar-month__header-column-title tribe-common-b3\">\n					<span class=\"tribe-events-calendar-month__header-column-title-mobile\">\n						S					</span>\n					<span class=\"tribe-events-calendar-month__header-column-title-desktop tribe-common-a11y-hidden\">\n						Sun					</span>\n				</h3>\n			</div>\n			</div>\n</header>\n\n			\n<div class=\"tribe-events-calendar-month__body\" role=\"rowgroup\">\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-29\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-29\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-29\"\n		>\n			29		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-29\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-29\"\n	>\n					29			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-30\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-30\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-30\"\n		>\n			30		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-30\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-30\"\n	>\n					30			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--past-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-01-31\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-01-31\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-01-31\"\n		>\n			31		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-01-31\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-01-31\"\n	>\n					31			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-03\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-3\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-03\"\n		>\n			3		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-03\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-03\"\n	>\n					3			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-04\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-4\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-04\"\n		>\n			4		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-04\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-04\"\n	>\n					4			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-05\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-5\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-05\"\n		>\n			5		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-05\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-05\"\n	>\n					5			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-06\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-6\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-06\"\n		>\n			6		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-06\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-06\"\n	>\n					6			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-07\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-7\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-07\"\n		>\n			7		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-07\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-07\"\n	>\n					7			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-08\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-8\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-08\"\n		>\n			8		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-08\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-08\"\n	>\n					8			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-09\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-9\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-09\"\n		>\n			9		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-09\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-09\"\n	>\n					9			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-10\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-10\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-10\"\n		>\n			10		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-10\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-10\"\n	>\n					10			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-11\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-11\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-11\"\n		>\n			11		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-11\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-11\"\n	>\n					11			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-12\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-12\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-12\"\n		>\n			12		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-12\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-12\"\n	>\n					12			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-13\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-13\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-13\"\n		>\n			13		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-13\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-13\"\n	>\n					13			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-14\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-14\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-14\"\n		>\n			14		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-14\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-14\"\n	>\n					14			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-15\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-15\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-15\"\n		>\n			15		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-15\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-15\"\n	>\n					15			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-16\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-16\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-16\"\n		>\n			16		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-16\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-16\"\n	>\n					16			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-17\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-17\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-17\"\n		>\n			17		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-17\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-17\"\n	>\n					17			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-18\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-18\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-18\"\n		>\n			18		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-18\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-18\"\n	>\n					18			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-19\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-19\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-19\"\n		>\n			19		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-19\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-19\"\n	>\n					19			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--past\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-20\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-20\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-20\"\n		>\n			20		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-20\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-20\"\n	>\n					20			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--current\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-21\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"true\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-21\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile tribe-events-calendar-month__day-cell--selected\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-21\"\n		>\n			21		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-21\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-21\"\n	>\n					21			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-22\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-22\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-22\"\n		>\n			22		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-22\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-22\"\n	>\n					22			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-23\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-23\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-23\"\n		>\n			23		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-23\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-23\"\n	>\n					23			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n		<div class=\"tribe-events-calendar-month__week\" role=\"row\" data-js=\"tribe-events-month-grid-row\">\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-24\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-24\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-24\"\n		>\n			24		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-24\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-24\"\n	>\n					24			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-25\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-25\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-25\"\n		>\n			25		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-25\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-25\"\n	>\n					25			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-26\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-26\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-26\"\n		>\n			26		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-26\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-26\"\n	>\n					26			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-27\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-27\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-27\"\n		>\n			27		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-27\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-27\"\n	>\n					27			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-02-28\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-02-28\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-02-28\"\n		>\n			28		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-02-28\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-02-28\"\n	>\n					28			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-01\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-1\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-01\"\n		>\n			1		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-01\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-01\"\n	>\n					1			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n				\n<div\n	 class=\"tribe-events-calendar-month__day tribe-events-calendar-month__day--other-month tribe-events-calendar-month__day--next-month\" 	role=\"gridcell\"\n	aria-labelledby=\"tribe-events-calendar-day-2025-03-02\"\n	data-js=\"tribe-events-month-grid-cell\"\n>\n	\n<button\n	aria-expanded=\"false\"\n	aria-controls=\"tribe-events-calendar-mobile-day-2025-03-2\"\n	 class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--mobile\" 	data-js=\"tribe-events-calendar-month-day-cell-mobile\"\n	tabindex=\"-1\"\n>\n	<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h6 tribe-common-h--alt\">\n		<span class=\"tribe-common-a11y-visual-hide\">\n			0 events,\n		</span>\n		<time\n			class=\"tribe-events-calendar-month__day-date-daynum\"\n			datetime=\"2025-03-02\"\n		>\n			2		</time>\n	</h3>\n	\n</button>\n	\n<div\n	id=\"tribe-events-calendar-day-2025-03-02\"\n	class=\"tribe-events-calendar-month__day-cell tribe-events-calendar-month__day-cell--desktop tribe-common-a11y-hidden\"\n>\n	\n<h3 class=\"tribe-events-calendar-month__day-date tribe-common-h4\">\n	<span class=\"tribe-common-a11y-visual-hide\">\n		0 events,\n	</span>\n	<time\n		class=\"tribe-events-calendar-month__day-date-daynum\"\n		datetime=\"2025-03-02\"\n	>\n					2			</time>\n</h3>\n	<div class=\"tribe-events-calendar-month__events\">\n		\n			</div>\n\n	\n</div>\n</div>\n\n			\n		</div>\n\n	\n</div>\n\n		</div>\n\n		<section class=\"tribe-events-calendar-month-mobile-events\" data-js=\"tribe-events-calendar-month-mobile-events\">\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-27\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-28\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-29\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-30\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-01-31\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-1\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-2\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-3\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-4\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-5\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-6\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-7\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-8\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-9\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-10\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-11\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-12\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-13\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-14\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-15\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-16\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-17\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-18\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-19\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-20\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day tribe-events-calendar-month-mobile-events__mobile-day--show\"  id=\"tribe-events-calendar-mobile-day-2025-02-21\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  class=\"tribe-common-c-svgicon tribe-common-c-svgicon--messages-not-found tribe-events-c-messages__message-icon-svg\"  viewBox=\"0 0 21 23\" xmlns=\"http://www.w3.org/2000/svg\"><g fill-rule=\"evenodd\"><path d=\"M.5 2.5h20v20H.5z\"/><path stroke-linecap=\"round\" d=\"M7.583 11.583l5.834 5.834m0-5.834l-5.834 5.834\" class=\"tribe-common-c-svgicon__svg-stroke\"/><path stroke-linecap=\"round\" d=\"M4.5.5v4m12-4v4\"/><path stroke-linecap=\"square\" d=\"M.5 7.5h20\"/></g></svg>\n			<ul class=\"tribe-events-c-messages__message-list\" role=\"alert\" aria-live=\"polite\">\n									<li\n						class=\"tribe-events-c-messages__message-list-item\"\n						 data-key=\"no-events-in-day\" 					>\n					There are no events on this day.					</li>\n							</ul>\n		</div>\n	</div>\n\n	</div>\n\n	\n		\n<div  class=\"tribe-events-calendar-month-mobile-events__mobile-day\"  id=\"tribe-events-calendar-mobile-day-2025-02-22\">\n\n	\n		<div  class=\"tribe-events-header__messages tribe-events-c-messages tribe-common-b2 tribe-events-header__messages--mobile tribe-events-header__messages--day\"  >\n			<div class=\"tribe-events-c-messages__message tribe-events-c-messages__message--notice\" role=\"alert\">\n			<svg  